/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.ShortDataBox;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;

public class VerticalIntDataBox
implements DataBox {
    private static final long serialVersionUID = 23L;
    private final int[][] data;
    private final int numRows;
    private final int numCols;

    public VerticalIntDataBox(int rows, int cols) {
        this.data = new int[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data[j][i] = -99;
            }
        }
        this.numRows = rows;
        this.numCols = cols;
    }

    public VerticalIntDataBox(int[][] data) {
        int length = data[0].length;
        for (int[] datum : data) {
            if (datum.length == length) continue;
            throw new IllegalArgumentException("All columns must have same length.");
        }
        this.numRows = data[0].length;
        this.numCols = data.length;
        this.data = data;
    }

    public VerticalIntDataBox(DataBox dataBox) {
        this.data = new int[dataBox.numCols()][dataBox.numRows()];
        for (int i = 0; i < dataBox.numRows(); ++i) {
            for (int j = 0; j < dataBox.numCols(); ++j) {
                this.data[j][i] = dataBox.get(i, j).intValue();
            }
        }
        this.numRows = dataBox.numRows();
        this.numCols = dataBox.numCols();
    }

    public static BoxDataSet serializableInstance() {
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < 4; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        return new BoxDataSet(new ShortDataBox(4, 4), vars);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    @Override
    public void set(int row, int col, Number value) {
        int[] ints = this.data[col];
        ints[row] = value == null ? -99 : value.intValue();
    }

    @Override
    public Number get(int row, int col) {
        int datum = this.data[col][row];
        if (datum == -99) {
            return null;
        }
        return datum;
    }

    public int[][] getVariableVectors() {
        return this.data;
    }

    @Override
    public DataBox copy() {
        double[][] copy = new double[this.numCols()][this.numRows()];
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numCols(); ++j) {
                copy[j][i] = this.data[j][i];
            }
        }
        return new VerticalDoubleDataBox(copy);
    }

    @Override
    public DataBox like() {
        return new VerticalIntDataBox(this.numRows, this.numCols);
    }

    @Override
    public DataBox viewSelection(int[] rows, int[] cols) {
        VerticalIntDataBox _dataBox = new VerticalIntDataBox(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                _dataBox.set(i, j, this.get(rows[i], cols[j]));
            }
        }
        return _dataBox;
    }
}

