/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.EdgeTypeProbability;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class Edge
implements TetradSerializable,
Comparable<Edge> {
    private static final long serialVersionUID = 23L;
    private final Node node1;
    private final Node node2;
    private Endpoint endpoint1;
    private Endpoint endpoint2;
    private transient Color lineColor;
    private boolean bold = false;
    private boolean highlighted = false;
    private List<Property> properties = new ArrayList<Property>();
    private List<EdgeTypeProbability> edgeTypeProbabilities = new ArrayList<EdgeTypeProbability>();
    private double probability;

    public Edge(Node node1, Node node2, Endpoint endpoint1, Endpoint endpoint2) {
        if (node1 == null || node2 == null) {
            throw new NullPointerException("Nodes must not be null. node1 = " + node1 + " node2 = " + node2);
        }
        if (endpoint1 == null || endpoint2 == null) {
            throw new NullPointerException("Endpoints must not be null.");
        }
        if (this.pointingLeft(endpoint1, endpoint2)) {
            this.node1 = node2;
            this.node2 = node1;
            this.endpoint1 = endpoint2;
            this.endpoint2 = endpoint1;
        } else {
            this.node1 = node1;
            this.node2 = node2;
            this.endpoint1 = endpoint1;
            this.endpoint2 = endpoint2;
        }
    }

    public Edge(Edge edge) {
        this(edge.node1, edge.node2, edge.endpoint1, edge.endpoint2);
        this.lineColor = edge.getLineColor();
        this.bold = edge.bold;
        this.highlighted = edge.highlighted;
        this.properties = new ArrayList<Property>(edge.properties);
        this.edgeTypeProbabilities = new ArrayList<EdgeTypeProbability>(edge.edgeTypeProbabilities);
        this.probability = edge.probability;
    }

    public static Edge serializableInstance() {
        return new Edge(GraphNode.serializableInstance(), GraphNode.serializableInstance(), Endpoint.ARROW, Endpoint.ARROW);
    }

    public final Node getNode1() {
        return this.node1;
    }

    public final Node getNode2() {
        return this.node2;
    }

    public final Endpoint getEndpoint1() {
        return this.endpoint1;
    }

    public final void setEndpoint1(Endpoint e) {
        this.endpoint1 = e;
    }

    public final Endpoint getEndpoint2() {
        return this.endpoint2;
    }

    public final void setEndpoint2(Endpoint e) {
        this.endpoint2 = e;
    }

    public final Endpoint getProximalEndpoint(Node node) {
        if (this.node1 == node) {
            return this.getEndpoint1();
        }
        if (this.node2 == node) {
            return this.getEndpoint2();
        }
        return null;
    }

    public final Endpoint getDistalEndpoint(Node node) {
        if (this.node1 == node) {
            return this.getEndpoint2();
        }
        if (this.node2 == node) {
            return this.getEndpoint1();
        }
        return null;
    }

    public final Node getDistalNode(Node node) {
        if (this.node1 == node) {
            return this.node2;
        }
        if (this.node2 == node) {
            return this.node1;
        }
        return null;
    }

    public boolean isDirected() {
        return Edges.isDirectedEdge(this);
    }

    public boolean pointsTowards(Node node) {
        Endpoint proximal = this.getProximalEndpoint(node);
        Endpoint distal = this.getDistalEndpoint(node);
        return proximal == Endpoint.ARROW && (distal == Endpoint.TAIL || distal == Endpoint.CIRCLE);
    }

    public Edge reverse() {
        return new Edge(this.getNode2(), this.getNode1(), this.getEndpoint1(), this.getEndpoint2());
    }

    public final String toString() {
        ArrayList<Property> properties;
        StringBuilder buf = new StringBuilder();
        Endpoint endptTypeA = this.getEndpoint1();
        Endpoint endptTypeB = this.getEndpoint2();
        buf.append(this.getNode1());
        buf.append(" ");
        if (this.isNull()) {
            buf.append("...");
        } else {
            if (endptTypeA == Endpoint.TAIL) {
                buf.append("-");
            } else if (endptTypeA == Endpoint.ARROW) {
                buf.append("<");
            } else if (endptTypeA == Endpoint.CIRCLE) {
                buf.append("o");
            }
            buf.append("-");
            if (endptTypeB == Endpoint.TAIL) {
                buf.append("-");
            } else if (endptTypeB == Endpoint.ARROW) {
                buf.append(">");
            } else if (endptTypeB == Endpoint.CIRCLE) {
                buf.append("o");
            }
        }
        buf.append(" ");
        buf.append(this.getNode2());
        List<EdgeTypeProbability> edgeTypeDist = this.getEdgeTypeProbabilities();
        if (edgeTypeDist.size() > 0) {
            buf.append(" ");
            String n1 = this.getNode1().getName();
            String n2 = this.getNode2().getName();
            for (EdgeTypeProbability etp : edgeTypeDist) {
                ArrayList<Property> properties2;
                double prob = etp.getProbability();
                if (!(prob > 0.0)) continue;
                StringBuilder _type = new StringBuilder("" + (Object)((Object)etp.getEdgeType()));
                switch (etp.getEdgeType()) {
                    case nil: {
                        _type = new StringBuilder("no edge");
                        break;
                    }
                    case ta: {
                        _type = new StringBuilder("-->");
                        break;
                    }
                    case at: {
                        _type = new StringBuilder("<--");
                        break;
                    }
                    case ca: {
                        _type = new StringBuilder("o->");
                        break;
                    }
                    case ac: {
                        _type = new StringBuilder("<-o");
                        break;
                    }
                    case cc: {
                        _type = new StringBuilder("o-o");
                        break;
                    }
                    case aa: {
                        _type = new StringBuilder("<->");
                        break;
                    }
                    case tt: {
                        _type = new StringBuilder("---");
                        break;
                    }
                }
                if (etp.getEdgeType() != EdgeTypeProbability.EdgeType.nil) {
                    _type = new StringBuilder(n1 + " " + _type + " " + n2);
                }
                if ((properties2 = etp.getProperties()) != null && properties2.size() > 0) {
                    for (Property property : properties2) {
                        _type.append(" ").append(property.toString());
                    }
                }
                buf.append("[").append((CharSequence)_type).append("]:").append(String.format("%.4f", prob)).append(";");
            }
            if (this.probability > 0.0) {
                buf.append(String.format("[edge]:%.4f", this.probability));
            }
        }
        if ((properties = this.getProperties()) != null && properties.size() > 0) {
            for (Property property : properties) {
                buf.append(" ");
                buf.append(property.toString());
            }
        }
        return buf.toString();
    }

    public final int hashCode() {
        return 1;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)o;
        Node node1 = this.getNode1();
        Node node2 = this.getNode2();
        Node node1b = edge.getNode1();
        Node node2b = edge.getNode2();
        Endpoint end1 = this.getEndpoint1();
        Endpoint end2 = this.getEndpoint2();
        Endpoint end1b = edge.getEndpoint1();
        Endpoint end2b = edge.getEndpoint2();
        boolean equals1 = node1 == node1b && node2 == node2b && end1 == end1b && end2 == end2b;
        boolean equals2 = node1 == node2b && node2 == node1b && end1 == end2b && end2 == end1b;
        return equals1 || equals2;
    }

    @Override
    public int compareTo(Edge _edge) {
        int comp1 = this.getNode1().compareTo(_edge.getNode1());
        if (comp1 != 0) {
            return comp1;
        }
        return this.getNode2().compareTo(_edge.getNode2());
    }

    private boolean pointingLeft(Endpoint endpoint1, Endpoint endpoint2) {
        return endpoint1 == Endpoint.ARROW && (endpoint2 == Endpoint.TAIL || endpoint2 == Endpoint.CIRCLE);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.node1 == null) {
            throw new NullPointerException();
        }
        if (this.node2 == null) {
            throw new NullPointerException();
        }
        if (this.endpoint1 == null) {
            throw new NullPointerException();
        }
        if (this.endpoint2 == null) {
            throw new NullPointerException();
        }
    }

    public boolean isNull() {
        return this.endpoint1 == Endpoint.NULL && this.endpoint2 == Endpoint.NULL;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void addProperty(Property property) {
        if (!this.properties.contains((Object)property)) {
            this.properties.add(property);
        }
    }

    public ArrayList<Property> getProperties() {
        return new ArrayList<Property>(this.properties);
    }

    public void addEdgeTypeProbability(EdgeTypeProbability prob) {
        if (!this.edgeTypeProbabilities.contains(prob)) {
            this.edgeTypeProbabilities.add(prob);
        }
    }

    public List<EdgeTypeProbability> getEdgeTypeProbabilities() {
        return this.edgeTypeProbabilities;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public static enum Property {
        dd,
        nl,
        pd,
        pl;

    }
}

