/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.graph.TripleClassifier;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EdgeListGraph
implements Graph,
TripleClassifier {
    private static final long serialVersionUID = 23L;
    final Set<Edge> edgesSet;
    Map<Node, Set<Edge>> edgeLists;
    private final List<Node> nodes;
    private final Map<String, Node> namesHash;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private transient PropertyChangeSupport pcs;
    private Set<Triple> underLineTriples = new HashSet<Triple>();
    private Set<Triple> dottedUnderLineTriples = new HashSet<Triple>();
    private Set<Triple> ambiguousTriples = new HashSet<Triple>();

    public EdgeListGraph() {
        this.edgeLists = new HashMap<Node, Set<Edge>>();
        this.nodes = new ArrayList<Node>();
        this.edgesSet = new HashSet<Edge>();
        this.namesHash = new HashMap<String, Node>();
    }

    public EdgeListGraph(Graph graph) throws IllegalArgumentException {
        this();
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.transferNodesAndEdges(graph);
        this.transferAttributes(graph);
        for (Node node : this.nodes) {
            this.namesHash.put(node.getName(), node);
        }
        this.underLineTriples = graph.getUnderLines();
        this.dottedUnderLineTriples = graph.getDottedUnderlines();
        this.ambiguousTriples = graph.getAmbiguousTriples();
    }

    public EdgeListGraph(EdgeListGraph graph) throws IllegalArgumentException {
        this.nodes = new ArrayList<Node>(graph.nodes);
        this.edgeLists = new HashMap<Node, Set<Edge>>();
        for (Node node : this.nodes) {
            this.edgeLists.put(node, Collections.synchronizedSet(graph.edgeLists.get(node)));
        }
        this.edgesSet = new HashSet<Edge>(graph.edgesSet);
        this.namesHash = new HashMap<String, Node>(graph.namesHash);
        this.underLineTriples = graph.getUnderLines();
        this.dottedUnderLineTriples = graph.getDottedUnderlines();
        this.ambiguousTriples = graph.getAmbiguousTriples();
    }

    public EdgeListGraph(List<Node> nodes) {
        this();
        if (nodes == null) {
            throw new NullPointerException();
        }
        for (Node variable : nodes) {
            if (this.addNode(variable)) continue;
            throw new IllegalArgumentException();
        }
        for (Node node : nodes) {
            this.namesHash.put(node.getName(), node);
        }
    }

    public static EdgeListGraph serializableInstance() {
        return new EdgeListGraph();
    }

    @Override
    public boolean addDirectedEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        return this.addEdge(Edges.directedEdge(node1, node2));
    }

    @Override
    public boolean addUndirectedEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        return this.addEdge(Edges.undirectedEdge(node1, node2));
    }

    @Override
    public boolean addNondirectedEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        return this.addEdge(Edges.nondirectedEdge(node1, node2));
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        return this.addEdge(Edges.partiallyOrientedEdge(node1, node2));
    }

    @Override
    public boolean addBidirectedEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        return this.addEdge(Edges.bidirectedEdge(node1, node2));
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        if (node1 == null || node2 == null || node3 == null) {
            return false;
        }
        List<Edge> edges = this.getEdges(node2);
        boolean circle12 = false;
        boolean circle32 = false;
        for (Edge edge : edges) {
            boolean _node3;
            boolean _node1 = edge.getDistalNode(node2) == node1;
            boolean bl = _node3 = edge.getDistalNode(node2) == node3;
            if (_node1 && edge.pointsTowards(node1)) {
                return true;
            }
            if (_node3 && edge.pointsTowards(node3)) {
                return true;
            }
            if (_node1 && edge.getProximalEndpoint(node2) == Endpoint.CIRCLE) {
                circle12 = true;
            }
            if (_node3 && edge.getProximalEndpoint(node2) == Endpoint.CIRCLE) {
                circle32 = true;
            }
            if (!circle12 || !circle32 || this.isAdjacentTo(node1, node2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        if (node1 == null || node2 == null || node3 == null) {
            return false;
        }
        Edge edge1 = this.getEdge(node1, node2);
        Edge edge2 = this.getEdge(node2, node3);
        if (edge1 == null || edge2 == null) {
            return false;
        }
        return edge1.getProximalEndpoint(node2) == Endpoint.ARROW && edge2.getProximalEndpoint(node2) == Endpoint.ARROW;
    }

    @Override
    public List<Node> getChildren(Node node) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (Edge edge : this.getEdges(node)) {
            Node sub;
            if (!Edges.isDirectedEdge(edge) || (sub = Edges.traverseDirected(node, edge)) == null) continue;
            children.add(sub);
        }
        return children;
    }

    @Override
    public int getDegree() {
        int connectivity = 0;
        List<Node> nodes = this.getNodes();
        for (Node node : nodes) {
            int n = this.getNumEdges(node);
            if (n <= connectivity) continue;
            connectivity = n;
        }
        return connectivity;
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        Set<Edge> edges = this.edgeLists.get(node1);
        if (edges == null) {
            return null;
        }
        for (Edge edge : edges) {
            if (edge.getNode1() == node1 && edge.getNode2() == node2) {
                return edge;
            }
            if (edge.getNode1() != node2 || edge.getNode2() != node1) continue;
            return edge;
        }
        return null;
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node1, node2);
        if (edges == null) {
            return null;
        }
        if (edges.size() == 0) {
            return null;
        }
        for (Edge edge : edges) {
            if (!Edges.isDirectedEdge(edge) || edge.getProximalEndpoint(node2) != Endpoint.ARROW) continue;
            return edge;
        }
        return null;
    }

    @Override
    public List<Node> getParents(Node node) {
        ArrayList<Node> parents = new ArrayList<Node>();
        Set<Edge> edges = this.edgeLists.get(node);
        if (edges == null) {
            throw new IllegalArgumentException("Node " + node + " is not in the graph.");
        }
        for (Edge edge : edges) {
            if (edge == null) continue;
            Endpoint endpoint1 = edge.getDistalEndpoint(node);
            Endpoint endpoint2 = edge.getProximalEndpoint(node);
            if (endpoint1 != Endpoint.TAIL || endpoint2 != Endpoint.ARROW) continue;
            parents.add(edge.getDistalNode(node));
        }
        return parents;
    }

    @Override
    public int getIndegree(Node node) {
        return this.getParents(node).size();
    }

    @Override
    public int getDegree(Node node) {
        return this.edgeLists.get(node).size();
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getChildren(node).size();
    }

    @Override
    public boolean isAdjacentTo(Node node1, Node node2) {
        if (node1 == null || node2 == null || this.edgeLists.get(node1) == null || this.edgeLists.get(node2) == null) {
            return false;
        }
        for (Edge edge : this.edgeLists.get(node1)) {
            if (Edges.traverse(node1, edge) != node2 || Edges.traverse(node2, edge) != node1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        for (Edge edge : this.getEdges(node2)) {
            Node sub = Edges.traverseDirected(node2, edge);
            if (sub != node1) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Node> getSepset(Node x, Node y) {
        return new Paths(this).getSepset(x, y);
    }

    public boolean isMSeparatedFrom(Node x, Node y, Set<Node> z) {
        return !new Paths(this).isMConnectedTo(x, y, z);
    }

    public boolean isMSeparatedFrom(Set<Node> x, Set<Node> y, Set<Node> z) {
        return !new Paths(this).isMConnectedTo(x, y, z);
    }

    public boolean isMSeparatedFrom(Set<Node> x, Set<Node> y, Set<Node> z, Map<Node, Set<Node>> ancestors) {
        return !new Paths(this).isMConnectedTo(x, y, z, ancestors);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        for (Edge edge : this.getEdges(node1)) {
            Node sub = Edges.traverseDirected(node1, edge);
            if (sub != node2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new NullPointerException("No graph was provided.");
        }
        for (Node node : graph.getNodes()) {
            if (this.addNode(node)) continue;
            throw new IllegalArgumentException();
        }
        for (Edge edge : graph.getEdges()) {
            if (this.addEdge(edge)) continue;
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void transferAttributes(Graph graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new NullPointerException("No graph was provided.");
        }
        this.attributes.putAll(graph.getAllAttributes());
    }

    @Override
    public Paths paths() {
        return new Paths(this);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getIndegree(node) == 0;
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        Set<Edge> edges = this.edgeLists.get(node);
        HashSet<Node> adj = new HashSet<Node>();
        for (Edge edge : edges) {
            if (edge == null) continue;
            adj.add(edge.getDistalNode(node));
        }
        return new ArrayList<Node>(adj);
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node1, node2);
        if (edges.size() > 1) {
            throw new IllegalStateException("There is more than one edge between " + node1 + " and " + node2);
        }
        this.removeTriplesNotInGraph();
        return this.removeEdges(edges);
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node2);
        for (Edge edge : edges) {
            if (edge.getDistalNode(node2) != node1) continue;
            return edge.getProximalEndpoint(node2);
        }
        return null;
    }

    @Override
    public boolean setEndpoint(Node from, Node to, Endpoint endPoint) throws IllegalArgumentException {
        if (!this.isAdjacentTo(from, to)) {
            throw new IllegalArgumentException("Not adjacent");
        }
        Edge edge = this.getEdge(from, to);
        this.removeEdge(edge);
        Edge newEdge = new Edge(from, to, edge.getProximalEndpoint(from), endPoint);
        this.addEdge(newEdge);
        return true;
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        List<Edge> edges = this.getEdges(node);
        for (Edge edge : edges) {
            if (edge.getProximalEndpoint(node) != endpoint) continue;
            nodes.add(edge.getDistalNode(node));
        }
        return nodes;
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint endpoint) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        List<Edge> edges = this.getEdges(node);
        for (Edge edge : edges) {
            if (edge.getDistalEndpoint(node) != endpoint) continue;
            nodes.add(edge.getDistalNode(node));
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addEdge(Edge edge) {
        Node node;
        Map<Node, Set<Edge>> edgeListMap;
        if (edge == null) {
            throw new NullPointerException("Null edge.");
        }
        Map<Node, Set<Edge>> map = edgeListMap = this.edgeLists;
        synchronized (map) {
            if (!this.edgeLists.containsKey(edge.getNode1()) || !this.edgeLists.containsKey(edge.getNode2())) {
                this.edgeLists = new HashMap<Node, Set<Edge>>(this.edgeLists);
            }
            this.edgeLists.get(edge.getNode1()).add(edge);
            this.edgeLists.get(edge.getNode2()).add(edge);
            this.edgesSet.add(edge);
        }
        if (Edges.isDirectedEdge(edge) && (node = Edges.getDirectedEdgeTail(edge)).getNodeType() == NodeType.ERROR) {
            this.getPcs().firePropertyChange("nodeAdded", null, node);
        }
        this.getPcs().firePropertyChange("edgeAdded", null, edge);
        return true;
    }

    @Override
    public boolean addNode(Node node) {
        if (this.nodes.contains(node)) {
            return true;
        }
        if (node == null) {
            throw new NullPointerException();
        }
        if (this.getNode(node.getName()) != null && this.nodes.contains(node)) {
            this.namesHash.put(node.getName(), node);
        }
        if (this.edgeLists.containsKey(node)) {
            return false;
        }
        this.edgeLists.put(node, new HashSet());
        this.nodes.add(node);
        this.namesHash.put(node.getName(), node);
        if (node.getNodeType() != NodeType.ERROR) {
            this.getPcs().firePropertyChange("nodeAdded", null, node);
        }
        return true;
    }

    @Override
    public Set<Edge> getEdges() {
        return new HashSet<Edge>(this.edgesSet);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.edgesSet.contains(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.nodes.contains(node);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        Set<Edge> list = this.edgeLists.get(node);
        if (list == null) {
            return new ArrayList<Edge>();
        }
        return new ArrayList<Edge>(list);
    }

    public int hashCode() {
        int hashCode = 0;
        for (Edge edge : this.getEdges()) {
            hashCode += edge.hashCode();
        }
        return new HashSet<Node>(this.nodes).hashCode() + hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof EdgeListGraph) {
            EdgeListGraph _o = (EdgeListGraph)o;
            boolean nodesEqual = new HashSet<Node>(_o.nodes).equals(new HashSet<Node>(this.nodes));
            boolean edgesEqual = new HashSet<Edge>(_o.edgesSet).equals(new HashSet<Edge>(this.edgesSet));
            return nodesEqual && edgesEqual;
        }
        Graph graph = (Graph)o;
        return new HashSet<String>(graph.getNodeNames()).equals(new HashSet<String>(this.getNodeNames())) && new HashSet<Edge>(graph.getEdges()).equals(new HashSet<Edge>(this.getEdges()));
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        this.edgesSet.clear();
        this.edgeLists.clear();
        for (Node node : this.nodes) {
            this.edgeLists.put(node, new HashSet());
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                Node node1 = this.nodes.get(i);
                Node node2 = this.nodes.get(j);
                Edge edge = new Edge(node1, node2, endpoint, endpoint);
                this.addEdge(edge);
            }
        }
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        for (Edge edge : this.getEdges()) {
            this.removeEdge(edge);
            Edge edge2 = new Edge(edge);
            edge2.setEndpoint1(endpoint);
            edge2.setEndpoint2(endpoint);
            this.addEdge(edge2);
        }
    }

    @Override
    public Node getNode(String name) {
        return this.namesHash.get(name);
    }

    @Override
    public int getNumNodes() {
        return this.nodes.size();
    }

    @Override
    public int getNumEdges() {
        return this.edgesSet.size();
    }

    @Override
    public int getNumEdges(Node node) {
        Set<Edge> list = this.edgeLists.get(node);
        return list == null ? 0 : list.size();
    }

    @Override
    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes);
    }

    @Override
    public void setNodes(List<Node> nodes) {
        if (nodes.size() != this.nodes.size()) {
            throw new IllegalArgumentException("Sorry, there is a mismatch in the number of variables you are trying to set.");
        }
        this.nodes.clear();
        this.nodes.addAll(nodes);
    }

    @Override
    public void clear() {
        Iterator<Edge> it = this.getEdges().iterator();
        while (it.hasNext()) {
            Edge edge = it.next();
            it.remove();
            this.getPcs().firePropertyChange("edgeRemoved", edge, null);
        }
        Iterator<Node> it2 = this.nodes.iterator();
        while (it2.hasNext()) {
            Node node = it2.next();
            it2.remove();
            this.namesHash.remove(node.getName());
            this.getPcs().firePropertyChange("nodeRemoved", node, null);
        }
        this.edgeLists.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEdge(Edge edge) {
        Map<Node, Set<Edge>> map = this.edgeLists;
        synchronized (map) {
            if (!this.edgesSet.contains(edge)) {
                return false;
            }
            Set<Edge> edgeList1 = this.edgeLists.get(edge.getNode1());
            Set<Edge> edgeList2 = this.edgeLists.get(edge.getNode2());
            edgeList1 = new HashSet<Edge>(edgeList1);
            edgeList2 = new HashSet<Edge>(edgeList2);
            this.edgesSet.remove(edge);
            edgeList1.remove(edge);
            edgeList2.remove(edge);
            this.edgeLists.put(edge.getNode1(), edgeList1);
            this.edgeLists.put(edge.getNode2(), edgeList2);
            this.getPcs().firePropertyChange("edgeRemoved", edge, null);
            return true;
        }
    }

    @Override
    public boolean removeEdges(Collection<Edge> edges) {
        boolean change = false;
        for (Edge edge : edges) {
            boolean _change = this.removeEdge(edge);
            change = change || _change;
        }
        return change;
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.removeEdges(this.getEdges(node1, node2));
    }

    @Override
    public boolean removeNode(Node node) {
        if (!this.nodes.contains(node)) {
            return false;
        }
        boolean changed = false;
        Set<Edge> edgeList1 = this.edgeLists.get(node);
        if (edgeList1 == null) {
            return true;
        }
        Iterator<Edge> i = edgeList1.iterator();
        while (i.hasNext()) {
            Edge edge = i.next();
            Node node2 = edge.getDistalNode(node);
            if (node2 != node) {
                Set<Edge> edgeList2 = this.edgeLists.get(node2);
                edgeList2.remove(edge);
                this.edgesSet.remove(edge);
                changed = true;
            }
            i.remove();
            this.getPcs().firePropertyChange("edgeRemoved", edge, null);
        }
        this.edgeLists.remove(node);
        this.nodes.remove(node);
        this.namesHash.remove(node.getName());
        this.removeTriplesNotInGraph();
        this.getPcs().firePropertyChange("nodeRemoved", node, null);
        return changed;
    }

    @Override
    public boolean removeNodes(List<Node> newNodes) {
        boolean changed = false;
        for (Node node : newNodes) {
            boolean _changed = this.removeNode(node);
            changed = changed || _changed;
        }
        return changed;
    }

    @Override
    public String toString() {
        return GraphUtils.graphToText(this, false);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        EdgeListGraph graph = new EdgeListGraph(nodes);
        Set<Edge> edges = this.getEdges();
        for (Edge edge : edges) {
            if (!nodes.contains(edge.getNode1()) || !nodes.contains(edge.getNode2())) continue;
            graph.addEdge(edge);
        }
        return graph;
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        Set<Edge> edges = this.edgeLists.get(node1);
        if (edges == null) {
            return new ArrayList<Edge>();
        }
        ArrayList<Edge> _edges = new ArrayList<Edge>();
        for (Edge edge : edges) {
            if (edge.getDistalNode(node1) != node2) continue;
            _edges.add(edge);
        }
        return _edges;
    }

    @Override
    public List<String> getNodeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : this.getNodes()) {
            names.add(node.getName());
        }
        return names;
    }

    protected PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    @Override
    public boolean isParameterizable(Node node) {
        return true;
    }

    @Override
    public boolean isTimeLagModel() {
        return false;
    }

    @Override
    public TimeLagGraph getTimeLagGraph() {
        return null;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.nodes == null) {
            throw new NullPointerException();
        }
        if (this.edgesSet == null) {
            throw new NullPointerException();
        }
        if (this.edgeLists == null) {
            throw new NullPointerException();
        }
    }

    public void changeName(String name, String newName) {
        Node node = this.namesHash.get(name);
        this.namesHash.remove(name);
        node.setName(newName);
        this.namesHash.put(newName, node);
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    @Override
    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    @Override
    public void setAmbiguousTriples(Set<Triple> triples) {
        this.ambiguousTriples.clear();
        for (Triple triple : triples) {
            this.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public Set<Triple> getUnderLines() {
        return new HashSet<Triple>(this.underLineTriples);
    }

    @Override
    public Set<Triple> getDottedUnderlines() {
        return new HashSet<Triple>(this.dottedUnderLineTriples);
    }

    @Override
    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        return this.ambiguousTriples.contains(new Triple(x, y, z));
    }

    @Override
    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        return this.underLineTriples.contains(new Triple(x, y, z));
    }

    @Override
    public void addAmbiguousTriple(Node x, Node y, Node z) {
        this.ambiguousTriples.add(new Triple(x, y, z));
    }

    @Override
    public void addUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            return;
        }
        this.underLineTriples.add(new Triple(x, y, z));
    }

    @Override
    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            return;
        }
        this.dottedUnderLineTriples.add(triple);
    }

    @Override
    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.ambiguousTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.underLineTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.dottedUnderLineTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void setUnderLineTriples(Set<Triple> triples) {
        this.underLineTriples.clear();
        for (Triple triple : triples) {
            this.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.dottedUnderLineTriples.clear();
        for (Triple triple : triples) {
            this.addDottedUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public void removeTriplesNotInGraph() {
        for (Triple triple : new HashSet<Triple>(this.ambiguousTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.ambiguousTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.ambiguousTriples.remove(triple);
        }
        for (Triple triple : new HashSet<Triple>(this.underLineTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.underLineTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.underLineTriples.remove(triple);
        }
        for (Triple triple : new HashSet<Triple>(this.dottedUnderLineTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.dottedUnderLineTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && !this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.dottedUnderLineTriples.remove(triple);
        }
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Underlines");
        names.add("Dotted Underlines");
        names.add("Ambiguous Triples");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        triplesList.add(GraphUtils.getUnderlinedTriplesFromGraph(node, this));
        triplesList.add(GraphUtils.getDottedUnderlinedTriplesFromGraph(node, this));
        triplesList.add(GraphUtils.getAmbiguousTriplesFromGraph(node, this));
        return triplesList;
    }
}

