/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.EdgeTypeProbability;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.cmu.tetrad.util.JsonUtils;
import edu.cmu.tetrad.util.PointXy;
import edu.cmu.tetrad.util.TextTable;
import edu.pitt.dbmi.data.reader.Data;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularDatasetFileReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.Text;

public class GraphSaveLoadUtils {
    public static Graph loadGraph(File file) {
        Graph graph;
        try {
            Element root = GraphSaveLoadUtils.getRootElement(file);
            graph = GraphSaveLoadUtils.parseGraphXml(root, null);
        }
        catch (ParsingException e1) {
            throw new IllegalArgumentException("Could not parse " + file, e1);
        }
        catch (IOException e1) {
            throw new IllegalArgumentException("Could not read " + file, e1);
        }
        return graph;
    }

    public static Graph loadGraphTxt(File file) {
        try {
            FileReader in1 = new FileReader(file);
            return GraphSaveLoadUtils.readerToGraphTxt(in1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static Graph loadGraphRuben(File file) {
        try {
            String commentMarker = "//";
            int quoteCharacter = 34;
            String missingValueMarker = "*";
            boolean hasHeader = false;
            DataSet dataSet = SimpleDataLoader.loadContinuousData(file, "//", '\"', "*", false, Delimiter.COMMA, false);
            List<Node> nodes = dataSet.getVariables();
            EdgeListGraph graph = new EdgeListGraph(nodes);
            for (int i = 0; i < nodes.size(); ++i) {
                for (int j = i + 1; j < nodes.size(); ++j) {
                    if (dataSet.getDouble(i, j) == 0.0) continue;
                    graph.addDirectedEdge(nodes.get(i), nodes.get(j));
                }
            }
            return graph;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static Graph loadGraphJson(File file) {
        try {
            FileReader in1 = new FileReader(file);
            return GraphSaveLoadUtils.readerToGraphJson(in1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    private static int[][] incidenceMatrix(Graph graph) throws IllegalArgumentException {
        List<Node> nodes = graph.getNodes();
        int[][] m = new int[nodes.size()][nodes.size()];
        for (Edge edge : graph.getEdges()) {
            if (Edges.isDirectedEdge(edge)) continue;
            throw new IllegalArgumentException("Not a directed graph.");
        }
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                Node x2;
                Node x1 = nodes.get(i);
                Edge edge = graph.getEdge(x1, x2 = nodes.get(j));
                if (edge == null) {
                    m[i][j] = 0;
                    continue;
                }
                if (edge.getProximalEndpoint(x1) == Endpoint.ARROW) {
                    m[i][j] = 1;
                    continue;
                }
                if (edge.getProximalEndpoint(x1) != Endpoint.TAIL) continue;
                m[i][j] = -1;
            }
        }
        return m;
    }

    public static Graph loadGraphBNTPcMatrix(List<Node> vars, DataSet dataSet) {
        EdgeListGraph graph = new EdgeListGraph(vars);
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                int g = dataSet.getInt(i, j);
                int h = dataSet.getInt(j, i);
                if (g == 1 && h == 1 && !graph.isAdjacentTo(vars.get(i), vars.get(j))) {
                    graph.addUndirectedEdge(vars.get(i), vars.get(j));
                    continue;
                }
                if (g != -1 || h != 0) continue;
                graph.addDirectedEdge(vars.get(i), vars.get(j));
            }
        }
        return graph;
    }

    public static String graphRMatrixTxt(Graph graph) throws IllegalArgumentException {
        int j;
        int i;
        int[][] m = GraphSaveLoadUtils.incidenceMatrix(graph);
        TextTable table = new TextTable(m[0].length + 1, m.length + 1);
        for (i = 0; i < m.length; ++i) {
            for (j = 0; j < m[0].length; ++j) {
                table.setToken(i + 1, j + 1, String.valueOf(m[i][j]));
            }
        }
        for (i = 0; i < m.length; ++i) {
            table.setToken(i + 1, 0, String.valueOf(i + 1));
        }
        List<Node> nodes = graph.getNodes();
        for (j = 0; j < m[0].length; ++j) {
            table.setToken(0, j + 1, nodes.get(j).getName());
        }
        return table.toString();
    }

    public static Graph loadRSpecial(File file) {
        DataSet eg = null;
        try {
            ContinuousTabularDatasetFileReader reader = new ContinuousTabularDatasetFileReader(file.toPath(), Delimiter.COMMA);
            reader.setHasHeader(false);
            Data data = reader.readInData();
            eg = (DataSet)DataConvertUtils.toDataModel(data);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        if (eg == null) {
            throw new NullPointerException();
        }
        List<Node> vars = eg.getVariables();
        EdgeListGraph graph = new EdgeListGraph(vars);
        for (int i = 0; i < vars.size(); ++i) {
            for (int j = 0; j < vars.size(); ++j) {
                if (i == j) continue;
                if (eg.getDouble(i, j) == 1.0 && eg.getDouble(j, i) == 1.0) {
                    if (graph.isAdjacentTo(vars.get(i), vars.get(j))) continue;
                    graph.addUndirectedEdge(vars.get(i), vars.get(j));
                    continue;
                }
                if (eg.getDouble(i, j) != 1.0 || eg.getDouble(j, i) != 0.0) continue;
                graph.addDirectedEdge(vars.get(i), vars.get(j));
            }
        }
        return graph;
    }

    public static Graph loadGraphPcalg(File file) {
        try {
            DataSet dataSet = SimpleDataLoader.loadContinuousData(file, "//", '\"', "*", true, Delimiter.COMMA, false);
            List<Node> nodes = dataSet.getVariables();
            EdgeListGraph graph = new EdgeListGraph(nodes);
            for (int i = 0; i < nodes.size(); ++i) {
                for (int j = i + 1; j < nodes.size(); ++j) {
                    Endpoint e2a;
                    Endpoint e1a;
                    Node n1 = nodes.get(i);
                    Node n2 = nodes.get(j);
                    int e1 = dataSet.getInt(j, i);
                    int e2 = dataSet.getInt(i, j);
                    switch (e1) {
                        case 0: {
                            e1a = Endpoint.NULL;
                            break;
                        }
                        case 1: {
                            e1a = Endpoint.CIRCLE;
                            break;
                        }
                        case 2: {
                            e1a = Endpoint.ARROW;
                            break;
                        }
                        case 3: {
                            e1a = Endpoint.TAIL;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected endpoint type: " + e1);
                        }
                    }
                    switch (e2) {
                        case 0: {
                            e2a = Endpoint.NULL;
                            break;
                        }
                        case 1: {
                            e2a = Endpoint.CIRCLE;
                            break;
                        }
                        case 2: {
                            e2a = Endpoint.ARROW;
                            break;
                        }
                        case 3: {
                            e2a = Endpoint.TAIL;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected endpoint type: " + e1);
                        }
                    }
                    if (e1a == Endpoint.NULL || e2a == Endpoint.NULL) continue;
                    Edge edge = new Edge(n1, n2, e1a, e2a);
                    graph.addEdge(edge);
                }
            }
            return graph;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static String loadGraphRMatrix(Graph graph) throws IllegalArgumentException {
        int j;
        int i;
        int[][] m = GraphSaveLoadUtils.incidenceMatrix(graph);
        TextTable table = new TextTable(m[0].length + 1, m.length + 1);
        for (i = 0; i < m.length; ++i) {
            for (j = 0; j < m[0].length; ++j) {
                table.setToken(i + 1, j + 1, String.valueOf(m[i][j]));
            }
        }
        for (i = 0; i < m.length; ++i) {
            table.setToken(i + 1, 0, String.valueOf(i + 1));
        }
        List<Node> nodes = graph.getNodes();
        for (j = 0; j < m[0].length; ++j) {
            table.setToken(0, j + 1, nodes.get(j).getName());
        }
        return table.toString();
    }

    public static Graph readerToGraphTxt(String graphString) throws IOException {
        return GraphSaveLoadUtils.readerToGraphTxt(new CharArrayReader(graphString.toCharArray()));
    }

    public static Graph readerToGraphTxt(Reader reader) throws IOException {
        EdgeListGraph graph = new EdgeListGraph();
        try (BufferedReader in = new BufferedReader(reader);){
            String line = in.readLine();
            while (line != null) {
                switch (line = line.trim()) {
                    case "Graph Nodes:": {
                        GraphSaveLoadUtils.extractGraphNodes(graph, in);
                        break;
                    }
                    case "Graph Edges:": {
                        GraphSaveLoadUtils.extractGraphEdges(graph, in);
                    }
                }
                line = in.readLine();
            }
        }
        return graph;
    }

    public static PrintWriter saveGraph(Graph graph, File file, boolean xml) {
        PrintWriter out;
        try {
            out = new PrintWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]));
            if (xml) {
                out.print(GraphSaveLoadUtils.graphToXml(graph));
            } else {
                out.print(graph);
            }
            out.flush();
            out.close();
        }
        catch (IOException e1) {
            throw new IllegalArgumentException("Output file could not be opened: " + file);
        }
        return out;
    }

    public static Graph readerToGraphRuben(Reader reader) throws IOException {
        EdgeListGraph graph = new EdgeListGraph();
        try (BufferedReader in = new BufferedReader(reader);){
            String line = in.readLine();
            while (line != null) {
                switch (line = line.trim()) {
                    case "Graph Nodes:": {
                        GraphSaveLoadUtils.extractGraphNodes(graph, in);
                        break;
                    }
                    case "Graph Edges:": {
                        GraphSaveLoadUtils.extractGraphEdges(graph, in);
                    }
                }
                line = in.readLine();
            }
        }
        return graph;
    }

    private static void extractGraphEdges(Graph graph, BufferedReader in) throws IOException {
        Pattern lineNumPattern = Pattern.compile("^\\d+.\\s?");
        Pattern spacePattern = Pattern.compile("\\s+");
        Pattern semicolonPattern = Pattern.compile(";");
        Pattern colonPattern = Pattern.compile(":");
        String line = in.readLine();
        while (line != null) {
            if ((line = line.trim()).isEmpty()) {
                return;
            }
            line = lineNumPattern.matcher(line).replaceAll("");
            String[] fields = spacePattern.split(line, 4);
            Edge edge = GraphSaveLoadUtils.getEdge(fields[0], fields[1], fields[2], graph);
            if (fields.length > 3) {
                if ((fields = semicolonPattern.split(fields[3])).length > 1) {
                    for (String prop : fields) {
                        GraphSaveLoadUtils.setEdgeTypeProperties(edge, prop, spacePattern, colonPattern);
                    }
                } else {
                    GraphSaveLoadUtils.getEdgeProperties(fields[0], spacePattern).forEach(edge::addProperty);
                }
            }
            graph.addEdge(edge);
            line = in.readLine();
        }
    }

    private static void setEdgeTypeProperties(Edge edge, String prop, Pattern spacePattern, Pattern colonPattern) {
        String[] fields = colonPattern.split(prop = prop.replace("[", "").replace("]", ""));
        if (fields.length == 2) {
            String bootstrapEdge = fields[0];
            String bootstrapEdgeTypeProb = fields[1];
            fields = spacePattern.split(bootstrapEdge, 4);
            if (fields.length >= 3) {
                EdgeTypeProbability.EdgeType edgeType = GraphSaveLoadUtils.getEdgeType(fields[1]);
                LinkedList<Edge.Property> properties = new LinkedList<Edge.Property>();
                if (fields.length > 3) {
                    properties.addAll(GraphSaveLoadUtils.getEdgeProperties(fields[3], spacePattern));
                }
                edge.addEdgeTypeProbability(new EdgeTypeProbability(edgeType, properties, Double.parseDouble(bootstrapEdgeTypeProb)));
            } else if ("edge".equals(bootstrapEdge)) {
                fields = spacePattern.split(bootstrapEdgeTypeProb, 2);
                if (fields.length > 1) {
                    edge.setProbability(Double.parseDouble(fields[0]));
                    GraphSaveLoadUtils.getEdgeProperties(fields[1], spacePattern).forEach(edge::addProperty);
                } else {
                    edge.setProbability(Double.parseDouble(bootstrapEdgeTypeProb));
                }
            } else if ("no edge".equals(bootstrapEdge)) {
                edge.addEdgeTypeProbability(new EdgeTypeProbability(EdgeTypeProbability.EdgeType.nil, Double.parseDouble(bootstrapEdgeTypeProb)));
            }
        }
    }

    private static EdgeTypeProbability.EdgeType getEdgeType(String edgeType) {
        Endpoint endpointFrom = GraphSaveLoadUtils.getEndpoint(edgeType.charAt(0));
        Endpoint endpointTo = GraphSaveLoadUtils.getEndpoint(edgeType.charAt(2));
        if (endpointFrom == Endpoint.TAIL && endpointTo == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.ta;
        }
        if (endpointFrom == Endpoint.ARROW && endpointTo == Endpoint.TAIL) {
            return EdgeTypeProbability.EdgeType.at;
        }
        if (endpointFrom == Endpoint.CIRCLE && endpointTo == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.ca;
        }
        if (endpointFrom == Endpoint.ARROW && endpointTo == Endpoint.CIRCLE) {
            return EdgeTypeProbability.EdgeType.ac;
        }
        if (endpointFrom == Endpoint.CIRCLE && endpointTo == Endpoint.CIRCLE) {
            return EdgeTypeProbability.EdgeType.cc;
        }
        if (endpointFrom == Endpoint.ARROW && endpointTo == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.aa;
        }
        if (endpointFrom == Endpoint.TAIL && endpointTo == Endpoint.TAIL) {
            return EdgeTypeProbability.EdgeType.tt;
        }
        return EdgeTypeProbability.EdgeType.nil;
    }

    private static List<Edge.Property> getEdgeProperties(String props, Pattern spacePattern) {
        LinkedList<Edge.Property> properties = new LinkedList<Edge.Property>();
        for (String prop : spacePattern.split(props)) {
            if ("dd".equals(prop)) {
                properties.add(Edge.Property.dd);
                continue;
            }
            if ("nl".equals(prop)) {
                properties.add(Edge.Property.nl);
                continue;
            }
            if ("pd".equals(prop)) {
                properties.add(Edge.Property.pd);
                continue;
            }
            if (!"pl".equals(prop)) continue;
            properties.add(Edge.Property.pl);
        }
        return properties;
    }

    private static void extractGraphNodes(Graph graph, BufferedReader in) throws IOException {
        String line = in.readLine();
        while (line != null && !(line = line.trim()).isEmpty()) {
            String[] tokens;
            for (String token : tokens = line.split("[,;]")) {
                GraphNode node;
                if (token.startsWith("(") && token.endsWith(")")) {
                    token = token.replace("(", "");
                    token = token.replace(")", "");
                    node = new GraphNode(token);
                    node.setNodeType(NodeType.LATENT);
                    graph.addNode(node);
                    continue;
                }
                node = new GraphNode(token);
                node.setNodeType(NodeType.MEASURED);
                graph.addNode(node);
            }
            line = in.readLine();
        }
    }

    public static Graph readerToGraphJson(Reader reader) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        StringBuilder json = new StringBuilder();
        while ((line = in.readLine()) != null) {
            json.append(line.trim());
        }
        return JsonUtils.parseJSONObjectToTetradGraph(json.toString());
    }

    public static String graphToDot(Graph graph) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph g {\n");
        ArrayList<Edge> edges = new ArrayList<Edge>(graph.getEdges());
        Collections.sort(edges);
        for (Edge edge : edges) {
            String n1 = edge.getNode1().getName();
            String n2 = edge.getNode2().getName();
            Endpoint end1 = edge.getEndpoint1();
            Endpoint end2 = edge.getEndpoint2();
            if (end1 == Endpoint.NULL || end2 == Endpoint.NULL) continue;
            builder.append(" \"").append(n1).append("\" -> \"").append(n2).append("\" [");
            if (end1 != Endpoint.TAIL) {
                builder.append("dir=both, ");
            }
            builder.append("arrowtail=");
            if (end1 == Endpoint.ARROW) {
                builder.append("normal");
            } else if (end1 == Endpoint.TAIL) {
                builder.append("none");
            } else if (end1 == Endpoint.CIRCLE) {
                builder.append("odot");
            } else {
                builder.append("xdot");
            }
            builder.append(", arrowhead=");
            if (end2 == Endpoint.ARROW) {
                builder.append("normal");
            } else if (end2 == Endpoint.TAIL) {
                builder.append("none");
            } else if (end2 == Endpoint.CIRCLE) {
                builder.append("odot");
            } else {
                builder.append("xdot");
            }
            List<EdgeTypeProbability> edgeTypeProbabilities = edge.getEdgeTypeProbabilities();
            if (edgeTypeProbabilities != null && !edgeTypeProbabilities.isEmpty()) {
                StringBuilder label = new StringBuilder(n1 + " - " + n2);
                for (EdgeTypeProbability edgeTypeProbability : edgeTypeProbabilities) {
                    EdgeTypeProbability.EdgeType edgeType = edgeTypeProbability.getEdgeType();
                    double probability = edgeTypeProbability.getProbability();
                    if (!(probability > 0.0)) continue;
                    StringBuilder edgeTypeString = new StringBuilder();
                    switch (edgeType) {
                        case nil: {
                            edgeTypeString = new StringBuilder("no edge");
                            break;
                        }
                        case ta: {
                            edgeTypeString = new StringBuilder("-->");
                            break;
                        }
                        case at: {
                            edgeTypeString = new StringBuilder("<--");
                            break;
                        }
                        case ca: {
                            edgeTypeString = new StringBuilder("o->");
                            break;
                        }
                        case ac: {
                            edgeTypeString = new StringBuilder("<-o");
                            break;
                        }
                        case cc: {
                            edgeTypeString = new StringBuilder("o-o");
                            break;
                        }
                        case aa: {
                            edgeTypeString = new StringBuilder("<->");
                            break;
                        }
                        case tt: {
                            edgeTypeString = new StringBuilder("---");
                        }
                    }
                    ArrayList<Edge.Property> properties = edgeTypeProbability.getProperties();
                    if (properties != null && properties.size() > 0) {
                        for (Edge.Property property : properties) {
                            edgeTypeString.append(" ").append(property.toString());
                        }
                    }
                    DecimalFormat nf = new DecimalFormat("0.000");
                    label.append("\\n[").append((CharSequence)edgeTypeString).append("]:").append(nf.format(edgeTypeProbability.getProbability()));
                }
                builder.append(", label=\"").append((CharSequence)label).append("\", fontname=courier");
            }
            builder.append("]; \n");
        }
        builder.append("}");
        return builder.toString();
    }

    public static void graphToDot(Graph graph, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(GraphSaveLoadUtils.graphToDot(graph));
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Element convertToXml(Graph graph) {
        Set<Triple> dottedTriples;
        Set<Triple> underlineTriples;
        Element element = new Element("graph");
        Element variables = new Element("variables");
        element.appendChild(variables);
        for (Node node : graph.getNodes()) {
            Element variable = new Element("variable");
            Text text = new Text(node.getName());
            variable.appendChild(text);
            variables.appendChild(variable);
        }
        Element edges = new Element("edges");
        element.appendChild(edges);
        for (Edge edge : graph.getEdges()) {
            Element _edge = new Element("edge");
            Text text = new Text(edge.toString());
            _edge.appendChild(text);
            edges.appendChild(_edge);
        }
        Set<Triple> set = graph.getAmbiguousTriples();
        if (!set.isEmpty()) {
            Element underlinings = new Element("ambiguities");
            element.appendChild(underlinings);
            for (Triple triple : set) {
                Element underlining = new Element("ambiguities");
                Text text = new Text(GraphSaveLoadUtils.niceTripleString(triple));
                underlining.appendChild(text);
                underlinings.appendChild(underlining);
            }
        }
        if (!(underlineTriples = graph.getUnderLines()).isEmpty()) {
            Element underlinings = new Element("underlines");
            element.appendChild(underlinings);
            for (Triple triple : underlineTriples) {
                Element underlining = new Element("underline");
                Text text = new Text(GraphSaveLoadUtils.niceTripleString(triple));
                underlining.appendChild(text);
                underlinings.appendChild(underlining);
            }
        }
        if (!(dottedTriples = graph.getDottedUnderlines()).isEmpty()) {
            Element element2 = new Element("dottedUnderlines");
            element.appendChild(element2);
            for (Triple triple : dottedTriples) {
                Element dottedUnderlining = new Element("dottedUnderline");
                Text text = new Text(GraphSaveLoadUtils.niceTripleString(triple));
                dottedUnderlining.appendChild(text);
                element2.appendChild(dottedUnderlining);
            }
        }
        return element;
    }

    private static String niceTripleString(Triple triple) {
        return triple.getX() + ", " + triple.getY() + ", " + triple.getZ();
    }

    public static String graphToXml(Graph graph) {
        Document document = new Document(GraphSaveLoadUtils.convertToXml(graph));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Serializer serializer = new Serializer(out);
        serializer.setLineSeparator("\n");
        serializer.setIndent(2);
        try {
            serializer.write(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)out).toString();
    }

    public static String graphToLavaan(Graph g) {
        boolean bl;
        boolean includeIntercepts = true;
        boolean includeErrors = true;
        HashMap parents = new HashMap();
        HashMap siblings = new HashMap();
        StringBuilder lavaan = new StringBuilder();
        for (Node node : g.getNodes()) {
            if (includeIntercepts) {
                lavaan.append(node.getName()).append(" ~ 1\n");
            }
            parents.put(node, new ArrayList());
            siblings.put(node, new ArrayList());
            for (Edge e : g.getEdges(node)) {
                Node b = e.getDistalNode(node);
                if (e.getProximalEndpoint(node) != Endpoint.ARROW) continue;
                if (e.getProximalEndpoint(b) == Endpoint.TAIL) {
                    ((List)parents.get(node)).add(b);
                }
                if (siblings.containsKey(b) || e.getProximalEndpoint(b) != Endpoint.ARROW) continue;
                ((List)siblings.get(node)).add(b);
            }
        }
        if (includeIntercepts) {
            lavaan.append("\n");
        }
        boolean hasDirected = false;
        for (Node a : g.getNodes()) {
            Iterator itr = ((List)parents.get(a)).iterator();
            if (!itr.hasNext()) continue;
            hasDirected = true;
            lavaan.append(a.getName()).append(" ~ ").append(((Node)itr.next()).getName());
            while (itr.hasNext()) {
                lavaan.append(" + ").append(((Node)itr.next()).getName());
            }
            lavaan.append("\n");
        }
        if (hasDirected) {
            lavaan.append("\n");
        }
        boolean bl2 = false;
        for (Node a : g.getNodes()) {
            Iterator itr = ((List)siblings.get(a)).iterator();
            if (!itr.hasNext()) continue;
            bl = true;
            lavaan.append(a.getName()).append(" ~~ ").append(((Node)itr.next()).getName());
            while (itr.hasNext()) {
                lavaan.append(" + ").append(((Node)itr.next()).getName());
            }
            lavaan.append("\n");
        }
        if (bl) {
            lavaan.append("\n");
        }
        for (Node a : g.getNodes()) {
            if (!includeErrors) continue;
            lavaan.append(a.getName()).append(" ~~ ").append(a.getName()).append("\n");
        }
        return lavaan.toString();
    }

    public static String graphToPcalg(Graph g) {
        HashMap<Endpoint, Integer> mark2Int = new HashMap<Endpoint, Integer>();
        mark2Int.put(Endpoint.NULL, 0);
        mark2Int.put(Endpoint.CIRCLE, 1);
        mark2Int.put(Endpoint.ARROW, 2);
        mark2Int.put(Endpoint.TAIL, 3);
        int n = g.getNumNodes();
        int[][] A = new int[n][n];
        List<Node> nodes = g.getNodes();
        for (Edge edge : g.getEdges()) {
            int i = nodes.indexOf(edge.getNode1());
            int j = nodes.indexOf(edge.getNode2());
            A[j][i] = (Integer)mark2Int.get(edge.getEndpoint1());
            A[i][j] = (Integer)mark2Int.get(edge.getEndpoint2());
        }
        TextTable table = new TextTable(n + 1, n);
        table.setDelimiter(TextTable.Delimiter.COMMA);
        for (int j = 0; j < n; ++j) {
            table.setToken(0, j, nodes.get(j).getName());
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                table.setToken(i + 1, j, String.valueOf(A[i][j]));
            }
        }
        return table.toString();
    }

    public static Graph parseGraphXml(Element graphElement, Map<String, Node> nodes) throws ParsingException {
        Set<Triple> triples;
        Element ambiguitiesElement;
        if (!"graph".equals(graphElement.getLocalName())) {
            throw new IllegalArgumentException("Expecting graph element: " + graphElement.getLocalName());
        }
        if (!"variables".equals(graphElement.getChildElements().get(0).getLocalName())) {
            throw new ParsingException("Expecting variables element: " + graphElement.getChildElements().get(0).getLocalName());
        }
        Element variablesElement = graphElement.getChildElements().get(0);
        Elements variableElements = variablesElement.getChildElements();
        ArrayList<Node> variables = new ArrayList<Node>();
        for (int i = 0; i < variableElements.size(); ++i) {
            Element variableElement = variableElements.get(i);
            if (!"variable".equals(variablesElement.getChildElements().get(i).getLocalName())) {
                throw new ParsingException("Expecting variable element.");
            }
            String value = variableElement.getValue();
            if (nodes == null) {
                variables.add(new GraphNode(value));
                continue;
            }
            variables.add(nodes.get(value));
        }
        EdgeListGraph graph = new EdgeListGraph(variables);
        if (!"edges".equals(graphElement.getChildElements().get(1).getLocalName())) {
            throw new ParsingException("Expecting edges element.");
        }
        Element edgesElement = graphElement.getChildElements().get(1);
        Elements edgesElements = edgesElement.getChildElements();
        for (int i = 0; i < edgesElements.size(); ++i) {
            Endpoint endpoint2;
            Endpoint endpoint1;
            Element edgeElement = edgesElements.get(i);
            if (!"edge".equals(edgeElement.getLocalName())) {
                throw new ParsingException("Expecting edge element: " + edgeElement.getLocalName());
            }
            String value = edgeElement.getValue();
            String regex = "([A-Za-z0-9_-]*:?[A-Za-z0-9_-]*) ?(.)-(.) ?([A-Za-z0-9_-]*:?[A-Za-z0-9_-]*)";
            Pattern pattern = Pattern.compile("([A-Za-z0-9_-]*:?[A-Za-z0-9_-]*) ?(.)-(.) ?([A-Za-z0-9_-]*:?[A-Za-z0-9_-]*)");
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) {
                throw new ParsingException("Edge doesn't match pattern.");
            }
            String var1 = matcher.group(1);
            String leftEndpoint = matcher.group(2);
            String rightEndpoint = matcher.group(3);
            String var2 = matcher.group(4);
            Node node1 = graph.getNode(var1);
            Node node2 = graph.getNode(var2);
            switch (leftEndpoint) {
                case "<": {
                    endpoint1 = Endpoint.ARROW;
                    break;
                }
                case "o": {
                    endpoint1 = Endpoint.CIRCLE;
                    break;
                }
                case "-": {
                    endpoint1 = Endpoint.TAIL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Expecting an endpoint: " + leftEndpoint);
                }
            }
            switch (rightEndpoint) {
                case ">": {
                    endpoint2 = Endpoint.ARROW;
                    break;
                }
                case "o": {
                    endpoint2 = Endpoint.CIRCLE;
                    break;
                }
                case "-": {
                    endpoint2 = Endpoint.TAIL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Expecting an endpoint: " + rightEndpoint);
                }
            }
            Edge edge = new Edge(node1, node2, endpoint1, endpoint2);
            graph.addEdge(edge);
        }
        int size = graphElement.getChildElements().size();
        if (2 >= size) {
            return graph;
        }
        int p = 2;
        if ("ambiguities".equals(graphElement.getChildElements().get(p).getLocalName())) {
            ambiguitiesElement = graphElement.getChildElements().get(p);
            triples = GraphSaveLoadUtils.parseTriples(variables, ambiguitiesElement, "ambiguity");
            graph.setAmbiguousTriples(triples);
            ++p;
        }
        if (p >= size) {
            return graph;
        }
        if ("underlines".equals(graphElement.getChildElements().get(p).getLocalName())) {
            ambiguitiesElement = graphElement.getChildElements().get(p);
            triples = GraphSaveLoadUtils.parseTriples(variables, ambiguitiesElement, "underline");
            graph.setUnderLineTriples(triples);
            ++p;
        }
        if (p >= size) {
            return graph;
        }
        if ("dottedunderlines".equals(graphElement.getChildElements().get(p).getLocalName())) {
            ambiguitiesElement = graphElement.getChildElements().get(p);
            triples = GraphSaveLoadUtils.parseTriples(variables, ambiguitiesElement, "dottedunderline");
            graph.setDottedUnderLineTriples(triples);
        }
        return graph;
    }

    private static Set<Triple> parseTriples(List<Node> variables, Element triplesElement, String s) {
        Elements elements = triplesElement.getChildElements(s);
        HashSet<Triple> triples = new HashSet<Triple>();
        for (int q = 0; q < elements.size(); ++q) {
            Element tripleElement = elements.get(q);
            String value = tripleElement.getValue();
            String[] tokens = value.split(",");
            if (tokens.length != 3) {
                throw new IllegalArgumentException("Expecting a triple: " + value);
            }
            String x = tokens[0].trim();
            String y = tokens[1].trim();
            String z = tokens[2].trim();
            Node _x = GraphSaveLoadUtils.getNode(variables, x);
            Node _y = GraphSaveLoadUtils.getNode(variables, y);
            Node _z = GraphSaveLoadUtils.getNode(variables, z);
            Triple triple = new Triple(_x, _y, _z);
            triples.add(triple);
        }
        return triples;
    }

    private static Node getNode(List<Node> variables, String x) {
        for (Node node : variables) {
            if (!node.getName().equals(x)) continue;
            return node;
        }
        return null;
    }

    public static Element getRootElement(File file) throws ParsingException, IOException {
        Builder builder = new Builder();
        Document document = builder.build(file);
        return document.getRootElement();
    }

    private static Edge getEdge(String nodeNameFrom, String edgeType, String nodeNameTo, Graph graph) {
        Node nodeFrom = GraphSaveLoadUtils.getNode(nodeNameFrom, graph);
        Node nodeTo = GraphSaveLoadUtils.getNode(nodeNameTo, graph);
        Endpoint endpointFrom = GraphSaveLoadUtils.getEndpoint(edgeType.charAt(0));
        Endpoint endpointTo = GraphSaveLoadUtils.getEndpoint(edgeType.charAt(2));
        return new Edge(nodeFrom, nodeTo, endpointFrom, endpointTo);
    }

    private static Endpoint getEndpoint(char endpoint) {
        if (endpoint == '>' || endpoint == '<') {
            return Endpoint.ARROW;
        }
        if (endpoint == 'o') {
            return Endpoint.CIRCLE;
        }
        if (endpoint == '-') {
            return Endpoint.TAIL;
        }
        if (endpoint == '.') {
            return Endpoint.NULL;
        }
        throw new IllegalArgumentException(String.format("Unrecognized endpoint: %s.", Character.valueOf(endpoint)));
    }

    private static Node getNode(String nodeName, Graph graph) {
        Node node = graph.getNode(nodeName);
        if (node == null) {
            graph.addNode(new GraphNode(nodeName));
            node = graph.getNode(nodeName);
        }
        return node;
    }

    public static HashMap<String, PointXy> grabLayout(List<Node> nodes) {
        HashMap<String, PointXy> layout = new HashMap<String, PointXy>();
        for (Node node : nodes) {
            layout.put(node.getName(), new PointXy(node.getCenterX(), node.getCenterY()));
        }
        return layout;
    }

    public static List<Triple> getCollidersFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> colliders = new ArrayList<Triple>();
        ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(node));
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node x = (Node)adj.get(choice[0]);
            Node z = (Node)adj.get(choice[1]);
            Endpoint endpt1 = graph.getEdge(x, node).getProximalEndpoint(node);
            Endpoint endpt2 = graph.getEdge(z, node).getProximalEndpoint(node);
            if (endpt1 != Endpoint.ARROW || endpt2 != Endpoint.ARROW) continue;
            colliders.add(new Triple(x, node, z));
        }
        return colliders;
    }
}

