/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.utils.DagInCpcagIterator;
import edu.cmu.tetrad.search.utils.DagToPag;
import edu.cmu.tetrad.search.utils.MeekRules;
import edu.cmu.tetrad.util.CombinationGenerator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphTransforms {
    public static Graph dagFromCPDAG(Graph graph) {
        return GraphTransforms.dagFromCPDAG(graph, null);
    }

    public static Graph dagFromCPDAG(Graph graph, Knowledge knowledge) {
        EdgeListGraph dag = new EdgeListGraph(graph);
        for (Edge edge : dag.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            throw new IllegalArgumentException("That 'cpdag' contains a bidirected edge.");
        }
        MeekRules rules = new MeekRules();
        if (knowledge != null) {
            rules.setKnowledge(knowledge);
        }
        rules.setRevertToUnshieldedColliders(false);
        block1: while (true) {
            for (Edge edge : dag.getEdges()) {
                Node x = edge.getNode1();
                Node y = edge.getNode2();
                if (!Edges.isUndirectedEdge(edge) || graph.paths().isAncestorOf(y, x)) continue;
                GraphTransforms.direct(x, y, dag);
                rules.orientImplied(dag);
                continue block1;
            }
            break;
        }
        return dag;
    }

    public static Graph pagToMag(Graph pag) {
        Node y;
        Node x;
        EdgeListGraph mag = new EdgeListGraph(pag.getNodes());
        for (Edge e : pag.getEdges()) {
            mag.addEdge(new Edge(e));
        }
        List<Node> nodes = mag.getNodes();
        EdgeListGraph pcafci = new EdgeListGraph(nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                if (i == j) continue;
                x = nodes.get(i);
                y = nodes.get(j);
                if (mag.getEndpoint(y, x) == Endpoint.CIRCLE && mag.getEndpoint(x, y) == Endpoint.ARROW) {
                    mag.setEndpoint(y, x, Endpoint.TAIL);
                }
                if (mag.getEndpoint(y, x) == Endpoint.TAIL && mag.getEndpoint(x, y) == Endpoint.CIRCLE) {
                    mag.setEndpoint(x, y, Endpoint.ARROW);
                }
                if (mag.getEndpoint(y, x) != Endpoint.CIRCLE || mag.getEndpoint(x, y) != Endpoint.CIRCLE) continue;
                pcafci.addEdge(mag.getEdge(x, y));
            }
        }
        for (Edge e : pcafci.getEdges()) {
            e.setEndpoint1(Endpoint.TAIL);
            e.setEndpoint2(Endpoint.TAIL);
        }
        block4: while (true) {
            for (Edge e : pcafci.getEdges()) {
                if (!Edges.isUndirectedEdge(e)) continue;
                x = e.getNode1();
                y = e.getNode2();
                pcafci.setEndpoint(y, x, Endpoint.TAIL);
                pcafci.setEndpoint(x, y, Endpoint.ARROW);
                MeekRules meekRules = new MeekRules();
                meekRules.setRevertToUnshieldedColliders(false);
                meekRules.orientImplied(pcafci);
                continue block4;
            }
            break;
        }
        for (Edge e : pcafci.getEdges()) {
            mag.removeEdge(e.getNode1(), e.getNode2());
            mag.addEdge(e);
        }
        return mag;
    }

    public static List<Graph> generateCpdagDags(Graph cpdag, boolean orientBidirectedEdges) {
        if (orientBidirectedEdges) {
            cpdag = GraphUtils.removeBidirectedOrientations(cpdag);
        }
        return GraphTransforms.getDagsInCpdagMeek(cpdag, new Knowledge());
    }

    public static List<Graph> getDagsInCpdagMeek(Graph cpdag, Knowledge knowledge) {
        DagInCpcagIterator iterator = new DagInCpcagIterator(cpdag, knowledge);
        ArrayList<Graph> dags = new ArrayList<Graph>();
        while (iterator.hasNext()) {
            Graph graph = iterator.next();
            try {
                if (knowledge.isViolatedBy(graph)) continue;
                dags.add(graph);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Found a non-DAG: " + graph);
            }
        }
        return dags;
    }

    public static List<Graph> getAllGraphsByDirectingUndirectedEdges(Graph skeleton) {
        int[] comb;
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        ArrayList<Edge> edges = new ArrayList<Edge>(skeleton.getEdges());
        ArrayList<Integer> undirectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < edges.size(); ++i) {
            if (!Edges.isUndirectedEdge((Edge)edges.get(i))) continue;
            undirectedIndices.add(i);
        }
        int[] dims = new int[undirectedIndices.size()];
        for (int i = 0; i < undirectedIndices.size(); ++i) {
            dims[i] = 2;
        }
        CombinationGenerator gen = new CombinationGenerator(dims);
        while ((comb = gen.next()) != null) {
            EdgeListGraph graph = new EdgeListGraph(skeleton.getNodes());
            for (Edge edge : edges) {
                if (Edges.isUndirectedEdge(edge)) continue;
                graph.addEdge(edge);
            }
            for (int i = 0; i < undirectedIndices.size(); ++i) {
                Edge edge;
                edge = (Edge)edges.get((Integer)undirectedIndices.get(i));
                Node node1 = edge.getNode1();
                Node node2 = edge.getNode2();
                if (comb[i] == 1) {
                    graph.addEdge(Edges.directedEdge(node1, node2));
                    continue;
                }
                graph.addEdge(Edges.directedEdge(node2, node1));
            }
            graphs.add(graph);
        }
        return graphs;
    }

    public static Graph cpdagForDag(Graph dag) {
        EdgeListGraph cpdag = new EdgeListGraph(dag);
        MeekRules rules = new MeekRules();
        rules.setRevertToUnshieldedColliders(true);
        rules.orientImplied(cpdag);
        return cpdag;
    }

    @NotNull
    public static Graph dagToPag(Graph trueGraph) {
        return new DagToPag(trueGraph).convert();
    }

    private static void direct(Node a, Node c, Graph graph) {
        Edge before = graph.getEdge(a, c);
        Edge after = Edges.directedEdge(a, c);
        graph.removeEdge(before);
        graph.addEdge(after);
    }
}

