/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.search.utils.SepsetProducer;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.ForkJoinPoolInstance;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TextTable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.RecursiveTask;

public final class GraphUtils {
    public static Node getAssociatedNode(Node errorNode, Graph graph) {
        if (errorNode.getNodeType() != NodeType.ERROR) {
            throw new IllegalArgumentException("Can only get an associated node for an error node: " + errorNode);
        }
        List<Node> children = graph.getChildren(errorNode);
        if (children.size() != 1) {
            System.out.println("children of " + errorNode + " = " + children);
            System.out.println(graph);
            throw new IllegalArgumentException("An error node should have only one child, which is its associated node: " + errorNode);
        }
        return children.iterator().next();
    }

    public static boolean isClique(Collection<Node> set, Graph graph) {
        LinkedList<Node> setv = new LinkedList<Node>(set);
        for (int i = 0; i < setv.size() - 1; ++i) {
            for (int j = i + 1; j < setv.size(); ++j) {
                if (graph.isAdjacentTo((Node)setv.get(i), (Node)setv.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static Graph markovBlanketSubgraph(Node target, Graph graph) {
        Set<Node> mb = GraphUtils.markovBlanket(target, graph);
        EdgeListGraph mbGraph = new EdgeListGraph();
        for (Node node : mb) {
            mbGraph.addNode(node);
        }
        ArrayList<Node> mbList = new ArrayList<Node>(mb);
        mbList.add(target);
        for (int i = 0; i < mbList.size(); ++i) {
            for (int j = i + 1; j < mbList.size(); ++j) {
                for (Edge e : graph.getEdges((Node)mbList.get(i), (Node)mbList.get(j))) {
                    mbGraph.addEdge(e);
                }
            }
        }
        return mbGraph;
    }

    public static Graph removeBidirectedOrientations(Graph estCpdag) {
        estCpdag = new EdgeListGraph(estCpdag);
        for (Edge edge : estCpdag.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            estCpdag.removeEdge(edge);
            estCpdag.addUndirectedEdge(edge.getNode1(), edge.getNode2());
        }
        return estCpdag;
    }

    public static Graph undirectedGraph(Graph graph) {
        EdgeListGraph graph2 = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            if (graph2.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
            graph2.addUndirectedEdge(edge.getNode1(), edge.getNode2());
        }
        return graph2;
    }

    public static Graph completeGraph(Graph graph) {
        EdgeListGraph graph2 = new EdgeListGraph(graph.getNodes());
        graph2.removeEdges(new ArrayList<Edge>(graph2.getEdges()));
        List<Node> nodes = graph2.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node node1 = nodes.get(i);
                Node node2 = nodes.get(j);
                graph2.addUndirectedEdge(node1, node2);
            }
        }
        return graph2;
    }

    public static Graph bidirectedToUndirected(Graph graph) {
        EdgeListGraph newGraph = new EdgeListGraph(graph);
        for (Edge edge : newGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            newGraph.removeEdge(edge);
            newGraph.addUndirectedEdge(edge.getNode1(), edge.getNode2());
        }
        return newGraph;
    }

    public static Graph undirectedToBidirected(Graph graph) {
        EdgeListGraph newGraph = new EdgeListGraph(graph);
        for (Edge edge : newGraph.getEdges()) {
            if (!Edges.isUndirectedEdge(edge)) continue;
            newGraph.removeEdge(edge);
            newGraph.addBidirectedEdge(edge.getNode1(), edge.getNode2());
        }
        return newGraph;
    }

    public static String pathString(Graph graph, List<Node> path) {
        return GraphUtils.pathString(graph, path, new LinkedList<Node>());
    }

    public static String pathString(Graph graph, Node ... x) {
        ArrayList<Node> path = new ArrayList<Node>();
        Collections.addAll(path, x);
        return GraphUtils.pathString(graph, path, new LinkedList<Node>());
    }

    private static String pathString(Graph graph, List<Node> path, List<Node> conditioningVars) {
        StringBuilder buf = new StringBuilder();
        if (path.size() < 2) {
            return "NO PATH";
        }
        if (path.get(0).getNodeType() == NodeType.LATENT) {
            buf.append("(").append(path.get(0).toString()).append(")");
        } else {
            buf.append(path.get(0).toString());
        }
        if (conditioningVars.contains(path.get(0))) {
            buf.append("(C)");
        }
        for (int m = 1; m < path.size(); ++m) {
            Node n1;
            Node n0 = path.get(m - 1);
            Edge edge = graph.getEdge(n0, n1 = path.get(m));
            if (edge == null) {
                buf.append("(-)");
            } else {
                Endpoint endpoint0 = edge.getProximalEndpoint(n0);
                Endpoint endpoint1 = edge.getProximalEndpoint(n1);
                if (endpoint0 == Endpoint.ARROW) {
                    buf.append("<");
                } else if (endpoint0 == Endpoint.TAIL) {
                    buf.append("-");
                } else if (endpoint0 == Endpoint.CIRCLE) {
                    buf.append("o");
                }
                buf.append("-");
                if (endpoint1 == Endpoint.ARROW) {
                    buf.append(">");
                } else if (endpoint1 == Endpoint.TAIL) {
                    buf.append("-");
                } else if (endpoint1 == Endpoint.CIRCLE) {
                    buf.append("o");
                }
            }
            if (n1.getNodeType() == NodeType.LATENT) {
                buf.append("(").append(n1).append(")");
            } else {
                buf.append(n1);
            }
            if (!conditioningVars.contains(n1)) continue;
            buf.append("(C)");
        }
        return buf.toString();
    }

    public static Graph replaceNodes(Graph originalGraph, List<Node> newVariables) {
        HashMap<String, Node> newNodes = new HashMap<String, Node>();
        ArrayList<Node> _newNodes = new ArrayList<Node>();
        for (Node node : newVariables) {
            if (node.getNodeType() == NodeType.LATENT) continue;
            newNodes.put(node.getName(), node);
            _newNodes.add(node);
        }
        EdgeListGraph convertedGraph = new EdgeListGraph(_newNodes);
        for (Edge edge : originalGraph.getEdges()) {
            Node node1 = (Node)newNodes.get(edge.getNode1().getName());
            Node node2 = (Node)newNodes.get(edge.getNode2().getName());
            if (node1 == null) {
                node1 = edge.getNode1();
            }
            if (!convertedGraph.containsNode(node1)) {
                convertedGraph.addNode(node1);
            }
            if (node2 == null) {
                node2 = edge.getNode2();
            }
            if (!convertedGraph.containsNode(node2)) {
                convertedGraph.addNode(node2);
            }
            Endpoint endpoint1 = edge.getEndpoint1();
            Endpoint endpoint2 = edge.getEndpoint2();
            Edge newEdge = new Edge(node1, node2, endpoint1, endpoint2);
            convertedGraph.addEdge(newEdge);
        }
        for (Triple triple : originalGraph.getUnderLines()) {
            convertedGraph.addUnderlineTriple(convertedGraph.getNode(triple.getX().getName()), convertedGraph.getNode(triple.getY().getName()), convertedGraph.getNode(triple.getZ().getName()));
        }
        for (Triple triple : originalGraph.getDottedUnderlines()) {
            convertedGraph.addDottedUnderlineTriple(convertedGraph.getNode(triple.getX().getName()), convertedGraph.getNode(triple.getY().getName()), convertedGraph.getNode(triple.getZ().getName()));
        }
        for (Triple triple : originalGraph.getAmbiguousTriples()) {
            convertedGraph.addAmbiguousTriple(convertedGraph.getNode(triple.getX().getName()), convertedGraph.getNode(triple.getY().getName()), convertedGraph.getNode(triple.getZ().getName()));
        }
        return convertedGraph;
    }

    public static Graph restrictToMeasured(Graph graph) {
        graph = new EdgeListGraph(graph);
        for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            graph.removeNode(node);
        }
        return graph;
    }

    public static List<Node> replaceNodes(List<Node> originalNodes, List<Node> newNodes) {
        LinkedList<Node> convertedNodes = new LinkedList<Node>();
        block0: for (Node node : originalNodes) {
            if (node == null) {
                throw new NullPointerException("Null node among original nodes.");
            }
            for (Node _node : newNodes) {
                if (_node == null) {
                    throw new NullPointerException("Null node among new nodes.");
                }
                if (!node.getName().equals(_node.getName())) continue;
                convertedNodes.add(_node);
                continue block0;
            }
        }
        return convertedNodes;
    }

    public static int countAdjErrors(Graph graph1, Graph graph2) {
        if (graph1 == null) {
            throw new NullPointerException("The reference graph is missing.");
        }
        if (graph2 == null) {
            throw new NullPointerException("The target graph is missing.");
        }
        graph2 = GraphUtils.replaceNodes(graph2, graph1.getNodes());
        int count = 0;
        Set<Edge> edges1 = graph1.getEdges();
        for (Edge edge : edges1) {
            if (graph2.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
            ++count;
        }
        return count;
    }

    public static int countArrowptErrors(Graph graph1, Graph graph2) {
        Edge edge2;
        Node node2;
        Node node1;
        if (graph1 == null) {
            throw new NullPointerException("The reference graph is missing.");
        }
        if (graph2 == null) {
            throw new NullPointerException("The target graph is missing.");
        }
        graph2 = GraphUtils.replaceNodes(graph2, graph1.getNodes());
        int count = 0;
        for (Edge edge1 : graph1.getEdges()) {
            node1 = edge1.getNode1();
            node2 = edge1.getNode2();
            edge2 = graph2.getEdge(node1, node2);
            if (edge1.getEndpoint1() == Endpoint.ARROW) {
                if (edge2 == null) {
                    ++count;
                } else if (edge2.getProximalEndpoint(edge1.getNode1()) != Endpoint.ARROW) {
                    ++count;
                }
            }
            if (edge1.getEndpoint2() != Endpoint.ARROW) continue;
            if (edge2 == null) {
                ++count;
                continue;
            }
            if (edge2.getProximalEndpoint(edge1.getNode2()) == Endpoint.ARROW) continue;
            ++count;
        }
        for (Edge edge1 : graph2.getEdges()) {
            node1 = edge1.getNode1();
            node2 = edge1.getNode2();
            edge2 = graph1.getEdge(node1, node2);
            if (edge1.getEndpoint1() == Endpoint.ARROW) {
                if (edge2 == null) {
                    ++count;
                } else if (edge2.getProximalEndpoint(edge1.getNode1()) != Endpoint.ARROW) {
                    ++count;
                }
            }
            if (edge1.getEndpoint2() != Endpoint.ARROW) continue;
            if (edge2 == null) {
                ++count;
                continue;
            }
            if (edge2.getProximalEndpoint(edge1.getNode2()) == Endpoint.ARROW) continue;
            ++count;
        }
        return count;
    }

    public static int getNumCorrectArrowpts(Graph correct, Graph estimated) {
        correct = GraphUtils.replaceNodes(correct, estimated.getNodes());
        Set<Edge> edges = estimated.getEdges();
        int numCorrect = 0;
        for (Edge estEdge : edges) {
            Edge correctEdge = correct.getEdge(estEdge.getNode1(), estEdge.getNode2());
            if (correctEdge == null) continue;
            if (estEdge.getProximalEndpoint(estEdge.getNode1()) == Endpoint.ARROW && correctEdge.getProximalEndpoint(estEdge.getNode1()) == Endpoint.ARROW) {
                ++numCorrect;
            }
            if (estEdge.getProximalEndpoint(estEdge.getNode2()) != Endpoint.ARROW || correctEdge.getProximalEndpoint(estEdge.getNode2()) != Endpoint.ARROW) continue;
            ++numCorrect;
        }
        return numCorrect;
    }

    public static List<Node> replaceNodes(List<Node> originalNodes, Graph graph) {
        LinkedList<Node> convertedNodes = new LinkedList<Node>();
        for (Node node : originalNodes) {
            convertedNodes.add(graph.getNode(node.getName()));
        }
        return convertedNodes;
    }

    public static Graph emptyGraph(int numNodes) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new GraphNode("X" + i));
        }
        return new EdgeListGraph(nodes);
    }

    public static List<Triple> getAmbiguousTriplesFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> ambiguousTriples = new ArrayList<Triple>();
        ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(node));
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node z;
            Node x = (Node)adj.get(choice[0]);
            if (!graph.isAmbiguousTriple(x, node, z = (Node)adj.get(choice[1]))) continue;
            ambiguousTriples.add(new Triple(x, node, z));
        }
        return ambiguousTriples;
    }

    public static List<Triple> getUnderlinedTriplesFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> underlinedTriples = new ArrayList<Triple>();
        Set<Triple> allUnderlinedTriples = graph.getUnderLines();
        ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(node));
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node z;
            Node x = (Node)adj.get(choice[0]);
            if (!allUnderlinedTriples.contains(new Triple(x, node, z = (Node)adj.get(choice[1])))) continue;
            underlinedTriples.add(new Triple(x, node, z));
        }
        return underlinedTriples;
    }

    public static List<Triple> getDottedUnderlinedTriplesFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> dottedUnderlinedTriples = new ArrayList<Triple>();
        Set<Triple> allDottedUnderlinedTriples = graph.getDottedUnderlines();
        ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(node));
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node z;
            Node x = (Node)adj.get(choice[0]);
            if (!allDottedUnderlinedTriples.contains(new Triple(x, node, z = (Node)adj.get(choice[1])))) continue;
            dottedUnderlinedTriples.add(new Triple(x, node, z));
        }
        return dottedUnderlinedTriples;
    }

    public static boolean containsBidirectedEdge(Graph graph) {
        boolean containsBidirected = false;
        for (Edge edge : graph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            containsBidirected = true;
            break;
        }
        return containsBidirected;
    }

    public static LinkedList<Triple> listColliderTriples(Graph graph) {
        LinkedList<Triple> colliders = new LinkedList<Triple>();
        for (Node node : graph.getNodes()) {
            int[] choice;
            ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(node));
            if (adj.size() < 2) continue;
            ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
            while ((choice = gen.next()) != null) {
                List<Node> others = GraphUtils.asList(choice, adj);
                if (!graph.isDefCollider(others.get(0), node, others.get(1))) continue;
                colliders.add(new Triple(others.get(0), node, others.get(1)));
            }
        }
        return colliders;
    }

    public static List<Node> asList(int[] indices, List<Node> nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        for (int index : indices) {
            list.add(nodes.get(index));
        }
        return list;
    }

    public static Set<Node> asSet(int[] indices, List<Node> nodes) {
        HashSet<Node> set = new HashSet<Node>();
        for (int i : indices) {
            if (i < 0 || i >= nodes.size()) continue;
            set.add(nodes.get(i));
        }
        return set;
    }

    public static Set<Node> asSet(Node ... nodes) {
        HashSet<Node> set = new HashSet<Node>();
        Collections.addAll(set, nodes);
        return set;
    }

    public static int degree(Graph graph) {
        int maxDegree = 0;
        for (Node node : graph.getNodes()) {
            int n = graph.getEdges(node).size();
            if (n <= maxDegree) continue;
            maxDegree = n;
        }
        return maxDegree;
    }

    public static String getIntersectionComparisonString(List<Graph> graphs) {
        if (graphs == null || graphs.isEmpty()) {
            return "";
        }
        StringBuilder b = GraphUtils.undirectedEdges(graphs);
        b.append((CharSequence)GraphUtils.directedEdges(graphs));
        return b.toString();
    }

    private static StringBuilder undirectedEdges(List<Graph> graphs) {
        ArrayList<EdgeListGraph> undirectedGraphs = new ArrayList<EdgeListGraph>();
        for (Graph graph : graphs) {
            EdgeListGraph edgeListGraph = new EdgeListGraph(graph);
            edgeListGraph.reorientAllWith(Endpoint.TAIL);
            undirectedGraphs.add(edgeListGraph);
        }
        HashMap<String, Node> exemplars = new HashMap<String, Node>();
        for (Graph graph : undirectedGraphs) {
            for (Node node : graph.getNodes()) {
                exemplars.put(node.getName(), node);
            }
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        for (String s : exemplars.keySet()) {
            hashSet.add((Node)exemplars.get(s));
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(hashSet);
        ArrayList<Object> undirectedGraphs2 = new ArrayList<Object>();
        for (int i = 0; i < graphs.size(); ++i) {
            Graph graph = GraphUtils.replaceNodes((Graph)undirectedGraphs.get(i), arrayList);
            undirectedGraphs2.add(graph);
        }
        HashSet<Edge> undirectedEdgesSet = new HashSet<Edge>();
        for (Graph graph : undirectedGraphs2) {
            undirectedEdgesSet.addAll(graph.getEdges());
        }
        ArrayList undirectedEdges = new ArrayList(undirectedEdgesSet);
        undirectedEdges.sort((o1, o2) -> {
            String name11 = o1.getNode1().getName();
            String name12 = o1.getNode2().getName();
            String name21 = o2.getNode1().getName();
            String name22 = o2.getNode2().getName();
            int major = name11.compareTo(name21);
            int minor = name12.compareTo(name22);
            if (major == 0) {
                return minor;
            }
            return major;
        });
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < graphs.size(); ++i) {
            arrayList2.add(new ArrayList());
        }
        for (Edge edge : undirectedEdges) {
            int count = 0;
            for (Graph graph : undirectedGraphs2) {
                if (!graph.containsEdge(edge)) continue;
                ++count;
            }
            if (count == 0) {
                throw new IllegalArgumentException();
            }
            ((List)arrayList2.get(count - 1)).add(edge);
        }
        StringBuilder b = new StringBuilder();
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            b.append("\n\nIn ").append(i + 1).append(" graph").append(i > 0 ? "s" : "").append("...\n");
            for (int j = 0; j < ((List)arrayList2.get(i)).size(); ++j) {
                b.append("\n").append(j + 1).append(". ").append(((List)arrayList2.get(i)).get(j));
            }
        }
        return b;
    }

    private static StringBuilder directedEdges(List<Graph> directedGraphs) {
        HashSet<Edge> directedEdgesSet = new HashSet<Edge>();
        HashMap<String, Node> exemplars = new HashMap<String, Node>();
        for (Graph graph : directedGraphs) {
            for (Node node : graph.getNodes()) {
                exemplars.put(node.getName(), node);
            }
        }
        HashSet<Node> nodeSet = new HashSet<Node>();
        for (String s : exemplars.keySet()) {
            nodeSet.add((Node)exemplars.get(s));
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeSet);
        ArrayList<Graph> directedGraphs2 = new ArrayList<Graph>();
        for (Graph directedGraph : directedGraphs) {
            Graph graph = GraphUtils.replaceNodes(directedGraph, arrayList);
            directedGraphs2.add(graph);
        }
        for (Graph graph : directedGraphs2) {
            directedEdgesSet.addAll(graph.getEdges());
        }
        ArrayList arrayList2 = new ArrayList(directedEdgesSet);
        arrayList2.sort((o1, o2) -> {
            String name11 = o1.getNode1().getName();
            String name12 = o1.getNode2().getName();
            String name21 = o2.getNode1().getName();
            String name22 = o2.getNode2().getName();
            int major = name11.compareTo(name21);
            int minor = name12.compareTo(name22);
            if (major == 0) {
                return minor;
            }
            return major;
        });
        ArrayList groups = new ArrayList();
        for (int i = 0; i < directedGraphs2.size(); ++i) {
            groups.add(new ArrayList());
        }
        HashSet<Edge> contradicted = new HashSet<Edge>();
        HashMap<Edge, Integer> directionCounts = new HashMap<Edge, Integer>();
        for (Edge edge : arrayList2) {
            if (!edge.isDirected()) continue;
            int count1 = 0;
            int count2 = 0;
            for (Graph graph : directedGraphs2) {
                if (graph.containsEdge(edge)) {
                    ++count1;
                    continue;
                }
                if (!graph.containsEdge(edge.reverse())) continue;
                ++count2;
            }
            if (count1 != 0 && count2 != 0 && !contradicted.contains(edge.reverse())) {
                contradicted.add(edge);
            }
            directionCounts.put(edge, count1);
            directionCounts.put(edge.reverse(), count2);
            if (count1 == 0) {
                ((List)groups.get(count2 - 1)).add(edge);
            }
            if (count2 != 0) continue;
            ((List)groups.get(count1 - 1)).add(edge);
        }
        StringBuilder b = new StringBuilder();
        for (int i = groups.size() - 1; i >= 0; --i) {
            b.append("\n\nUncontradicted in ").append(i + 1).append(" graph").append(i > 0 ? "s" : "").append("...\n");
            for (int j = 0; j < ((List)groups.get(i)).size(); ++j) {
                b.append("\n").append(j + 1).append(". ").append(((List)groups.get(i)).get(j));
            }
        }
        b.append("\n\nContradicted:\n");
        int index = 1;
        for (Edge edge : contradicted) {
            b.append("\n").append(index++).append(". ").append(Edges.undirectedEdge(edge.getNode1(), edge.getNode2())).append(" (--> ").append(directionCounts.get(edge)).append(" <-- ").append(directionCounts.get(edge.reverse())).append(")");
        }
        return b;
    }

    public static String edgeMisclassifications(double[][] counts, NumberFormat nf) {
        StringBuilder builder = new StringBuilder();
        TextTable table2 = new TextTable(9, 7);
        table2.setToken(1, 0, "---");
        table2.setToken(2, 0, "o-o");
        table2.setToken(3, 0, "o->");
        table2.setToken(4, 0, "<-o");
        table2.setToken(5, 0, "-->");
        table2.setToken(6, 0, "<--");
        table2.setToken(7, 0, "<->");
        table2.setToken(8, 0, "No Edge");
        table2.setToken(0, 1, "---");
        table2.setToken(0, 2, "o-o");
        table2.setToken(0, 3, "o->");
        table2.setToken(0, 4, "-->");
        table2.setToken(0, 5, "<->");
        table2.setToken(0, 6, "No Edge");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (i == 7 && j == 5) {
                    table2.setToken(8, 6, "*");
                    continue;
                }
                table2.setToken(i + 1, j + 1, "" + nf.format(counts[i][j]));
            }
        }
        builder.append(table2);
        double correctEdges = 0.0;
        double estimatedEdges = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            for (int j = 0; j < counts[0].length - 1; ++j) {
                if (i == 0 && j == 0 || i == 1 && j == 1 || i == 2 && j == 2 || i == 4 && j == 3 || i == 6 && j == 4) {
                    correctEdges += counts[i][j];
                }
                estimatedEdges += counts[i][j];
            }
        }
        DecimalFormat nf2 = new DecimalFormat("0.00");
        builder.append("\nRatio correct edges to estimated edges = ").append(nf2.format(correctEdges / estimatedEdges));
        return builder.toString();
    }

    public static String edgeMisclassifications(int[][] counts) {
        StringBuilder builder = new StringBuilder();
        TextTable table2 = new TextTable(9, 7);
        table2.setToken(1, 0, "---");
        table2.setToken(2, 0, "o-o");
        table2.setToken(3, 0, "o->");
        table2.setToken(4, 0, "&lt;-o");
        table2.setToken(5, 0, "-->");
        table2.setToken(6, 0, "<--");
        table2.setToken(7, 0, "<->");
        table2.setToken(8, 0, "No Edge");
        table2.setToken(0, 1, "---");
        table2.setToken(0, 2, "o-o");
        table2.setToken(0, 3, "o->");
        table2.setToken(0, 4, "-->");
        table2.setToken(0, 5, "<->");
        table2.setToken(0, 6, "No Edge");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (i == 7 && j == 5) {
                    table2.setToken(8, 6, "*");
                    continue;
                }
                table2.setToken(i + 1, j + 1, "" + counts[i][j]);
            }
        }
        builder.append(table2);
        int correctEdges = 0;
        int estimatedEdges = 0;
        for (int i = 0; i < counts.length; ++i) {
            for (int j = 0; j < counts[0].length - 1; ++j) {
                if (i == 0 && j == 0 || i == 1 && j == 1 || i == 2 && j == 2 || i == 4 && j == 3 || i == 6 && j == 4) {
                    correctEdges += counts[i][j];
                }
                estimatedEdges += counts[i][j];
            }
        }
        DecimalFormat nf2 = new DecimalFormat("0.00");
        builder.append("\nRatio correct edges to estimated edges = ").append(nf2.format((double)correctEdges / (double)estimatedEdges));
        return builder.toString();
    }

    public static void addPagColoring(Graph graph) {
        for (Edge edge : graph.getEdges()) {
            edge.getProperties().clear();
            if (!Edges.isDirectedEdge(edge)) continue;
            Node x = Edges.getDirectedEdgeTail(edge);
            Node y = Edges.getDirectedEdgeHead(edge);
            graph.removeEdge(edge);
            graph.addEdge(edge);
            Edge xyEdge = graph.getEdge(x, y);
            graph.removeEdge(xyEdge);
            if (!new Paths(graph).existsSemiDirectedPath(x, y)) {
                edge.addProperty(Edge.Property.dd);
            } else {
                edge.addProperty(Edge.Property.pd);
            }
            graph.addEdge(xyEdge);
            if (graph.paths().defVisible(edge)) {
                edge.addProperty(Edge.Property.nl);
                continue;
            }
            edge.addProperty(Edge.Property.pl);
        }
    }

    public static int[][] edgeMisclassificationCounts(Graph leftGraph, Graph topGraph, boolean print) {
        HashSet<Edge> edgeSet = new HashSet<Edge>();
        edgeSet.addAll(topGraph.getEdges());
        edgeSet.addAll(leftGraph.getEdges());
        if (print) {
            System.out.println("Top graph " + topGraph.getEdges().size());
            System.out.println("Left graph " + leftGraph.getEdges().size());
            System.out.println("All edges " + edgeSet.size());
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(edgeSet);
        ForkJoinPoolInstance pool = ForkJoinPoolInstance.getInstance();
        class CountTask
        extends RecursiveTask<Counts> {
            private final List<Edge> edges;
            private final Graph leftGraph;
            private final Graph topGraph;
            private final Counts counts;
            private final int[] count;
            private final int chunk;
            private final int from;
            private final int to;

            public CountTask(int chunk, int from, int to, List<Edge> edges, Graph leftGraph, Graph topGraph, int[] count) {
                this.chunk = chunk;
                this.from = from;
                this.to = to;
                this.edges = edges;
                this.leftGraph = leftGraph;
                this.topGraph = topGraph;
                this.counts = new Counts();
                this.count = count;
            }

            @Override
            protected Counts compute() {
                int range = this.to - this.from;
                if (range <= this.chunk) {
                    for (int i = this.from; i < this.to; ++i) {
                        this.count[0] = this.count[0] + 1;
                        Edge edge = this.edges.get(i);
                        Node x = edge.getNode1();
                        Node y = edge.getNode2();
                        Edge left = this.leftGraph.getEdge(x, y);
                        Edge top = this.topGraph.getEdge(x, y);
                        int m = GraphUtils.getTypeLeft(left, top);
                        int n = GraphUtils.getTypeTop(top);
                        this.counts.increment(m, n);
                    }
                    return this.counts;
                }
                int mid = (this.to + this.from) / 2;
                CountTask left = new CountTask(this.chunk, this.from, mid, this.edges, this.leftGraph, this.topGraph, this.count);
                CountTask right = new CountTask(this.chunk, mid, this.to, this.edges, this.leftGraph, this.topGraph, this.count);
                left.fork();
                Counts rightAnswer = right.compute();
                Counts leftAnswer = (Counts)left.join();
                leftAnswer.addAll(rightAnswer);
                return leftAnswer;
            }

            public Counts getCounts() {
                return this.counts;
            }
        }
        CountTask task = new CountTask(500, 0, edges.size(), edges, leftGraph, topGraph, new int[1]);
        Counts counts = pool.getPool().invoke(task);
        return counts.countArray();
    }

    private static int getTypeTop(Edge edgeTop) {
        if (edgeTop == null) {
            return 5;
        }
        if (Edges.isUndirectedEdge(edgeTop)) {
            return 0;
        }
        if (Edges.isNondirectedEdge(edgeTop)) {
            return 1;
        }
        if (Edges.isPartiallyOrientedEdge(edgeTop)) {
            return 2;
        }
        if (Edges.isDirectedEdge(edgeTop)) {
            return 3;
        }
        if (Edges.isBidirectedEdge(edgeTop)) {
            return 4;
        }
        return 5;
    }

    private static int getTypeLeft(Edge edgeLeft, Edge edgeTop) {
        if (edgeLeft == null) {
            return 7;
        }
        if (edgeTop == null) {
            edgeTop = edgeLeft;
        }
        if (Edges.isUndirectedEdge(edgeLeft)) {
            return 0;
        }
        if (Edges.isNondirectedEdge(edgeLeft)) {
            return 1;
        }
        Node x = edgeLeft.getNode1();
        Node y = edgeLeft.getNode2();
        if (Edges.isPartiallyOrientedEdge(edgeLeft)) {
            if (edgeLeft.pointsTowards(x) && edgeTop.pointsTowards(y) || edgeLeft.pointsTowards(y) && edgeTop.pointsTowards(x)) {
                return 3;
            }
            return 2;
        }
        if (Edges.isDirectedEdge(edgeLeft)) {
            if (edgeLeft.pointsTowards(x) && edgeTop.pointsTowards(y) || edgeLeft.pointsTowards(y) && edgeTop.pointsTowards(x)) {
                return 5;
            }
            return 4;
        }
        if (Edges.isBidirectedEdge(edgeLeft)) {
            return 6;
        }
        throw new IllegalArgumentException("Unsupported edge type : " + edgeLeft);
    }

    public static Set<Set<Node>> maximalCliques(Graph graph, List<Node> nodes) {
        HashSet<Set<Node>> report = new HashSet<Set<Node>>();
        GraphUtils.brokKerbosh1(new HashSet<Node>(), new HashSet<Node>(nodes), new HashSet<Node>(), report, graph);
        return report;
    }

    private static void brokKerbosh1(Set<Node> R, Set<Node> P, Set<Node> X, Set<Set<Node>> report, Graph graph) {
        if (P.isEmpty() && X.isEmpty()) {
            report.add(new HashSet<Node>(R));
        }
        for (Node v : new HashSet<Node>(P)) {
            HashSet<Node> _R = new HashSet<Node>(R);
            HashSet<Node> _P = new HashSet<Node>(P);
            HashSet<Node> _X = new HashSet<Node>(X);
            _R.add(v);
            _P.retainAll(graph.getAdjacentNodes(v));
            _X.retainAll(graph.getAdjacentNodes(v));
            GraphUtils.brokKerbosh1(_R, _P, _X, report, graph);
            P.remove(v);
            X.add(v);
        }
    }

    public static String graphToText(Graph graph, boolean doPagColoring) {
        Set<Triple> dottedUnderLineTriples;
        Set<Triple> underLineTriples;
        Set<Triple> ambiguousTriples;
        String graphNodeAttributes;
        if (doPagColoring) {
            GraphUtils.addPagColoring(graph);
        }
        Formatter fmt = new Formatter();
        fmt.format("%s%n%n", GraphUtils.graphNodesToText(graph, "Graph Nodes:", ';'));
        fmt.format("%s%n", GraphUtils.graphEdgesToText(graph, "Graph Edges:"));
        String graphAttributes = GraphUtils.graphAttributesToText(graph, "Graph Attributes:");
        if (graphAttributes != null) {
            fmt.format("%s%n", graphAttributes);
        }
        if (graph.getNumNodes() < 50 && (graphNodeAttributes = GraphUtils.graphNodeAttributesToText(graph, "Graph Node Attributes:", ';')) != null) {
            fmt.format("%s%n", graphNodeAttributes);
        }
        if (!(ambiguousTriples = graph.getAmbiguousTriples()).isEmpty()) {
            fmt.format("%n%n%s", GraphUtils.triplesToText(ambiguousTriples, "Ambiguous triples (i.e. list of triples for which there is ambiguous data about whether they are colliders or not):"));
        }
        if (!(underLineTriples = graph.getUnderLines()).isEmpty()) {
            fmt.format("%n%n%s", GraphUtils.triplesToText(underLineTriples, "Underline triples:"));
        }
        if (!(dottedUnderLineTriples = graph.getDottedUnderlines()).isEmpty()) {
            fmt.format("%n%n%s", GraphUtils.triplesToText(dottedUnderLineTriples, "Dotted underline triples:"));
        }
        return fmt.toString();
    }

    public static String graphNodeAttributesToText(Graph graph, String title, char delimiter) {
        List<Node> nodes = graph.getNodes();
        LinkedHashMap<String, LinkedHashMap<String, Object>> graphNodeAttributes = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        for (Node node : nodes) {
            Map<String, Object> attributes = node.getAllAttributes();
            if (attributes.isEmpty()) continue;
            for (String key : attributes.keySet()) {
                Object value = attributes.get(key);
                LinkedHashMap<String, Object> nodeAttributes = (LinkedHashMap<String, Object>)graphNodeAttributes.get(key);
                if (nodeAttributes == null) {
                    nodeAttributes = new LinkedHashMap<String, Object>();
                }
                nodeAttributes.put(node.getName(), value);
                graphNodeAttributes.put(key, nodeAttributes);
            }
        }
        if (!graphNodeAttributes.isEmpty()) {
            StringBuilder sb = title == null || title.length() == 0 ? new StringBuilder() : new StringBuilder(String.format("%s", title));
            for (String key : graphNodeAttributes.keySet()) {
                Map nodeAttributes = (Map)graphNodeAttributes.get(key);
                int size = nodeAttributes.size();
                int count = 0;
                sb.append(String.format("%n%s: [", key));
                for (String nodeName : nodeAttributes.keySet()) {
                    Object value = nodeAttributes.get(nodeName);
                    sb.append(String.format("%s: %s", nodeName, value));
                    if (++count >= size) continue;
                    sb.append(delimiter);
                }
                sb.append("]");
            }
            return sb.toString();
        }
        return null;
    }

    public static String graphAttributesToText(Graph graph, String title) {
        Map<String, Object> attributes = graph.getAllAttributes();
        if (!attributes.isEmpty()) {
            StringBuilder sb = title == null || title.length() == 0 ? new StringBuilder() : new StringBuilder(String.format("%s%n", title));
            for (String key : attributes.keySet()) {
                Object value = attributes.get(key);
                sb.append(key);
                sb.append(": ");
                if (value instanceof String) {
                    sb.append(value);
                    continue;
                }
                if (!(value instanceof Number)) continue;
                sb.append(String.format("%f%n", ((Number)value).doubleValue()));
            }
            return sb.toString();
        }
        return null;
    }

    public static String graphNodesToText(Graph graph, String title, char delimiter) {
        StringBuilder sb = title == null || title.length() == 0 ? new StringBuilder() : new StringBuilder(String.format("%s%n", title));
        List<Node> nodes = graph.getNodes();
        int size = nodes.size();
        int count = 0;
        for (Node node : nodes) {
            ++count;
            if (node.getNodeType() == NodeType.LATENT) {
                sb.append("(").append(node.getName()).append(")");
            } else {
                sb.append(node.getName());
            }
            if (count >= size) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String graphEdgesToText(Graph graph, String title) {
        Formatter fmt = new Formatter();
        if (title != null && title.length() > 0) {
            fmt.format("%s%n", title);
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(graph.getEdges());
        Edges.sortEdges(edges);
        int count = 0;
        for (Edge edge : edges) {
            String f = "%d. %s";
            Object[] o = new Object[]{++count, edge};
            fmt.format("%d. %s", o);
            fmt.format("\n", new Object[0]);
        }
        return fmt.toString();
    }

    public static String triplesToText(Set<Triple> triples, String title) {
        int size;
        Formatter fmt = new Formatter();
        if (title != null && title.length() > 0) {
            fmt.format("%s%n", title);
        }
        int n = size = triples == null ? 0 : triples.size();
        if (size > 0) {
            int count = 0;
            for (Triple triple : triples) {
                if (++count < size) {
                    fmt.format("%s%n", triple);
                    continue;
                }
                fmt.format("%s", triple);
            }
        }
        return fmt.toString();
    }

    public static TwoCycleErrors getTwoCycleErrors(Graph trueGraph, Graph estGraph) {
        Set<Edge> trueEdges = trueGraph.getEdges();
        HashSet<Edge> trueTwoCycle = new HashSet<Edge>();
        for (Edge edge : trueEdges) {
            if (!edge.isDirected()) continue;
            Node node1 = edge.getNode1();
            Node node = edge.getNode2();
            if (!trueEdges.contains(Edges.directedEdge(node, node1))) continue;
            Edge edge2 = Edges.undirectedEdge(node1, node);
            trueTwoCycle.add(edge2);
        }
        Set<Edge> estEdges = estGraph.getEdges();
        HashSet<Edge> estTwoCycle = new HashSet<Edge>();
        for (Edge edge : estEdges) {
            if (!edge.isDirected()) continue;
            Node node = edge.getNode1();
            Node node2 = edge.getNode2();
            if (!estEdges.contains(Edges.directedEdge(node2, node))) continue;
            Edge undirEdge = Edges.undirectedEdge(node, node2);
            estTwoCycle.add(undirEdge);
        }
        EdgeListGraph trueTwoCycleGraph = new EdgeListGraph(trueGraph.getNodes());
        for (Edge edge : trueTwoCycle) {
            trueTwoCycleGraph.addEdge(edge);
        }
        EdgeListGraph edgeListGraph = new EdgeListGraph(estGraph.getNodes());
        for (Edge edge : estTwoCycle) {
            edgeListGraph.addEdge(edge);
        }
        Graph graph = GraphUtils.replaceNodes(edgeListGraph, trueTwoCycleGraph.getNodes());
        int n = GraphUtils.countAdjErrors(trueTwoCycleGraph, graph);
        int adjFp = GraphUtils.countAdjErrors(graph, trueTwoCycleGraph);
        Graph undirectedGraph = GraphUtils.undirectedGraph(graph);
        int adjCorrect = undirectedGraph.getNumEdges() - adjFp;
        return new TwoCycleErrors(adjCorrect, n, adjFp);
    }

    public static int getDegree(Graph graph) {
        int max = 0;
        for (Node node : graph.getNodes()) {
            if (graph.getAdjacentNodes(node).size() <= max) continue;
            max = graph.getAdjacentNodes(node).size();
        }
        return max;
    }

    public static int getIndegree(Graph graph) {
        int max = 0;
        for (Node node : graph.getNodes()) {
            if (graph.getAdjacentNodes(node).size() <= max) continue;
            max = graph.getIndegree(node);
        }
        return max;
    }

    public static Node traverseSemiDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.TAIL || edge.getEndpoint1() == Endpoint.CIRCLE) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && (edge.getEndpoint2() == Endpoint.TAIL || edge.getEndpoint2() == Endpoint.CIRCLE)) {
            return edge.getNode1();
        }
        return null;
    }

    public static Graph getComparisonGraph(Graph graph, Parameters params) {
        String type = params.getString("graphComparisonType");
        if ("DAG".equals(type)) {
            params.set("graphComparisonType", "DAG");
            return new EdgeListGraph(graph);
        }
        if ("CPDAG".equals(type)) {
            params.set("graphComparisonType", "CPDAG");
            return GraphTransforms.cpdagForDag(graph);
        }
        if ("PAG".equals(type)) {
            params.set("graphComparisonType", "PAG");
            return GraphTransforms.dagToPag(graph);
        }
        params.set("graphComparisonType", "DAG");
        return new EdgeListGraph(graph);
    }

    public static void gfciExtraEdgeRemovalStep(Graph graph, Graph referenceCpdag, List<Node> nodes, SepsetProducer sepsets) {
        for (Node b : nodes) {
            int[] combination;
            if (Thread.currentThread().isInterrupted()) break;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(referenceCpdag.getAdjacentNodes(b));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                Set<Node> sepset;
                Node c;
                Node a = (Node)adjacentNodes.get(combination[0]);
                if (!graph.isAdjacentTo(a, c = (Node)adjacentNodes.get(combination[1])) || !referenceCpdag.isAdjacentTo(a, c) || (sepset = sepsets.getSepset(a, c)) == null) continue;
                graph.removeEdge(a, c);
            }
        }
    }

    public static void addForbiddenReverseEdgesForDirectedEdges(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        for (Node x : nodes) {
            for (Node y : nodes) {
                if (x == y || !graph.paths().isAncestorOf(x, y)) continue;
                knowledge.setForbidden(y.getName(), x.getName());
            }
        }
    }

    public static void removeNonSkeletonEdges(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        int numOfNodes = nodes.size();
        for (int i = 0; i < numOfNodes; ++i) {
            for (int j = i + 1; j < numOfNodes; ++j) {
                Node n1 = nodes.get(i);
                Node n2 = nodes.get(j);
                if (n1.getName().startsWith("E_") || n2.getName().startsWith("E_") || graph.isAdjacentTo(n1, n2)) continue;
                if (!knowledge.isForbidden(n1.getName(), n2.getName())) {
                    knowledge.setForbidden(n1.getName(), n2.getName());
                }
                if (knowledge.isForbidden(n2.getName(), n1.getName())) continue;
                knowledge.setForbidden(n2.getName(), n1.getName());
            }
        }
    }

    public static boolean compatible(Edge edge1, Edge edge2) {
        if (edge1 == null || edge2 == null) {
            return true;
        }
        Node x = edge1.getNode1();
        Node y = edge1.getNode2();
        Endpoint ex1 = edge1.getProximalEndpoint(x);
        Endpoint ey1 = edge1.getProximalEndpoint(y);
        Endpoint ex2 = edge2.getProximalEndpoint(x);
        Endpoint ey2 = edge2.getProximalEndpoint(y);
        return !(ex1 != Endpoint.CIRCLE && ex1 != ex2 && ex2 != Endpoint.CIRCLE || ey1 != Endpoint.CIRCLE && ey1 != ey2 && ey2 != Endpoint.CIRCLE);
    }

    public static Set<Node> markovBlanket(Node x, Graph G) {
        HashSet<Node> mb = new HashSet<Node>();
        LinkedList<Node> path = new LinkedList<Node>();
        GraphUtils.markovBlanketFollowColliders(null, x, path, G, mb);
        mb.addAll(G.getAdjacentNodes(x));
        mb.remove(x);
        return mb;
    }

    private static void markovBlanketFollowColliders(Node d, Node a, LinkedList<Node> path, Graph G, Set<Node> mb) {
        if (path.contains(a)) {
            return;
        }
        path.add(a);
        for (Node b : G.getNodesOutTo(a, Endpoint.ARROW)) {
            if (path.contains(b) || d != null && !G.isDefCollider(d, a, b)) continue;
            for (Node c : G.getNodesInTo(b, Endpoint.ARROW)) {
                if (path.contains(c) || !G.isDefCollider(a, b, c)) continue;
                mb.add(b);
                mb.add(c);
                GraphUtils.markovBlanketFollowColliders(a, b, path, G, mb);
            }
        }
        path.remove(a);
    }

    public static Set<Node> district(Node x, Graph G) {
        HashSet<Node> district = new HashSet<Node>();
        HashSet<Node> boundary = new HashSet<Node>();
        for (Edge e : G.getEdges(x)) {
            if (!Edges.isBidirectedEdge(e)) continue;
            Node other = e.getDistalNode(x);
            district.add(other);
            boundary.add(other);
        }
        do {
            HashSet previousBoundary = new HashSet(boundary);
            boundary = new HashSet();
            for (Node x2 : previousBoundary) {
                for (Edge e : G.getEdges(x2)) {
                    Node other;
                    if (!Edges.isBidirectedEdge(e) || district.contains(other = e.getDistalNode(x2))) continue;
                    district.add(other);
                    boundary.add(other);
                }
            }
        } while (!boundary.isEmpty());
        district.remove(x);
        return district;
    }

    public static boolean isDag(Graph graph) {
        boolean allDirected = true;
        for (Edge edge : graph.getEdges()) {
            if (Edges.isDirectedEdge(edge)) continue;
            allDirected = false;
        }
        return allDirected && !graph.paths().existsDirectedCycle();
    }

    public static Graph convert(String spec) {
        EdgeListGraph graph = new EdgeListGraph();
        StringTokenizer st1 = new StringTokenizer(spec, ", ");
        while (st1.hasMoreTokens()) {
            Node nodeB;
            Node nodeA;
            Edge edge;
            String edgeSpec = st1.nextToken();
            StringTokenizer st2 = new StringTokenizer(edgeSpec, "<>-o ");
            String var1 = st2.nextToken();
            if (var1.startsWith("Latent(")) {
                String latentName = (String)var1.subSequence(7, var1.length() - 1);
                GraphNode node = new GraphNode(latentName);
                node.setNodeType(NodeType.LATENT);
                graph.addNode(node);
                continue;
            }
            if (!st2.hasMoreTokens()) {
                graph.addNode(new GraphNode(var1));
                continue;
            }
            String var2 = st2.nextToken();
            if (graph.getNode(var1) == null) {
                graph.addNode(new GraphNode(var1));
            }
            if (graph.getNode(var2) == null) {
                graph.addNode(new GraphNode(var2));
            }
            if ((edge = graph.getEdge(nodeA = graph.getNode(var1), nodeB = graph.getNode(var2))) != null) {
                throw new IllegalArgumentException("Multiple edges connecting nodes is not supported.");
            }
            if (edgeSpec.lastIndexOf("-->") != -1) {
                graph.addDirectedEdge(nodeA, nodeB);
            }
            if (edgeSpec.lastIndexOf("<--") != -1) {
                graph.addDirectedEdge(nodeB, nodeA);
                continue;
            }
            if (edgeSpec.lastIndexOf("---") != -1) {
                graph.addUndirectedEdge(nodeA, nodeB);
                continue;
            }
            if (edgeSpec.lastIndexOf("<->") != -1) {
                graph.addBidirectedEdge(nodeA, nodeB);
                continue;
            }
            if (edgeSpec.lastIndexOf("o->") != -1) {
                graph.addPartiallyOrientedEdge(nodeA, nodeB);
                continue;
            }
            if (edgeSpec.lastIndexOf("<-o") != -1) {
                graph.addPartiallyOrientedEdge(nodeB, nodeA);
                continue;
            }
            if (edgeSpec.lastIndexOf("o-o") == -1) continue;
            graph.addNondirectedEdge(nodeB, nodeA);
        }
        return graph;
    }

    public static void gfciR0(Graph graph, Graph referenceCpdag, SepsetProducer sepsets, Knowledge knowledge) {
        graph.reorientAllWith(Endpoint.CIRCLE);
        GraphUtils.fciOrientbk(knowledge, graph, graph.getNodes());
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(graph.getAdjacentNodes(b));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Set<Node> sepset;
                Node c;
                Node a = (Node)adjacentNodes.get(combination[0]);
                if (referenceCpdag.isDefCollider(a, b, c = (Node)adjacentNodes.get(combination[1])) && FciOrient.isArrowheadAllowed(a, b, graph, knowledge) && FciOrient.isArrowheadAllowed(c, b, graph, knowledge)) {
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    graph.setEndpoint(c, b, Endpoint.ARROW);
                    continue;
                }
                if (!referenceCpdag.isAdjacentTo(a, c) || graph.isAdjacentTo(a, c) || (sepset = sepsets.getSepset(a, c)) == null || sepset.contains(b) || !FciOrient.isArrowheadAllowed(a, b, graph, knowledge) || !FciOrient.isArrowheadAllowed(c, b, graph, knowledge)) continue;
                graph.setEndpoint(a, b, Endpoint.ARROW);
                graph.setEndpoint(c, b, Endpoint.ARROW);
            }
        }
    }

    public static void fciOrientbk(Knowledge knowledge, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        Iterator<KnowledgeEdge> it = knowledge.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), variables);
            to = GraphSearchUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
        }
        it = knowledge.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), variables);
            to = GraphSearchUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
        }
    }

    public static Graph trimGraph(List<Node> targets, Graph graph, int trimmingStyle) {
        switch (trimmingStyle) {
            case 1: {
                break;
            }
            case 2: {
                graph = GraphUtils.trimAdjacentToTarget(targets, graph);
                break;
            }
            case 3: {
                graph = GraphUtils.trimMarkovBlanketGraph(targets, graph);
                break;
            }
            case 4: {
                graph = GraphUtils.trimSemidirected(targets, graph);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown trimming style: " + trimmingStyle);
            }
        }
        return graph;
    }

    private static Graph trimAdjacentToTarget(List<Node> targets, Graph graph) {
        EdgeListGraph _graph = new EdgeListGraph(graph);
        block0: for (Node m : graph.getNodes()) {
            if (targets.contains(m)) continue;
            for (Node n : targets) {
                if (!graph.isAdjacentTo(m, n)) continue;
                continue block0;
            }
            _graph.removeNode(m);
        }
        return _graph;
    }

    private static Graph trimMarkovBlanketGraph(List<Node> targets, Graph graph) {
        EdgeListGraph mbDag = new EdgeListGraph(graph);
        block0: for (Node n : graph.getNodes()) {
            if (targets.contains(n)) continue;
            for (Node m : targets) {
                if (!graph.isAdjacentTo(n, m)) continue;
                continue block0;
            }
            for (Node m : targets) {
                HashSet<Node> ch = new HashSet<Node>(graph.getChildren(m));
                ch.retainAll(graph.getChildren(n));
                if (ch.isEmpty()) continue;
                continue block0;
            }
            mbDag.removeNode(n);
        }
        return mbDag;
    }

    private static Graph trimSemidirected(List<Node> targets, Graph graph) {
        EdgeListGraph _graph = new EdgeListGraph(graph);
        block0: for (Node m : graph.getNodes()) {
            if (targets.contains(m)) continue;
            for (Node n : targets) {
                if (!graph.paths().existsSemiDirectedPath(m, n)) continue;
                continue block0;
            }
            _graph.removeNode(m);
        }
        return _graph;
    }

    private static class Counts {
        private final int[][] counts = new int[8][6];

        public void increment(int m, int n) {
            int[] nArray = this.counts[m];
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
        }

        public int getCount(int m, int n) {
            return this.counts[m][n];
        }

        public void addAll(Counts counts2) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 6; ++j) {
                    int[] nArray = this.counts[i];
                    int n = j;
                    nArray[n] = nArray[n] + counts2.getCount(i, j);
                }
            }
        }

        public int[][] countArray() {
            return this.counts;
        }
    }

    public static class TwoCycleErrors {
        public int twoCycCor;
        public int twoCycFn;
        public int twoCycFp;

        public TwoCycleErrors(int twoCycCor, int twoCycFn, int twoCycFp) {
            this.twoCycCor = twoCycCor;
            this.twoCycFn = twoCycFn;
            this.twoCycFp = twoCycFp;
        }

        public String toString() {
            return "2c cor = " + this.twoCycCor + "\t2c fn = " + this.twoCycFn + "\t2c fp = " + this.twoCycFp;
        }
    }

    public static class GraphComparison {
        private final int[][] counts;
        private final int adjFn;
        private final int adjFp;
        private final int adjCorrect;
        private final int arrowptFn;
        private final int arrowptFp;
        private final int arrowptCorrect;
        private final double adjPrec;
        private final double adjRec;
        private final double arrowptPrec;
        private final double arrowptRec;
        private final int shd;
        private final List<Edge> edgesAdded;
        private final List<Edge> edgesRemoved;

        public GraphComparison(int adjFn, int adjFp, int adjCorrect, int arrowptFn, int arrowptFp, int arrowptCorrect, double adjPrec, double adjRec, double arrowptPrec, double arrowptRec, int shd, List<Edge> edgesAdded, List<Edge> edgesRemoved, int[][] counts) {
            this.adjFn = adjFn;
            this.adjFp = adjFp;
            this.adjCorrect = adjCorrect;
            this.arrowptFn = arrowptFn;
            this.arrowptFp = arrowptFp;
            this.arrowptCorrect = arrowptCorrect;
            this.adjPrec = adjPrec;
            this.adjRec = adjRec;
            this.arrowptPrec = arrowptPrec;
            this.arrowptRec = arrowptRec;
            this.shd = shd;
            this.edgesAdded = edgesAdded;
            this.edgesRemoved = edgesRemoved;
            this.counts = counts;
        }

        public int getAdjFn() {
            return this.adjFn;
        }

        public int getAdjFp() {
            return this.adjFp;
        }

        public int getAdjCor() {
            return this.adjCorrect;
        }

        public int getAhdFn() {
            return this.arrowptFn;
        }

        public int getAhdFp() {
            return this.arrowptFp;
        }

        public int getAhdCor() {
            return this.arrowptCorrect;
        }

        public int getShd() {
            return this.shd;
        }

        public List<Edge> getEdgesAdded() {
            return this.edgesAdded;
        }

        public List<Edge> getEdgesRemoved() {
            return this.edgesRemoved;
        }

        public double getAdjPrec() {
            return this.adjPrec;
        }

        public double getAdjRec() {
            return this.adjRec;
        }

        public double getAhdPrec() {
            return this.arrowptPrec;
        }

        public double getAhdRec() {
            return this.arrowptRec;
        }

        public int[][] getCounts() {
            return this.counts;
        }
    }
}

