/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.graph.Triple;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LagGraph
implements Graph {
    private static final long serialVersionUID = 23L;
    private final List<String> variables = new ArrayList<String>();
    private final Map<String, List<Node>> laggedVariables = new HashMap<String, List<Node>>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Dag graph = new Dag();
    private Set<Triple> underLineTriples = new HashSet<Triple>();
    private Set<Triple> dottedUnderLineTriples = new HashSet<Triple>();
    private Set<Triple> ambiguousTriples = new HashSet<Triple>();
    private Paths paths;

    public static LagGraph serializableInstance() {
        return new LagGraph();
    }

    public boolean addVariable(String variable) {
        if (this.variables.contains(variable)) {
            return false;
        }
        for (String _variable : this.variables) {
            if (!variable.equals(_variable)) continue;
            return false;
        }
        this.variables.add(variable);
        this.laggedVariables.put(variable, new ArrayList());
        for (String node : this.variables) {
            List<Node> _lags = this.laggedVariables.get(node);
            GraphNode _newNode = new GraphNode(node + "." + _lags.size());
            _lags.add(_newNode);
            _newNode.setCenter(5, 5);
            this.addNode(_newNode);
        }
        return true;
    }

    @Override
    public boolean addDirectedEdge(Node node1, Node node2) {
        return this.getGraph().addDirectedEdge(node1, node2);
    }

    @Override
    public boolean addNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addBidirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addUndirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNondirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdge(Edge edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener e) {
        this.getGraph().addPropertyChangeListener(e);
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        this.getGraph().reorientAllWith(endpoint);
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getDegree() {
        return this.getGraph().getDegree();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.getGraph().getDirectedEdge(node1, node2);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.getGraph().getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    @Override
    public Set<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public int getDegree(Node node) {
        return this.getGraph().getDegree(node);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public void setNodes(List<Node> nodes) {
        this.graph.setNodes(nodes);
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public boolean isAdjacentTo(Node node1, Node node2) {
        return this.getGraph().isAdjacentTo(node1, node2);
    }

    public boolean isAncestorOf(Node node1, Node node2) {
        return this.getGraph().paths().isAncestorOf(node1, node2);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node2, node2);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.getGraph().isParentOf(node1, node2);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint n) {
        return this.getGraph().getNodesInTo(node, n);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.getGraph().getNodesOutTo(node, n);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        return this.getGraph().removeEdge(edge);
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        return this.getGraph().removeEdge(node1, node2);
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.getGraph().removeEdges(node1, node2);
    }

    @Override
    public boolean removeEdges(Collection<Edge> edges) {
        return this.getGraph().removeEdges(edges);
    }

    @Override
    public boolean removeNode(Node node) {
        return this.getGraph().removeNode(node);
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public boolean setEndpoint(Node from, Node to, Endpoint endPoint) {
        return this.getGraph().setEndpoint(from, to, endPoint);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferNodesAndEdges(graph);
    }

    @Override
    public void transferAttributes(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferAttributes(graph);
    }

    @Override
    public Paths paths() {
        return this.paths;
    }

    @Override
    public boolean isParameterizable(Node node) {
        return this.getGraph().isParameterizable(node);
    }

    @Override
    public boolean isTimeLagModel() {
        return false;
    }

    @Override
    public TimeLagGraph getTimeLagGraph() {
        return null;
    }

    @Override
    public Set<Node> getSepset(Node n1, Node n2) {
        throw new UnsupportedOperationException();
    }

    private Dag getGraph() {
        return this.graph;
    }

    public void setGraph(Dag graph) {
        this.graph = graph;
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    @Override
    public void setAmbiguousTriples(Set<Triple> triples) {
        this.ambiguousTriples.clear();
        for (Triple triple : triples) {
            this.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public Set<Triple> getUnderLines() {
        return new HashSet<Triple>(this.underLineTriples);
    }

    @Override
    public Set<Triple> getDottedUnderlines() {
        return new HashSet<Triple>(this.dottedUnderLineTriples);
    }

    @Override
    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        return this.ambiguousTriples.contains(new Triple(x, y, z));
    }

    @Override
    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        return this.underLineTriples.contains(new Triple(x, y, z));
    }

    @Override
    public void addAmbiguousTriple(Node x, Node y, Node z) {
        this.ambiguousTriples.add(new Triple(x, y, z));
    }

    @Override
    public void addUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            return;
        }
        this.underLineTriples.add(new Triple(x, y, z));
    }

    @Override
    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            return;
        }
        this.dottedUnderLineTriples.add(triple);
    }

    @Override
    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.ambiguousTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.underLineTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.dottedUnderLineTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void setUnderLineTriples(Set<Triple> triples) {
        this.underLineTriples.clear();
        for (Triple triple : triples) {
            this.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.dottedUnderLineTriples.clear();
        for (Triple triple : triples) {
            this.addDottedUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public void removeTriplesNotInGraph() {
        for (Triple triple : new HashSet<Triple>(this.ambiguousTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.ambiguousTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.ambiguousTriples.remove(triple);
        }
        for (Triple triple : new HashSet<Triple>(this.underLineTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.underLineTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.underLineTriples.remove(triple);
        }
        for (Triple triple : new HashSet<Triple>(this.dottedUnderLineTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.dottedUnderLineTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && !this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.dottedUnderLineTriples.remove(triple);
        }
    }
}

