/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.PointXy;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradAlgebra;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ProgressMonitor;
import org.apache.commons.math3.util.FastMath;

public class LayoutUtil {
    public static void kamadaKawaiLayout(Graph graph, boolean randomlyInitialized, double naturalEdgeLength, double springConstant, double stopEnergy) {
        KamadaKawaiLayout layout = new KamadaKawaiLayout(graph);
        layout.setRandomlyInitialized(randomlyInitialized);
        layout.setNaturalEdgeLength(naturalEdgeLength);
        layout.setSpringConstant(springConstant);
        layout.setStopEnergy(stopEnergy);
        layout.doLayout();
    }

    public static void fruchtermanReingoldLayout(Graph graph) {
        FruchtermanReingoldLayout layout = new FruchtermanReingoldLayout(graph);
        layout.doLayout();
    }

    public static void arrangeByLayout(Graph graph, HashMap<String, PointXy> layout) {
        for (Node node : graph.getNodes()) {
            PointXy point = layout.get(node.getName());
            node.setCenter(point.getX(), point.getY());
        }
    }

    public static void defaultLayout(Graph graph) {
        if (graph.getNumNodes() <= 20) {
            LayoutUtil.circleLayout(graph);
        } else {
            LayoutUtil.squareLayout(graph);
        }
    }

    public static void circleLayout(Graph graph) {
        if (graph == null) {
            return;
        }
        int centerx = 120 + 7 * graph.getNumNodes();
        int centery = 120 + 7 * graph.getNumNodes();
        int radius = centerx - 50;
        List<Node> nodes = graph.getNodes();
        Collections.sort(nodes);
        double rad = 6.28 / (double)nodes.size();
        double phi = 4.71;
        for (Node node : nodes) {
            int centerX = centerx + (int)((double)radius * FastMath.cos(phi));
            int centerY = centery + (int)((double)radius * FastMath.sin(phi));
            node.setCenterX(centerX);
            node.setCenterY(centerY);
            phi += rad;
        }
    }

    public static void squareLayout(Graph graph) {
        Node node;
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>(graph.getNodes());
        Collections.sort(nodes);
        int bufferx = 70;
        int buffery = 50;
        int spacex = 70;
        int spacey = 50;
        int side = nodes.size() / 4;
        if (nodes.size() % 4 != 0) {
            ++side;
        }
        for (i = 0; i < side && i < nodes.size(); ++i) {
            node = (Node)nodes.get(i);
            node.setCenterX(bufferx + spacex * i);
            node.setCenterY(buffery);
        }
        for (i = 0; i < side && i + side < nodes.size(); ++i) {
            node = (Node)nodes.get(i + side);
            node.setCenterX(bufferx + spacex * side);
            node.setCenterY(buffery + i * spacey);
        }
        for (i = 0; i < side && i + 2 * side < nodes.size(); ++i) {
            node = (Node)nodes.get(i + 2 * side);
            node.setCenterX(bufferx + spacex * (side - i));
            node.setCenterY(buffery + spacey * side);
        }
        for (i = 0; i < side && i + 3 * side < nodes.size(); ++i) {
            node = (Node)nodes.get(i + 3 * side);
            node.setCenterX(bufferx);
            node.setCenterY(buffery + spacey * (side - i));
        }
    }

    public static void layoutByCausalOrder(Graph graph) {
        List<List<Node>> tiers = LayoutUtil.getTiers(graph);
        int y = 0;
        for (List<Node> tier : tiers) {
            y += 60;
            if (tier.isEmpty()) continue;
            Node node = tier.get(0);
            int width = 80;
            int x = width / 2 + 10;
            node.setCenterX(x);
            node.setCenterY(y);
            int lastHalf = width / 2;
            for (int i = 1; i < tier.size(); ++i) {
                node = tier.get(i);
                int thisHalf = width / 2;
                node.setCenterX(x += lastHalf + thisHalf + 5);
                node.setCenterY(y);
                lastHalf = thisHalf;
            }
        }
    }

    private static List<List<Node>> getTiers(Graph graph) {
        HashSet found = new HashSet();
        LinkedList<List<Node>> tiers = new LinkedList<List<Node>>();
        HashSet<Node> notFound = new HashSet<Node>(graph.getNodes());
        while (!notFound.isEmpty()) {
            LinkedList<Node> thisTier = new LinkedList<Node>();
            for (Node node : notFound) {
                if (!found.containsAll(graph.getParents(node))) continue;
                thisTier.add(node);
            }
            if (thisTier.isEmpty()) {
                tiers.add(new ArrayList<Node>(notFound));
                break;
            }
            thisTier.forEach(notFound::remove);
            found.addAll(thisTier);
            tiers.add(thisTier);
        }
        return tiers;
    }

    public static boolean arrangeBySourceGraph(Graph resultGraph, Graph sourceGraph) {
        if (resultGraph == null) {
            throw new IllegalArgumentException("Graph must not be null.");
        }
        if (sourceGraph == null) {
            LayoutUtil.defaultLayout(resultGraph);
            return true;
        }
        boolean arrangedAll = true;
        for (Node o : resultGraph.getNodes()) {
            String name = o.getName();
            Node sourceNode = sourceGraph.getNode(name);
            if (sourceNode == null) {
                arrangedAll = false;
                continue;
            }
            o.setCenterX(sourceNode.getCenterX());
            o.setCenterY(sourceNode.getCenterY());
        }
        return arrangedAll;
    }

    public static final class KamadaKawaiLayout {
        private final Graph graph;
        private List<Node> componentNodes;
        private double naturalEdgeLength = 80.0;
        private double springConstant = 0.5;
        private double[][] p;
        private double[][] l;
        private double[][] k;
        private double leftmostX = -50.0;
        private ProgressMonitor monitor;
        private boolean randomlyInitialized;
        private double stopEnergy = 1.0;

        public KamadaKawaiLayout(Graph graph) {
            if (graph == null) {
                throw new NullPointerException();
            }
            this.graph = GraphUtils.undirectedGraph(graph);
        }

        public void doLayout() {
            LayoutUtil.defaultLayout(this.graph);
            this.monitor = new ProgressMonitor(null, "Energy settling...", "Energy = ?", 0, 100);
            this.getMonitor().setMillisToDecideToPopup(10);
            this.getMonitor().setMillisToPopup(0);
            this.getMonitor().setProgress(0);
            List<List<Node>> components = this.graph.paths().connectedComponents();
            components.sort((o1, o2) -> {
                int i1 = o1.size();
                int i2 = o2.size();
                return Integer.compare(i2, i1);
            });
            for (List<Node> component1 : components) {
                this.initialize(component1, this.isRandomlyInitialized());
                this.layoutComponent(component1);
            }
            this.getMonitor().setProgress(100);
        }

        private boolean isRandomlyInitialized() {
            return this.randomlyInitialized;
        }

        public void setRandomlyInitialized(boolean randomlyInitialized) {
            this.randomlyInitialized = randomlyInitialized;
        }

        private double getStopEnergy() {
            return this.stopEnergy;
        }

        public void setStopEnergy(double stopEnergy) {
            if (stopEnergy <= 0.0) {
                throw new IllegalArgumentException("Stop energy must be greater than zero.");
            }
            this.stopEnergy = stopEnergy;
        }

        private double getNaturalEdgeLength() {
            return this.naturalEdgeLength;
        }

        public void setNaturalEdgeLength(double naturalEdgeLength) {
            if (naturalEdgeLength < 0.0) {
                throw new IllegalArgumentException("Natural edge length should be greater than zero.");
            }
            this.naturalEdgeLength = naturalEdgeLength;
        }

        private double getSpringConstant() {
            return this.springConstant;
        }

        public void setSpringConstant(double springConstant) {
            if (springConstant < 0.0) {
                throw new IllegalArgumentException("Spring constant should be greater than zero.");
            }
            this.springConstant = springConstant;
        }

        private void initialize(List<Node> nodes, boolean randomlyInitialized) {
            int i;
            this.setComponentNodes(Collections.unmodifiableList(nodes));
            this.p = new double[nodes.size()][2];
            this.l = new double[nodes.size()][nodes.size()];
            this.k = new double[nodes.size()][nodes.size()];
            if (randomlyInitialized) {
                for (i = 0; i < nodes.size(); ++i) {
                    this.p[i][0] = RandomUtil.getInstance().nextInt(600);
                    this.p[i][1] = RandomUtil.getInstance().nextInt(600);
                }
            } else {
                for (i = 0; i < nodes.size(); ++i) {
                    Node node = nodes.get(i);
                    this.p[i][0] = node.getCenterX();
                    this.p[i][1] = node.getCenterY();
                }
            }
            int[][] d = this.allPairsShortestPath();
            for (i = 0; i < nodes.size(); ++i) {
                for (int j = 0; j < nodes.size(); ++j) {
                    if (i == j) continue;
                    this.l[i][j] = this.getNaturalEdgeLength() * (double)d[i][j];
                }
            }
            for (i = 0; i < nodes.size(); ++i) {
                for (int j = 0; j < nodes.size(); ++j) {
                    if (i == j) continue;
                    this.k[i][j] = this.getSpringConstant() / (double)(d[i][j] * d[i][j]);
                }
            }
        }

        private void layoutComponent(List<Node> componentNodes) {
            this.setComponentNodes(componentNodes);
            this.optimize(this.getStopEnergy());
            this.shiftComponentToRight(componentNodes);
        }

        private void shiftComponentToRight(List<Node> componentNodes) {
            int i;
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            for (i = 0; i < componentNodes.size(); ++i) {
                if (this.p[i][0] < minX) {
                    minX = this.p[i][0];
                }
                if (!(this.p[i][1] < minY)) continue;
                minY = this.p[i][1];
            }
            this.leftmostX += 100.0;
            for (i = 0; i < componentNodes.size(); ++i) {
                double[] dArray = this.p[i];
                dArray[0] = dArray[0] + (this.leftmostX - minX);
                double[] dArray2 = this.p[i];
                dArray2[1] = dArray2[1] + (40.0 - minY);
            }
            for (i = 0; i < componentNodes.size(); ++i) {
                if (!(this.p[i][0] > this.leftmostX)) continue;
                this.leftmostX = this.p[i][0];
            }
            for (i = 0; i < componentNodes.size(); ++i) {
                Node node = componentNodes.get(i);
                node.setCenterX((int)this.p[i][0]);
                node.setCenterY((int)this.p[i][1]);
            }
        }

        private void optimize(double deltaCutoff) {
            double maxDelta;
            NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
            double initialMaxDelta = -1.0;
            int jump = 100;
            Matrix a = new Matrix(2, 2);
            Matrix b = new Matrix(2, 1);
            int oldM = -1;
            block2: do {
                if (this.monitor.isCanceled()) {
                    return;
                }
                int[] m = new int[1];
                maxDelta = this.maxDelta(m);
                if (initialMaxDelta == -1.0) {
                    initialMaxDelta = maxDelta;
                }
                if (m[0] == oldM) {
                    double[] dArray = this.p[m[0]];
                    dArray[0] = dArray[0] + (double)(RandomUtil.getInstance().nextInt(200) - 100);
                    double[] dArray2 = this.p[m[0]];
                    dArray2[1] = dArray2[1] + (double)(RandomUtil.getInstance().nextInt(200) - 100);
                    continue;
                }
                oldM = m[0];
                int progress = (int)(99.0 - 98.0 * maxDelta / (0.5 * initialMaxDelta));
                if (progress < 1) {
                    progress = 1;
                }
                if (progress > 99) {
                    progress = 99;
                }
                this.getMonitor().setProgress(progress);
                this.getMonitor().setNote("Energy = " + nf.format(maxDelta));
                if (m[0] == -1) {
                    throw new IllegalStateException();
                }
                double oldDelta = Double.NaN;
                while (true) {
                    Matrix c;
                    double d;
                    double delta = this.delta(m[0]);
                    if (!(d > deltaCutoff)) continue block2;
                    Thread.yield();
                    if (this.monitor.isCanceled()) {
                        return;
                    }
                    if (FastMath.abs(delta - oldDelta) < 0.001) {
                        double[] dArray = this.p[m[0]];
                        dArray[0] = dArray[0] + (double)(RandomUtil.getInstance().nextInt(200) - 100);
                        double[] dArray3 = this.p[m[0]];
                        dArray3[1] = dArray3[1] + (double)(RandomUtil.getInstance().nextInt(200) - 100);
                        continue;
                    }
                    double h = 0.01;
                    double partialXX = this.secondPartial(m[0], 0, 0);
                    double partialXY = this.secondPartial(m[0], 0, 1);
                    double partialX = this.firstPartial(m[0], 0, 0.01);
                    double partialYY = this.secondPartial(m[0], 1, 1);
                    double partialY = this.firstPartial(m[0], 1, 0.01);
                    a.set(0, 0, partialXX);
                    a.set(0, 1, partialXY);
                    a.set(1, 0, partialXY);
                    a.set(1, 1, partialYY);
                    b.set(0, 0, -partialX);
                    b.set(1, 0, -partialY);
                    try {
                        c = TetradAlgebra.solve(a, b);
                    }
                    catch (Exception e) {
                        double[] dArray = this.p[m[0]];
                        dArray[0] = dArray[0] + (double)(RandomUtil.getInstance().nextInt(200) - 100);
                        double[] dArray4 = this.p[m[0]];
                        dArray4[1] = dArray4[1] + (double)(RandomUtil.getInstance().nextInt(200) - 100);
                        continue;
                    }
                    double dx = c.get(0, 0);
                    double dy = c.get(1, 0);
                    double[] dArray = this.p[m[0]];
                    dArray[0] = dArray[0] + dx;
                    double[] dArray5 = this.p[m[0]];
                    dArray5[1] = dArray5[1] + dy;
                    oldDelta = delta;
                }
            } while (maxDelta > deltaCutoff);
        }

        private double energy() {
            int n = this.p.length;
            double sum = 0.0;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    sum += 0.5 * this.k[i][j] * FastMath.pow(this.distance(i, j) - this.l[i][j], 2.0);
                }
            }
            return sum;
        }

        private double maxDelta(int[] index) {
            double maxDelta = Double.NEGATIVE_INFINITY;
            int m = -1;
            for (int i = 0; i < this.getComponentNodes().size(); ++i) {
                double delta = this.delta(i);
                if (delta == Double.NEGATIVE_INFINITY) {
                    throw new IllegalStateException();
                }
                if (!(delta > maxDelta)) continue;
                maxDelta = delta;
                m = i;
            }
            index[0] = m;
            return maxDelta;
        }

        private double delta(int i) {
            double partialX = this.firstPartial(i, 0, 1.0E-4);
            double partialY = this.firstPartial(i, 1, 1.0E-4);
            return FastMath.sqrt(partialX * partialX + partialY * partialY);
        }

        private double firstPartial(int i, int var, double h) {
            double storedCoord = this.p[i][var];
            double[] dArray = this.p[i];
            int n = var;
            dArray[n] = dArray[n] - h;
            double energy1 = this.energy();
            double[] dArray2 = this.p[i];
            int n2 = var;
            dArray2[n2] = dArray2[n2] + h;
            double energy2 = this.energy();
            this.p[i][var] = storedCoord;
            return (energy2 - energy1) / (2.0 * h);
        }

        private double secondPartial(int m, int i, int j) {
            double storedX = this.p[m][0];
            double storedY = this.p[m][1];
            double[] dArray = this.p[m];
            int n = i;
            dArray[n] = dArray[n] + 0.01;
            double[] dArray2 = this.p[m];
            int n2 = j;
            dArray2[n2] = dArray2[n2] + 0.01;
            double ff1 = this.energy();
            double[] dArray3 = this.p[m];
            int n3 = j;
            dArray3[n3] = dArray3[n3] - 0.02;
            double ff2 = this.energy();
            double[] dArray4 = this.p[m];
            int n4 = i;
            dArray4[n4] = dArray4[n4] - 0.02;
            double[] dArray5 = this.p[m];
            int n5 = j;
            dArray5[n5] = dArray5[n5] + 0.02;
            double ff3 = this.energy();
            double[] dArray6 = this.p[m];
            int n6 = j;
            dArray6[n6] = dArray6[n6] - 0.02;
            double ff4 = this.energy();
            this.p[m][0] = storedX;
            this.p[m][1] = storedY;
            return (ff1 - ff2 - ff3 + ff4) / 4.0E-4;
        }

        private double distance(int i, int j) {
            double x1 = this.p[i][0];
            double y1 = this.p[i][1];
            double x2 = this.p[j][0];
            double y2 = this.p[j][1];
            return FastMath.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        }

        private int[][] allPairsShortestPath() {
            int[][] I1 = new int[this.getComponentNodes().size()][this.getComponentNodes().size()];
            int[][] I2 = new int[this.getComponentNodes().size()][this.getComponentNodes().size()];
            int infinity = this.getComponentNodes().size() * this.getComponentNodes().size();
            for (int i = 0; i < this.getComponentNodes().size(); ++i) {
                for (int j = 0; j < this.getComponentNodes().size(); ++j) {
                    Node node2;
                    Node node1 = this.getComponentNodes().get(i);
                    I2[i][j] = this.graph.getEdge(node1, node2 = this.getComponentNodes().get(j)) != null ? 1 : infinity;
                }
            }
            for (int k = 0; k < this.getComponentNodes().size(); ++k) {
                int[][] temp = I1;
                I1 = I2;
                I2 = temp;
                for (int i = 0; i < this.getComponentNodes().size(); ++i) {
                    for (int j = 0; j < this.getComponentNodes().size(); ++j) {
                        I2[i][j] = FastMath.min(I1[i][j], I1[i][k] + I1[k][j]);
                    }
                }
            }
            return I2;
        }

        private ProgressMonitor getMonitor() {
            return this.monitor;
        }

        private List<Node> getComponentNodes() {
            return this.componentNodes;
        }

        private void setComponentNodes(List<Node> componentNodes) {
            this.componentNodes = componentNodes;
        }
    }

    public static final class FruchtermanReingoldLayout {
        private final Graph graph;
        private int[][] edges;
        private double[][] nodePosition;
        private double[][] nodeDisposition;
        private double optimalDistance = 100.0;
        private double temperature;
        private double leftmostX = -50.0;

        public FruchtermanReingoldLayout(Graph graph) {
            if (graph == null) {
                throw new NullPointerException();
            }
            this.graph = graph;
        }

        public void doLayout() {
            LayoutUtil.defaultLayout(this.graph);
            List<List<Node>> components = this.graph.paths().connectedComponents();
            components.sort((o1, o2) -> {
                int i1 = o1.size();
                int i2 = o2.size();
                return Integer.compare(i2, i1);
            });
            for (List<Node> component1 : components) {
                Collections.sort(component1);
                this.layoutComponent(component1);
            }
        }

        private void layoutComponent(List<Node> nodes) {
            int numNodes = nodes.size();
            this.nodePosition = new double[numNodes][2];
            this.nodeDisposition = new double[numNodes][2];
            for (int i = 0; i < numNodes; ++i) {
                Node node = nodes.get(i);
                this.nodePosition()[i][0] = node.getCenterX();
                this.nodePosition()[i][1] = node.getCenterY();
            }
            ArrayList<Edge> edges = new ArrayList<Edge>(GraphUtils.undirectedGraph(this.graph()).getEdges());
            edges.removeIf(edge -> !nodes.contains(edge.getNode1()) || !nodes.contains(edge.getNode2()));
            this.edges = new int[edges.size()][2];
            for (int i = 0; i < edges.size(); ++i) {
                Edge edge2 = (Edge)edges.get(i);
                int v = nodes.indexOf(edge2.getNode1());
                int u = nodes.indexOf(edge2.getNode2());
                this.edges()[i][0] = v;
                this.edges()[i][1] = u;
            }
            double avgDegree = (double)(2 * this.graph.getNumEdges()) / (double)this.graph.getNumNodes();
            this.setOptimalDistance(20.0 + 20.0 * avgDegree);
            this.setTemperature();
            for (int i = 0; i < this.numIterations(); ++i) {
                int u;
                int v;
                for (v = 0; v < numNodes; ++v) {
                    this.nodeDisposition()[v][0] = 0.1;
                    this.nodeDisposition()[v][1] = 0.1;
                    for (u = 0; u < numNodes; ++u) {
                        double deltaY;
                        double deltaX = this.nodePosition()[u][0] - this.nodePosition()[v][0];
                        double norm = this.norm(deltaX, deltaY = this.nodePosition()[u][1] - this.nodePosition()[v][1]);
                        if (norm == 0.0) {
                            norm = 0.1;
                        }
                        double repulsiveForce = this.fr(norm);
                        double[] dArray = this.nodeDisposition()[v];
                        dArray[0] = dArray[0] + deltaX / norm * repulsiveForce;
                        double[] dArray2 = this.nodeDisposition()[v];
                        dArray2[1] = dArray2[1] + deltaY / norm * repulsiveForce;
                    }
                }
                for (int j = 0; j < edges.size(); ++j) {
                    double deltaY;
                    u = this.edges()[j][0];
                    int v2 = this.edges()[j][1];
                    double deltaX = this.nodePosition()[v2][0] - this.nodePosition()[u][0];
                    double norm = this.norm(deltaX, deltaY = this.nodePosition()[v2][1] - this.nodePosition()[u][1]);
                    if (norm == 0.0) {
                        norm = 0.1;
                    }
                    double attractiveForce = this.fa(norm);
                    double attractX = deltaX / norm * attractiveForce;
                    double attractY = deltaY / norm * attractiveForce;
                    double[] dArray = this.nodeDisposition()[v2];
                    dArray[0] = dArray[0] - attractX;
                    double[] dArray3 = this.nodeDisposition()[v2];
                    dArray3[1] = dArray3[1] - attractY;
                    if (Double.isNaN(this.nodeDisposition()[v2][0]) || Double.isNaN(this.nodeDisposition()[v2][1])) {
                        throw new IllegalStateException("Undefined disposition.");
                    }
                    double[] dArray4 = this.nodeDisposition()[u];
                    dArray4[0] = dArray4[0] + attractX;
                    double[] dArray5 = this.nodeDisposition()[u];
                    dArray5[1] = dArray5[1] + attractY;
                    if (!Double.isNaN(this.nodeDisposition()[u][0]) && !Double.isNaN(this.nodeDisposition()[u][1])) continue;
                    throw new IllegalStateException("Undefined disposition.");
                }
                for (v = 0; v < numNodes; ++v) {
                    double norm = this.norm(this.nodeDisposition()[v][0], this.nodeDisposition()[v][1]);
                    double[] dArray = this.nodePosition()[v];
                    dArray[0] = dArray[0] + this.nodeDisposition()[v][0] / norm * FastMath.min(norm, this.getTemperature());
                    double[] dArray6 = this.nodePosition()[v];
                    dArray6[1] = dArray6[1] + this.nodeDisposition()[v][1] / norm * FastMath.min(norm, this.getTemperature());
                    if (!Double.isNaN(this.nodePosition()[v][0]) && !Double.isNaN(this.nodePosition()[v][1])) continue;
                    throw new IllegalStateException("Undefined position.");
                }
            }
            this.shiftComponentToRight(nodes);
        }

        private void shiftComponentToRight(List<Node> componentNodes) {
            int i;
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            for (i = 0; i < componentNodes.size(); ++i) {
                if (this.nodePosition()[i][0] < minX) {
                    minX = this.nodePosition()[i][0];
                }
                if (!(this.nodePosition()[i][1] < minY)) continue;
                minY = this.nodePosition()[i][1];
            }
            this.leftmostX = this.leftmostX() + 100.0;
            for (i = 0; i < componentNodes.size(); ++i) {
                double[] dArray = this.nodePosition()[i];
                dArray[0] = dArray[0] + (this.leftmostX() - minX);
                double[] dArray2 = this.nodePosition()[i];
                dArray2[1] = dArray2[1] + (40.0 - minY);
            }
            for (i = 0; i < componentNodes.size(); ++i) {
                if (!(this.nodePosition()[i][0] > this.leftmostX())) continue;
                this.leftmostX = this.nodePosition()[i][0];
            }
            for (i = 0; i < componentNodes.size(); ++i) {
                Node node = componentNodes.get(i);
                node.setCenterX((int)this.nodePosition()[i][0]);
                node.setCenterY((int)this.nodePosition()[i][1]);
            }
        }

        private double fa(double d) {
            return d * d / this.getOptimalDistance();
        }

        private double fr(double d) {
            return -(this.getOptimalDistance() * this.getOptimalDistance()) / d;
        }

        private double norm(double x, double y) {
            return FastMath.sqrt(x * x + y * y);
        }

        private Graph graph() {
            return this.graph;
        }

        private int[][] edges() {
            return this.edges;
        }

        private double[][] nodePosition() {
            return this.nodePosition;
        }

        private double[][] nodeDisposition() {
            return this.nodeDisposition;
        }

        private int numIterations() {
            return 500;
        }

        private double leftmostX() {
            return this.leftmostX;
        }

        private double getOptimalDistance() {
            return this.optimalDistance;
        }

        private void setOptimalDistance(double optimalDistance) {
            this.optimalDistance = optimalDistance;
        }

        private double getTemperature() {
            return this.temperature;
        }

        private void setTemperature() {
            this.temperature = 5.0;
        }
    }
}

