/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.NodeVariableType;
import edu.cmu.tetrad.util.TetradSerializable;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.regex.Pattern;

public interface Node
extends TetradSerializable,
Comparable<Node> {
    public static final Pattern ALPHA = Pattern.compile("^[a-zA-Z]+$");
    public static final Pattern ALPHA_NUM = Pattern.compile("^[a-zA-Z]+[0-9]+$");
    public static final Pattern LAG = Pattern.compile("^.+:[0-9]+$");
    public static final long serialVersionUID = 23L;

    public String getName();

    public void setName(String var1);

    public NodeType getNodeType();

    public void setNodeType(NodeType var1);

    public NodeVariableType getNodeVariableType();

    public void setNodeVariableType(NodeVariableType var1);

    public String toString();

    public int getCenterX();

    public void setCenterX(int var1);

    public int getCenterY();

    public void setCenterY(int var1);

    public void setCenter(int var1, int var2);

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public int hashCode();

    public boolean equals(Object var1);

    public Node like(String var1);

    @Override
    default public int compareTo(Node node) {
        String node1 = this.getName();
        String node2 = node.getName();
        boolean isAlpha1 = ALPHA.matcher(node1).matches();
        boolean isAlpha2 = ALPHA.matcher(node2).matches();
        boolean isAlphaNum1 = ALPHA_NUM.matcher(node1).matches();
        boolean isAlphaNum2 = ALPHA_NUM.matcher(node2).matches();
        boolean isLag1 = LAG.matcher(node1).matches();
        boolean isLag2 = LAG.matcher(node2).matches();
        if (isAlpha1) {
            if (isLag2) {
                return -1;
            }
        } else if (isAlphaNum1) {
            if (isAlphaNum2) {
                String s2;
                String s1 = node1.replaceAll("\\d+", "");
                if (s1.equals(s2 = node2.replaceAll("\\d+", ""))) {
                    String n1 = node1.replaceAll("\\D+", "");
                    String n2 = node2.replaceAll("\\D+", "");
                    return Integer.valueOf(n1).compareTo(Integer.valueOf(n2));
                }
                return s1.compareTo(s2);
            }
            if (isLag2) {
                return -1;
            }
        } else if (isLag1) {
            if (isAlpha2 || isAlphaNum2) {
                return 1;
            }
            if (isLag2) {
                String s2;
                String l1 = node1.replaceAll(":", "");
                String l2 = node2.replaceAll(":", "");
                String s1 = l1.replaceAll("\\d+", "");
                if (s1.equals(s2 = l2.replaceAll("\\d+", ""))) {
                    String n1 = l1.replaceAll("\\D+", "");
                    String n2 = l2.replaceAll("\\D+", "");
                    return Integer.valueOf(n1).compareTo(Integer.valueOf(n2));
                }
                return s1.compareTo(s2);
            }
        }
        return node1.compareTo(node2);
    }

    public Map<String, Object> getAllAttributes();

    public Object getAttribute(String var1);

    public void removeAttribute(String var1);

    public void addAttribute(String var1, Object var2);
}

