/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.Regression;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.Vector;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class RegressionDataset
implements Regression {
    private final Matrix data;
    private final List<Node> variables;
    private double alpha = 0.05;
    private Graph graph;
    private int[] rows;
    private Vector res2;

    public RegressionDataset(DataSet data) {
        this.data = data.getDoubleData();
        this.variables = data.getVariables();
        this.setRows(new int[data.getNumRows()]);
        for (int i = 0; i < this.getRows().length; ++i) {
            this.getRows()[i] = i;
        }
    }

    public RegressionDataset(Matrix data, List<Node> variables) {
        this.data = data;
        this.variables = variables;
        this.setRows(new int[data.getNumRows()]);
        for (int i = 0; i < this.getRows().length; ++i) {
            this.getRows()[i] = i;
        }
    }

    public static RegressionResult regress(double[] target, double[][] regressors) {
        Matrix xTy;
        Matrix xT;
        Matrix xTx;
        Matrix xTxInv;
        Matrix b;
        int n = target.length;
        int k = regressors.length + 1;
        String[] regressorNames = new String[regressors.length];
        for (int i = 0; i < regressors.length; ++i) {
            regressorNames[i] = "X" + (i + 1);
        }
        Matrix y = new Matrix(new double[][]{target}).transpose();
        Matrix x = new Matrix(regressors).transpose();
        Matrix yHat = x.times(b = (xTxInv = (xTx = (xT = x.transpose()).times(x)).inverse()).times(xTy = xT.times(y)));
        if (yHat.getNumColumns() == 0) {
            yHat = y.like();
        }
        Matrix res = y.minus(yHat);
        Vector _yHat = yHat.getColumn(0);
        Vector _res = res.getColumn(0);
        yHat.getNumColumns();
        double rss = RegressionDataset.rss(x, y, b);
        double se = FastMath.sqrt(rss / (double)(n - k));
        double tss = RegressionDataset.tss(y);
        double r2 = 1.0 - rss / tss;
        Vector sqErr = new Vector(x.getNumColumns());
        Vector t = new Vector(x.getNumColumns());
        Vector p = new Vector(x.getNumColumns());
        for (int i = 0; i < x.getNumColumns(); ++i) {
            double _s = se * se * xTxInv.get(i, i);
            double _se = FastMath.sqrt(_s);
            double _t = b.get(i, 0) / _se;
            double _p = 1.0 - ProbUtils.tCdf(FastMath.abs(_t), n - k);
            sqErr.set(i, _se);
            t.set(i, _t);
            p.set(i, _p);
        }
        double[] bArray = b.getNumColumns() == 0 ? new double[]{} : b.getColumn(0).toArray();
        double[] tArray = t.toArray();
        double[] pArray = p.toArray();
        double[] seArray = sqErr.toArray();
        return new RegressionResult(true, regressorNames, n, bArray, tArray, pArray, seArray, r2, rss, 0.05, _res);
    }

    private static double rss(Matrix x, Matrix y, Matrix b) {
        double rss = 0.0;
        for (int i = 0; i < x.getNumRows(); ++i) {
            double yH = 0.0;
            for (int j = 0; j < x.getNumColumns(); ++j) {
                yH += b.get(j, 0) * x.get(i, j);
            }
            double d = y.get(i, 0) - yH;
            rss += d * d;
        }
        return rss;
    }

    private static double tss(Matrix y) {
        double mean = 0.0;
        for (int i = 0; i < y.getNumRows(); ++i) {
            mean += y.get(i, 0);
        }
        mean /= (double)y.getNumRows();
        double ssm = 0.0;
        for (int i = 0; i < y.getNumRows(); ++i) {
            double d = mean - y.get(i, 0);
            ssm += d * d;
        }
        return ssm;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public RegressionResult regress(Node target, List<Node> regressors) {
        Matrix xTy;
        Matrix xT;
        Matrix xTx;
        Matrix xTxInv;
        Matrix b;
        Matrix yHat;
        int j;
        int i;
        Matrix x;
        int n = this.getRows().length;
        int k = regressors.size() + 1;
        int _target = this.variables.indexOf(target);
        int[] _regressors = new int[regressors.size()];
        for (int i2 = 0; i2 < regressors.size(); ++i2) {
            _regressors[i2] = this.variables.indexOf(regressors.get(i2));
            if (_regressors[i2] != -1) continue;
            System.out.println();
        }
        if (_target == -1) {
            System.out.println();
        }
        Matrix y = this.data.getSelection(this.getRows(), new int[]{_target}).copy();
        Matrix xSub = this.data.getSelection(this.getRows(), _regressors);
        if (regressors.size() > 0) {
            x = new Matrix(xSub.getNumRows(), xSub.getNumColumns() + 1);
            for (i = 0; i < x.getNumRows(); ++i) {
                for (j = 0; j < x.getNumColumns(); ++j) {
                    if (j == 0) {
                        x.set(i, 0, 1.0);
                        continue;
                    }
                    x.set(i, j, xSub.get(i, j - 1));
                }
            }
        } else {
            x = new Matrix(xSub.getNumRows(), xSub.getNumColumns());
            for (i = 0; i < x.getNumRows(); ++i) {
                for (j = 0; j < x.getNumColumns(); ++j) {
                    x.set(i, j, xSub.get(i, j));
                }
            }
        }
        if ((yHat = x.times(b = (xTxInv = (xTx = (xT = x.transpose()).times(x)).inverse()).times(xTy = xT.times(y)))).getNumColumns() == 0) {
            yHat = y.like();
        }
        Matrix res = y.minus(yHat);
        Vector _yHat = yHat.getColumn(0);
        Vector _res = res.getColumn(0);
        Matrix b2 = b.copy();
        Matrix yHat2 = x.times(b2);
        if (yHat.getNumColumns() == 0) {
            yHat2 = y.like();
        }
        Matrix res2 = y.minus(yHat2);
        this.res2 = res2.getColumn(0);
        double rss = RegressionDataset.rss(x, y, b);
        double se = FastMath.sqrt(rss / (double)(n - k));
        double tss = RegressionDataset.tss(y);
        double r2 = 1.0 - rss / tss;
        Vector sqErr = new Vector(x.getNumColumns());
        Vector t = new Vector(x.getNumColumns());
        Vector p = new Vector(x.getNumColumns());
        for (int i3 = 0; i3 < x.getNumColumns(); ++i3) {
            double _s = se * se * xTxInv.get(i3, i3);
            double _se = FastMath.sqrt(_s);
            double _t = b.get(i3, 0) / _se;
            double _p = 1.0 - ProbUtils.tCdf(FastMath.abs(_t), n - k);
            sqErr.set(i3, _se);
            t.set(i3, _t);
            p.set(i3, _p);
        }
        this.graph = this.createOutputGraph(target.getName(), x, regressors, p);
        String[] vNames = new String[regressors.size()];
        for (int i4 = 0; i4 < regressors.size(); ++i4) {
            vNames[i4] = regressors.get(i4).getName();
        }
        double[] bArray = b.getNumColumns() == 0 ? new double[]{} : b.getColumn(0).toArray();
        double[] tArray = t.toArray();
        double[] pArray = p.toArray();
        double[] seArray = sqErr.toArray();
        return new RegressionResult(regressors.size() == 0, vNames, n, bArray, tArray, pArray, seArray, r2, rss, this.alpha, _res);
    }

    @Override
    public RegressionResult regress(Node target, Node ... regressors) {
        List<Node> _regressors = Arrays.asList(regressors);
        return this.regress(target, _regressors);
    }

    private Graph createOutputGraph(String target, Matrix x, List<Node> regressors, Vector p) {
        GraphNode targetNode = new GraphNode(target);
        EdgeListGraph graph = new EdgeListGraph();
        graph.addNode(targetNode);
        for (int i = 0; i < x.getNumColumns(); ++i) {
            String variableName;
            String string = variableName = i > 0 ? regressors.get(i - 1).getName() : "const";
            if (!(p.get(i) < this.alpha)) continue;
            GraphNode predictorNode = new GraphNode(variableName);
            graph.addNode(predictorNode);
            Edge newEdge = new Edge(predictorNode, targetNode, Endpoint.TAIL, Endpoint.ARROW);
            graph.addEdge(newEdge);
        }
        return graph;
    }

    private int[] getRows() {
        return this.rows;
    }

    public void setRows(int[] rows) {
        this.rows = rows;
    }

    public Vector getResidualsWithoutFirstRegressor() {
        return this.res2;
    }
}

