/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Vector;
import java.util.HashSet;
import java.util.LinkedList;

public class RegressionUtils {
    public static DataSet residuals(DataSet dataSet, Graph graph) {
        RegressionDataset regression = new RegressionDataset(dataSet);
        Matrix residuals = new Matrix(dataSet.getNumRows(), dataSet.getNumColumns());
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            Node target = dataSet.getVariable(i);
            Node _target = graph.getNode(target.getName());
            if (_target == null) {
                throw new IllegalArgumentException("Data variable not in graph: " + target);
            }
            HashSet<Node> _regressors = new HashSet<Node>(graph.getParents(_target));
            System.out.println("For " + target + " regressors are " + _regressors);
            LinkedList<Node> regressors = new LinkedList<Node>();
            for (Node node : _regressors) {
                regressors.add(dataSet.getVariable(node.getName()));
            }
            RegressionResult result = regression.regress(target, regressors);
            Vector residualsColumn = result.getResiduals();
            residuals.assignColumn(i, residualsColumn);
        }
        return new BoxDataSet(new DoubleDataBox(residuals.toArray()), dataSet.getVariables());
    }
}

