/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.PossibleMsepFci;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.search.utils.SepsetsConservative;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public final class Cfci
implements IGraphSearch {
    private final SepsetMap sepsets = new SepsetMap();
    private final List<Node> variables = new ArrayList<Node>();
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Graph graph;
    private Knowledge knowledge = new Knowledge();
    private boolean completeRuleSetUsed = true;
    private boolean possibleMsepSearchDone = true;
    private int maxReachablePathLength = -1;
    private Set<Triple> ambiguousTriples;
    private int depth = -1;
    private long elapsedTime;
    private boolean verbose;
    private boolean doDiscriminatingPathRule;

    public Cfci(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
    }

    @Override
    public Graph search() {
        long beginTime = MillisecondTimes.timeMillis();
        if (this.verbose) {
            this.logger.log("info", "Starting FCI algorithm.");
            this.logger.log("info", "Independence test = " + this.independenceTest + ".");
        }
        this.setMaxReachablePathLength(this.maxReachablePathLength);
        LinkedList<Node> nodes = new LinkedList<Node>(this.variables);
        this.graph = new EdgeListGraph(nodes);
        this.graph.fullyConnect(Endpoint.TAIL);
        Fas adj = new Fas(this.independenceTest);
        adj.setKnowledge(this.knowledge);
        adj.setDepth(this.depth);
        adj.setVerbose(this.verbose);
        this.graph = adj.search();
        this.graph.reorientAllWith(Endpoint.CIRCLE);
        if (this.isPossibleMsepSearchDone()) {
            long time1 = MillisecondTimes.timeMillis();
            this.ruleR0(this.independenceTest, this.depth, this.sepsets);
            long time2 = MillisecondTimes.timeMillis();
            if (this.verbose) {
                this.logger.log("info", "Step C: " + (double)(time2 - time1) / 1000.0 + "s");
            }
            long time3 = MillisecondTimes.timeMillis();
            PossibleMsepFci possibleMSep = new PossibleMsepFci(this.graph, this.independenceTest);
            possibleMSep.setDepth(this.depth);
            possibleMSep.setKnowledge(this.knowledge);
            possibleMSep.setMaxPathLength(this.getMaxReachablePathLength());
            this.sepsets.addAll(possibleMSep.search());
            long time4 = MillisecondTimes.timeMillis();
            if (this.verbose) {
                this.logger.log("info", "Step D: " + (double)(time4 - time3) / 1000.0 + "s");
            }
            this.graph.reorientAllWith(Endpoint.CIRCLE);
        }
        long time5 = MillisecondTimes.timeMillis();
        this.fciOrientbk(this.knowledge, this.graph, this.variables);
        this.ruleR0(this.independenceTest, this.depth, this.sepsets);
        long time6 = MillisecondTimes.timeMillis();
        if (this.verbose) {
            this.logger.log("info", "Step CI C: " + (double)(time6 - time5) / 1000.0 + "s");
        }
        FciOrient fciOrient = new FciOrient(new SepsetsConservative(this.graph, this.independenceTest, new SepsetMap(), this.depth));
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setMaxPathLength(-1);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.ruleR0(this.graph);
        fciOrient.doFinalOrientation(this.graph);
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - beginTime;
        if (this.verbose) {
            this.logger.log("graph", "Returning graph: " + this.graph);
        }
        return this.graph;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    private Graph getGraph() {
        return this.graph;
    }

    private void ruleR0(IndependenceTest test, int depth, SepsetMap sepsets) {
        if (this.verbose) {
            TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        }
        this.ambiguousTriples = new HashSet<Triple>();
        for (Node y : this.getGraph().getNodes()) {
            int[] combination;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(this.getGraph().getAdjacentNodes(y));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node x = (Node)adjacentNodes.get(combination[0]);
                Node z = (Node)adjacentNodes.get(combination[1]);
                if (this.getGraph().isAdjacentTo(x, z)) continue;
                TripleType type = this.getTripleType(x, y, z, test, depth);
                Set<Node> sepset = sepsets.get(x, z);
                if (type == TripleType.COLLIDER || sepset != null && !sepset.contains(y)) {
                    if (!FciOrient.isArrowheadAllowed(x, y, this.graph, this.knowledge) || !FciOrient.isArrowheadAllowed(z, y, this.graph, this.knowledge)) continue;
                    this.getGraph().setEndpoint(x, y, Endpoint.ARROW);
                    this.getGraph().setEndpoint(z, y, Endpoint.ARROW);
                    if (!this.verbose) continue;
                    TetradLogger.getInstance().log("tripleClassifications", "Collider: " + Triple.pathString(this.graph, x, y, z));
                    continue;
                }
                Triple triple = new Triple(x, y, z);
                this.ambiguousTriples.add(triple);
                this.getGraph().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                if (!this.verbose) continue;
                TetradLogger.getInstance().log("tripleClassifications", "AmbiguousTriples: " + Triple.pathString(this.graph, x, y, z));
            }
        }
        if (this.verbose) {
            TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
        }
    }

    private TripleType getTripleType(Node x, Node y, Node z, IndependenceTest test, int depth) {
        Set<Node> condSet;
        int[] choice;
        ChoiceGenerator cg;
        int d;
        boolean existsSepsetContainingY = false;
        boolean existsSepsetNotContainingY = false;
        HashSet<Node> __nodes = new HashSet<Node>(this.getGraph().getAdjacentNodes(x));
        __nodes.remove(z);
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                condSet = GraphUtils.asSet(choice, _nodes);
                if (!test.checkIndependence(x, z, condSet).isIndependent()) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        __nodes = new HashSet<Node>(this.getGraph().getAdjacentNodes(z));
        __nodes.remove(x);
        _nodes = new LinkedList<Node>(__nodes);
        _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                condSet = GraphUtils.asSet(choice, _nodes);
                if (!test.checkIndependence(x, z, condSet).isIndependent()) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        Set<Node> condSet2 = this.getSepsets().get(x, z);
        if (condSet2 != null) {
            if (condSet2.contains(y)) {
                existsSepsetContainingY = true;
            } else {
                existsSepsetNotContainingY = true;
            }
        }
        if (existsSepsetContainingY == existsSepsetNotContainingY) {
            return TripleType.AMBIGUOUS;
        }
        if (!existsSepsetNotContainingY) {
            return TripleType.NONCOLLIDER;
        }
        return TripleType.COLLIDER;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isPossibleMsepSearchDone() {
        return this.possibleMsepSearchDone;
    }

    public void setPossibleMsepSearchDone(boolean possibleMsepSearchDone) {
        this.possibleMsepSearchDone = possibleMsepSearchDone;
    }

    public int getMaxReachablePathLength() {
        return this.maxReachablePathLength;
    }

    public void setMaxReachablePathLength(int maxReachablePathLength) {
        this.maxReachablePathLength = maxReachablePathLength;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    private void fciOrientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        if (this.verbose) {
            this.logger.log("info", "Starting BK Orientation.");
        }
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), variables);
            to = GraphSearchUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            if (!this.verbose) continue;
            this.logger.log("knowledgeOrientation", LogUtilsSearch.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), variables);
            to = GraphSearchUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            if (this.verbose) {
                System.out.println("Rule T3: Orienting " + from + "-->" + to);
            }
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            if (!this.verbose) continue;
            this.logger.log("knowledgeOrientation", LogUtilsSearch.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        if (this.verbose) {
            this.logger.log("info", "Finishing BK Orientation.");
        }
    }

    private static enum TripleType {
        COLLIDER,
        NONCOLLIDER,
        AMBIGUOUS;

    }
}

