/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.utils.PcCommon;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.HashSet;
import java.util.Set;

public final class Cpc
implements IGraphSearch {
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Knowledge knowledge = new Knowledge();
    private Graph graph;
    private long elapsedTime;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private SepsetMap sepsets;
    private int depth = 1000;
    private boolean stable = true;
    private boolean meekPreventCycles = true;
    private PcCommon.ConflictRule conflictRule = PcCommon.ConflictRule.PRIORITIZE_EXISTING;
    private boolean verbose = false;
    private PcCommon.PcHeuristicType pcHeuristicType = PcCommon.PcHeuristicType.NONE;

    public Cpc(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    @Override
    public Graph search() {
        this.logger.log("info", "Starting CPC algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.ambiguousTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        Fas fas = new Fas(this.getIndependenceTest());
        long startTime = MillisecondTimes.timeMillis();
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        this.sepsets = fas.getSepsets();
        PcCommon search = new PcCommon(this.independenceTest);
        search.setDepth(this.depth);
        search.setConflictRule(this.conflictRule);
        search.setPcHeuristicType(this.pcHeuristicType);
        search.setMeekPreventCycles(this.meekPreventCycles);
        search.setKnowledge(this.knowledge);
        if (this.stable) {
            search.setFasType(PcCommon.FasType.STABLE);
        } else {
            search.setFasType(PcCommon.FasType.REGULAR);
        }
        search.setColliderDiscovery(PcCommon.ColliderDiscovery.CONSERVATIVE);
        search.setConflictRule(this.conflictRule);
        search.setVerbose(this.verbose);
        this.graph = search.search();
        this.sepsets = fas.getSepsets();
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - startTime;
        TetradLogger.getInstance().log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        TetradLogger.getInstance().log("info", "Finishing CPC algorithm.");
        this.colliderTriples = search.getColliderTriples();
        this.noncolliderTriples = search.getNoncolliderTriples();
        this.ambiguousTriples = search.getAmbiguousTriples();
        this.logTriples();
        TetradLogger.getInstance().flush();
        return this.graph;
    }

    public void meekPreventCycles(boolean meekPreventCycles) {
        this.meekPreventCycles = meekPreventCycles;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Depth must not be Integer.MAX_VALUE, due to a known bug.");
        }
        this.depth = depth;
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    public Set<Edge> getAdjacencies() {
        return new HashSet<Edge>(GraphUtils.undirectedGraph(this.graph).getEdges());
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    public void setConflictRule(PcCommon.ConflictRule conflictRule) {
        this.conflictRule = conflictRule;
    }

    public void setPcHeuristicType(PcCommon.PcHeuristicType pcHeuristicType) {
        this.pcHeuristicType = pcHeuristicType;
    }

    private void logTriples() {
        TetradLogger.getInstance().log("info", "\nCollider triples:");
        for (Triple triple : this.colliderTriples) {
            TetradLogger.getInstance().log("info", "Collider: " + triple);
        }
        TetradLogger.getInstance().log("info", "\nNoncollider triples:");
        for (Triple triple : this.noncolliderTriples) {
            TetradLogger.getInstance().log("info", "Noncollider: " + triple);
        }
        TetradLogger.getInstance().log("info", "\nAmbiguous triples (i.e. list of triples for which \nthere is ambiguous data about whether they are colliders or not):");
        for (Triple triple : this.getAmbiguousTriples()) {
            TetradLogger.getInstance().log("info", "Ambiguous: " + triple);
        }
    }
}

