/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.search.utils.PcCommon;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.search.utils.SepsetsSet;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.ForkJoinPoolInstance;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RecursiveTask;

public final class FciMax
implements IGraphSearch {
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private SepsetMap sepsets;
    private Knowledge knowledge = new Knowledge();
    private long elapsedTime;
    private PcCommon.PcHeuristicType pcHeuristicType = PcCommon.PcHeuristicType.NONE;
    private boolean stable = false;
    private boolean completeRuleSetUsed = true;
    private boolean doDiscriminatingPathRule = false;
    private boolean possibleMsepSearchDone = true;
    private int maxPathLength = -1;
    private int depth = -1;
    private boolean verbose = false;

    public FciMax(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    @Override
    public Graph search() {
        long start = MillisecondTimes.timeMillis();
        Fas fas = new Fas(this.getIndependenceTest());
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.depth);
        fas.setPcHeuristicType(this.pcHeuristicType);
        fas.setVerbose(this.verbose);
        fas.setStable(this.stable);
        fas.setPcHeuristicType(this.pcHeuristicType);
        Graph graph = fas.search();
        this.sepsets = fas.getSepsets();
        graph.reorientAllWith(Endpoint.CIRCLE);
        if (this.possibleMsepSearchDone) {
            new FciOrient(new SepsetsSet(this.sepsets, this.independenceTest)).ruleR0(graph);
            graph.paths().removeByPossibleMsep(this.independenceTest, this.sepsets);
            graph.reorientAllWith(Endpoint.CIRCLE);
        }
        FciOrient fciOrient = new FciOrient(new SepsetsSet(this.sepsets, this.independenceTest));
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setVerbose(this.verbose);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.fciOrientbk(this.knowledge, graph, graph.getNodes());
        this.addColliders(graph);
        fciOrient.doFinalOrientation(graph);
        long stop = MillisecondTimes.timeMillis();
        this.elapsedTime = stop - start;
        return graph;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public void setPossibleMsepSearchDone(boolean possibleMsepSearchDone) {
        this.possibleMsepSearchDone = possibleMsepSearchDone;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public void setPcHeuristicType(PcCommon.PcHeuristicType pcHeuristicType) {
        this.pcHeuristicType = pcHeuristicType;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    private void addColliders(Graph graph) {
        ConcurrentHashMap scores = new ConcurrentHashMap();
        List<Node> nodes = graph.getNodes();
        class Task
        extends RecursiveTask<Boolean> {
            final int from;
            final int to;
            final int chunk = 20;
            final List<Node> nodes;
            final Graph graph;
            final /* synthetic */ Map val$scores;
            final /* synthetic */ FciMax this$0;

            public Task(List<Node> nodes, Graph graph, int from, int to) {
                this.this$0 = this$0;
                this.val$scores = var6_6;
                this.nodes = nodes;
                this.graph = graph;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int i = this.from; i < this.to; ++i) {
                        this.this$0.doNode(this.graph, this.val$scores, this.nodes.get(i));
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    Task left = new Task(this.this$0, this.nodes, this.graph, this.from, mid, this.val$scores);
                    Task right = new Task(this.this$0, this.nodes, this.graph, mid, this.to, this.val$scores);
                    left.fork();
                    right.compute();
                    left.join();
                }
                return true;
            }
        }
        Task task = new Task(this, nodes, graph, 0, nodes.size(), scores);
        ForkJoinPoolInstance.getInstance().getPool().invoke(task);
        ArrayList tripleList = new ArrayList(scores.keySet());
        tripleList.sort((o1, o2) -> Double.compare((Double)scores.get(o2), (Double)scores.get(o1)));
        for (Triple triple : tripleList) {
            Node a = triple.getX();
            Node b = triple.getY();
            Node c = triple.getZ();
            graph.setEndpoint(a, b, Endpoint.ARROW);
            graph.setEndpoint(c, b, Endpoint.ARROW);
        }
    }

    private void doNode(Graph graph, Map<Triple, Double> scores, Node b) {
        int[] combination;
        ArrayList<Node> adjacentNodes = new ArrayList<Node>(graph.getAdjacentNodes(b));
        if (adjacentNodes.size() < 2) {
            return;
        }
        ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
        while ((combination = cg.next()) != null) {
            int[] comb3;
            int[] comb2;
            Node c;
            Node a = (Node)adjacentNodes.get(combination[0]);
            if (graph.isAdjacentTo(a, c = (Node)adjacentNodes.get(combination[1]))) continue;
            ArrayList<Node> adja = new ArrayList<Node>(graph.getAdjacentNodes(a));
            double score = Double.POSITIVE_INFINITY;
            Set<Node> S = null;
            SublistGenerator cg2 = new SublistGenerator(adja.size(), -1);
            while ((comb2 = cg2.next()) != null) {
                Set<Node> s = GraphUtils.asSet(comb2, adja);
                IndependenceResult result = this.independenceTest.checkIndependence(a, c, s);
                double _score = result.getScore();
                if (!(_score < score)) continue;
                score = _score;
                S = s;
            }
            ArrayList<Node> adjc = new ArrayList<Node>(graph.getAdjacentNodes(c));
            SublistGenerator cg3 = new SublistGenerator(adjc.size(), -1);
            while ((comb3 = cg3.next()) != null) {
                Set<Node> s = GraphUtils.asSet(comb3, adjc);
                IndependenceResult result = this.independenceTest.checkIndependence(c, a, s);
                double _score = result.getScore();
                if (!(_score < score)) continue;
                score = _score;
                S = s;
            }
            this.getSepsets().set(a, c, S);
            if (S == null || S.contains(b)) continue;
            scores.put(new Triple(a, b, c), score);
        }
    }
}

