/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.score.GraphScore;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.score.ScoredGraph;
import edu.cmu.tetrad.search.utils.Bes;
import edu.cmu.tetrad.search.utils.DagScorer;
import edu.cmu.tetrad.search.utils.MeekRules;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;

public final class Fges
implements IGraphSearch,
DagScorer {
    private final Set<Node> emptySet = new HashSet<Node>();
    private final int[] count = new int[1];
    private final int depth = 10000;
    private final TetradLogger logger = TetradLogger.getInstance();
    private final LinkedList<ScoredGraph> topGraphs = new LinkedList();
    private final SortedSet<Arrow> sortedArrows = new ConcurrentSkipListSet<Arrow>();
    private final Map<Edge, ArrowConfig> arrowsMap = new ConcurrentHashMap<Edge, ArrowConfig>();
    private boolean faithfulnessAssumed = false;
    private Knowledge knowledge = new Knowledge();
    private List<Node> variables;
    private Graph initialGraph;
    private Graph boundGraph = null;
    private long elapsedTime;
    private Score score;
    private boolean verbose = false;
    private boolean meekVerbose = false;
    private ConcurrentMap<Node, Integer> hashIndices;
    private Graph effectEdgesGraph;
    private PrintStream out = System.out;
    private Graph graph;
    private int arrowIndex = 0;
    private double modelScore;
    private Mode mode = Mode.heuristicSpeedup;
    private int maxDegree = -1;
    private boolean symmetricFirstStep = false;
    private boolean parallelized = false;

    public Fges(Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.setScore(score);
        this.graph = new EdgeListGraph(this.getVariables());
    }

    private static Node traverseSemiDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.TAIL) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && edge.getEndpoint2() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        return null;
    }

    @Override
    public Graph search() {
        long start = MillisecondTimes.timeMillis();
        this.topGraphs.clear();
        this.graph = new EdgeListGraph(this.getVariables());
        if (this.boundGraph != null) {
            this.boundGraph = GraphUtils.replaceNodes(this.boundGraph, this.getVariables());
        }
        if (this.initialGraph != null) {
            this.graph = new EdgeListGraph(this.initialGraph);
            this.graph = GraphUtils.replaceNodes(this.graph, this.getVariables());
        }
        this.addRequiredEdges(this.graph);
        this.initializeEffectEdges(this.getVariables());
        this.mode = Mode.heuristicSpeedup;
        this.fes();
        this.bes();
        this.mode = Mode.coverNoncolliders;
        this.fes();
        this.bes();
        if (!this.faithfulnessAssumed) {
            this.mode = Mode.allowUnfaithfulness;
            this.fes();
            this.bes();
        }
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - start;
        if (this.verbose) {
            this.logger.forceLogMessage("Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        }
        this.modelScore = this.scoreDag(GraphTransforms.dagFromCPDAG(this.graph, null), true);
        return this.graph;
    }

    public void setFaithfulnessAssumed(boolean faithfulnessAssumed) {
        this.faithfulnessAssumed = faithfulnessAssumed;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public double scoreDag(Graph dag) {
        return this.scoreDag(dag, false);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMeekVerbose(boolean meekVerbose) {
        this.meekVerbose = meekVerbose;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setBoundGraph(Graph boundGraph) {
        this.boundGraph = boundGraph == null ? null : GraphUtils.replaceNodes(boundGraph, this.getVariables());
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public void setMaxDegree(int maxDegree) {
        if (maxDegree < -1) {
            throw new IllegalArgumentException();
        }
        this.maxDegree = maxDegree;
    }

    public void setSymmetricFirstStep(boolean symmetricFirstStep) {
        this.symmetricFirstStep = symmetricFirstStep;
    }

    public double getModelScore() {
        return this.modelScore;
    }

    private void setScore(Score score) {
        this.score = score;
        this.variables = new ArrayList<Node>();
        for (Node node : score.getVariables()) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            this.variables.add(node);
        }
        this.buildIndexing(score.getVariables());
        this.maxDegree = this.score.getMaxDegree();
    }

    private int getChunkSize(int n) {
        int chunk = n / Runtime.getRuntime().availableProcessors();
        if (chunk < 100) {
            chunk = 100;
        }
        return chunk;
    }

    private void initializeEffectEdges(List<Node> nodes) {
        long start = MillisecondTimes.timeMillis();
        this.effectEdgesGraph = new EdgeListGraph(nodes);
        ArrayList<NodeTaskEmptyGraph> tasks = new ArrayList<NodeTaskEmptyGraph>();
        int chunkSize = this.getChunkSize(nodes.size());
        for (int i = 0; i < nodes.size() && !Thread.currentThread().isInterrupted(); i += chunkSize) {
            NodeTaskEmptyGraph task = new NodeTaskEmptyGraph(i, FastMath.min(nodes.size(), i + chunkSize), nodes, this.emptySet);
            if (!this.parallelized) {
                task.call();
                continue;
            }
            tasks.add(task);
        }
        if (this.parallelized) {
            ForkJoinPool.commonPool().invokeAll(tasks);
        }
        long stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            this.out.println("Elapsed initializeForwardEdgesFromEmptyGraph = " + (stop - start) + " ms");
        }
    }

    private void fes() {
        int maxDegree = this.maxDegree == -1 ? 1000 : this.maxDegree;
        this.reevaluateForward(new HashSet<Node>(this.variables));
        while (!this.sortedArrows.isEmpty()) {
            Node y;
            Arrow arrow = this.sortedArrows.first();
            this.sortedArrows.remove(arrow);
            Node x = arrow.getA();
            if (this.graph.isAdjacentTo(x, y = arrow.getB()) || this.graph.getDegree(x) > maxDegree - 1 || this.graph.getDegree(y) > maxDegree - 1 || !this.getNaYX(x, y).equals(arrow.getNaYX()) || !new HashSet<Node>(this.getTNeighbors(x, y)).equals(arrow.getTNeighbors()) || !new HashSet<Node>(this.graph.getParents(y)).equals(new HashSet<Node>(arrow.getParents())) || !this.validInsert(x, y, arrow.getHOrT(), this.getNaYX(x, y))) continue;
            this.insert(x, y, arrow.getHOrT(), arrow.getBump());
            Set<Node> process = this.revertToCPDAG();
            process.add(x);
            process.add(y);
            process.addAll(this.getCommonAdjacents(x, y));
            this.reevaluateForward(new HashSet<Node>(process));
        }
    }

    private void bes() {
        Bes bes = new Bes(this.score);
        bes.setDepth(10000);
        bes.setVerbose(this.verbose);
        bes.setKnowledge(this.knowledge);
        bes.bes(this.graph, this.variables);
    }

    private boolean existsKnowledge() {
        return !this.knowledge.isEmpty();
    }

    private void reevaluateForward(Set<Node> nodes) {
        class AdjTask
        implements Callable<Boolean> {
            private final List<Node> nodes;
            private final int from;
            private final int to;

            AdjTask(List<Node> nodes, int from, int to) {
                this.nodes = nodes;
                this.from = from;
                this.to = to;
            }

            @Override
            public Boolean call() {
                for (int _y = this.from; _y < this.to && !Thread.interrupted(); ++_y) {
                    List<Node> adj;
                    Node y = this.nodes.get(_y);
                    if (Fges.this.mode == Mode.heuristicSpeedup) {
                        adj = Fges.this.effectEdgesGraph.getAdjacentNodes(y);
                    } else if (Fges.this.mode == Mode.coverNoncolliders) {
                        HashSet<Node> g = new HashSet<Node>();
                        for (Node n : Fges.this.graph.getAdjacentNodes(y)) {
                            for (Node m : Fges.this.graph.getAdjacentNodes(n)) {
                                if (Fges.this.graph.isAdjacentTo(y, m) || Fges.this.graph.isDefCollider(m, n, y)) continue;
                                g.add(m);
                            }
                        }
                        adj = new ArrayList<Node>(g);
                    } else if (Fges.this.mode == Mode.allowUnfaithfulness) {
                        adj = new ArrayList<Node>(Fges.this.variables);
                    } else {
                        throw new IllegalStateException();
                    }
                    for (Node x : adj) {
                        if (Fges.this.boundGraph != null && !Fges.this.boundGraph.isAdjacentTo(x, y)) continue;
                        Fges.this.calculateArrowsForward(x, y);
                    }
                }
                return true;
            }
        }
        ArrayList<AdjTask> tasks = new ArrayList<AdjTask>();
        int chunkSize = this.getChunkSize(nodes.size());
        for (int i = 0; i < nodes.size() && !Thread.currentThread().isInterrupted(); i += chunkSize) {
            AdjTask task = new AdjTask(new ArrayList<Node>(nodes), i, FastMath.min(nodes.size(), i + chunkSize));
            if (!this.parallelized) {
                task.call();
                continue;
            }
            tasks.add(task);
        }
        if (this.parallelized) {
            ForkJoinPool.commonPool().invokeAll(tasks);
        }
    }

    private void calculateArrowsForward(final Node a, final Node b) {
        int[] choice;
        if (this.boundGraph != null && !this.boundGraph.isAdjacentTo(a, b)) {
            return;
        }
        if (a == b) {
            return;
        }
        if (this.graph.isAdjacentTo(a, b)) {
            return;
        }
        if (this.existsKnowledge() && this.getKnowledge().isForbidden(a.getName(), b.getName())) {
            return;
        }
        final Set<Node> naYX = this.getNaYX(a, b);
        List<Node> TNeighbors = this.getTNeighbors(a, b);
        final HashSet<Node> parents = new HashSet<Node>(this.graph.getParents(b));
        HashSet<Node> TNeighborsSet = new HashSet<Node>(TNeighbors);
        ArrowConfig config = new ArrowConfig(TNeighborsSet, naYX, parents);
        ArrowConfig storedConfig = this.arrowsMap.get(Edges.directedEdge(a, b));
        if (storedConfig != null && storedConfig.equals(config)) {
            return;
        }
        this.arrowsMap.put(Edges.directedEdge(a, b), new ArrowConfig(TNeighborsSet, naYX, parents));
        int _depth = FastMath.min(10000, TNeighbors.size());
        SublistGenerator gen = new SublistGenerator(TNeighbors.size(), _depth);
        Set<Node> maxT = null;
        double maxBump = Double.NEGATIVE_INFINITY;
        ArrayList<Set<Node>> TT = new ArrayList<Set<Node>>();
        while ((choice = gen.next()) != null) {
            Set<Node> _T = GraphUtils.asSet(choice, TNeighbors);
            TT.add(_T);
        }
        int chunkSize = this.getChunkSize(TT.size());
        class EvalTask
        implements Callable<EvalPair> {
            private final List<Set<Node>> Ts;
            private final ConcurrentMap<Node, Integer> hashIndices;
            private final int from;
            private final int to;
            private Set<Node> maxT = null;
            private double maxBump = Double.NEGATIVE_INFINITY;

            public EvalTask(List<Set<Node>> Ts, int from, int to, ConcurrentMap<Node, Integer> hashIndices) {
                this.Ts = Ts;
                this.hashIndices = hashIndices;
                this.from = from;
                this.to = to;
            }

            @Override
            public EvalPair call() {
                for (int k = this.from; k < this.to && !Thread.interrupted(); ++k) {
                    double _bump = this.insertEval(a, b, this.Ts.get(k), naYX, parents, this.hashIndices);
                    if (!(_bump > this.maxBump)) continue;
                    this.maxT = this.Ts.get(k);
                    this.maxBump = _bump;
                }
                EvalPair pair = new EvalPair();
                pair.T = this.maxT;
                pair.bump = this.maxBump;
                return pair;
            }
        }
        ArrayList<EvalTask> tasks = new ArrayList<EvalTask>();
        for (int i = 0; i < TT.size() && !Thread.currentThread().isInterrupted(); i += chunkSize) {
            EvalTask task = new EvalTask(TT, i, FastMath.min(TT.size(), i + chunkSize), this.hashIndices);
            if (!this.parallelized) {
                EvalPair pair = task.call();
                if (!(pair.bump > maxBump)) continue;
                maxT = pair.T;
                maxBump = pair.bump;
                continue;
            }
            tasks.add(task);
        }
        if (this.parallelized) {
            List futures = ForkJoinPool.commonPool().invokeAll(tasks);
            for (Future future : futures) {
                try {
                    EvalPair pair = (EvalPair)future.get();
                    if (!(pair.bump > maxBump)) continue;
                    maxT = pair.T;
                    maxBump = pair.bump;
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        if (maxBump > 0.0) {
            this.addArrowForward(a, b, maxT, TNeighborsSet, naYX, parents, maxBump);
        }
    }

    private void addArrowForward(Node a, Node b, Set<Node> hOrT, Set<Node> TNeighbors, Set<Node> naYX, Set<Node> parents, double bump) {
        Arrow arrow = new Arrow(bump, a, b, hOrT, TNeighbors, naYX, parents, this.arrowIndex++);
        this.sortedArrows.add(arrow);
    }

    private Set<Node> getCommonAdjacents(Node x, Node y) {
        HashSet<Node> adj = new HashSet<Node>(this.graph.getAdjacentNodes(x));
        adj.retainAll(this.graph.getAdjacentNodes(y));
        return adj;
    }

    private List<Node> getTNeighbors(Node x, Node y) {
        List<Edge> yEdges = this.graph.getEdges(y);
        ArrayList<Node> tNeighbors = new ArrayList<Node>();
        for (Edge edge : yEdges) {
            Node z;
            if (!Edges.isUndirectedEdge(edge) || this.graph.isAdjacentTo(z = edge.getDistalNode(y), x)) continue;
            tNeighbors.add(z);
        }
        return tNeighbors;
    }

    private double insertEval(Node x, Node y, Set<Node> T, Set<Node> naYX, Set<Node> parents, Map<Node, Integer> hashIndices) {
        HashSet<Node> set = new HashSet<Node>(naYX);
        set.addAll(T);
        set.addAll(parents);
        return this.scoreGraphChange(x, y, set, hashIndices);
    }

    private void insert(Node x, Node y, Set<Node> T, double bump) {
        this.graph.addDirectedEdge(x, y);
        int numEdges = this.graph.getNumEdges();
        if (numEdges % 1000 == 0) {
            this.out.println("Num edges added: " + numEdges);
        }
        if (this.verbose) {
            int cond = T.size() + this.getNaYX(x, y).size() + this.graph.getParents(y).size();
            String message = this.graph.getNumEdges() + ". INSERT " + this.graph.getEdge(x, y) + " " + T + " " + bump + " degree = " + GraphUtils.getDegree(this.graph) + " indegree = " + GraphUtils.getIndegree(this.graph) + " cond = " + cond;
            TetradLogger.getInstance().forceLogMessage(message);
        }
        for (Node _t : T) {
            this.graph.removeEdge(_t, y);
            this.graph.addDirectedEdge(_t, y);
            if (!this.verbose) continue;
            String message = "--- Directing " + this.graph.getEdge(_t, y);
            TetradLogger.getInstance().forceLogMessage(message);
        }
    }

    private boolean validInsert(Node x, Node y, Set<Node> T, Set<Node> naYX) {
        boolean violatesKnowledge = false;
        if (this.existsKnowledge()) {
            if (this.knowledge.isForbidden(x.getName(), y.getName())) {
                violatesKnowledge = true;
            }
            for (Node t : T) {
                if (!this.knowledge.isForbidden(t.getName(), y.getName())) continue;
                violatesKnowledge = true;
            }
        }
        HashSet<Node> union = new HashSet<Node>(T);
        union.addAll(naYX);
        return this.isClique(union) && this.semidirectedPathCondition(y, x, union) && !violatesKnowledge;
    }

    private void addRequiredEdges(Graph graph) {
        if (!this.existsKnowledge()) {
            return;
        }
        Iterator<KnowledgeEdge> it = this.getKnowledge().requiredEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            KnowledgeEdge next = it.next();
            Node nodeA = graph.getNode(next.getFrom());
            Node nodeB = graph.getNode(next.getTo());
            if (graph.paths().isAncestorOf(nodeB, nodeA)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeA, nodeB);
            if (!this.verbose) continue;
            TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeA, nodeB));
        }
        for (Edge edge : graph.getEdges()) {
            Node nodeB;
            Node nodeA;
            String B;
            if (Thread.currentThread().isInterrupted()) break;
            String A = edge.getNode1().getName();
            if (this.knowledge.isForbidden(A, B = edge.getNode2().getName())) {
                nodeA = edge.getNode1();
                if (graph.isAdjacentTo(nodeA, nodeB = edge.getNode2()) && !graph.isChildOf(nodeA, nodeB) && !graph.paths().isAncestorOf(nodeA, nodeB)) {
                    graph.removeEdges(nodeA, nodeB);
                    graph.addDirectedEdge(nodeB, nodeA);
                    if (this.verbose) {
                        TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                    }
                }
                if (graph.isChildOf(nodeA, nodeB) || !this.getKnowledge().isForbidden(nodeA.getName(), nodeB.getName()) || graph.paths().isAncestorOf(nodeA, nodeB)) continue;
                graph.removeEdges(nodeA, nodeB);
                graph.addDirectedEdge(nodeB, nodeA);
                if (!this.verbose) continue;
                TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                continue;
            }
            if (!this.knowledge.isForbidden(B, A)) continue;
            nodeA = edge.getNode2();
            if (graph.isAdjacentTo(nodeA, nodeB = edge.getNode1()) && !graph.isChildOf(nodeA, nodeB) && !graph.paths().isAncestorOf(nodeA, nodeB)) {
                graph.removeEdges(nodeA, nodeB);
                graph.addDirectedEdge(nodeB, nodeA);
                if (this.verbose) {
                    TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                }
            }
            if (graph.isChildOf(nodeA, nodeB) || !this.getKnowledge().isForbidden(nodeA.getName(), nodeB.getName()) || graph.paths().isAncestorOf(nodeA, nodeB)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeB, nodeA);
            if (!this.verbose) continue;
            TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
        }
    }

    private boolean invalidSetByKnowledge(Node y, Set<Node> subset) {
        for (Node node : subset) {
            if (!this.getKnowledge().isForbidden(node.getName(), y.getName())) continue;
            return true;
        }
        return false;
    }

    private Set<Node> getNaYX(Node x, Node y) {
        List<Node> adj = this.graph.getAdjacentNodes(y);
        HashSet<Node> nayx = new HashSet<Node>();
        for (Node z : adj) {
            Edge yz;
            if (z == x || !Edges.isUndirectedEdge(yz = this.graph.getEdge(y, z)) || !this.graph.isAdjacentTo(z, x)) continue;
            nayx.add(z);
        }
        return nayx;
    }

    private boolean isClique(Set<Node> nodes) {
        ArrayList<Node> _nodes = new ArrayList<Node>(nodes);
        for (int i = 0; i < _nodes.size(); ++i) {
            for (int j = i + 1; j < _nodes.size(); ++j) {
                if (this.graph.isAdjacentTo((Node)_nodes.get(i), (Node)_nodes.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean semidirectedPathCondition(Node from, Node to, Set<Node> cond) {
        if (from == to) {
            throw new IllegalArgumentException();
        }
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        Q.add(from);
        V.add(from);
        while (!Q.isEmpty()) {
            Node t = (Node)Q.remove();
            if (cond.contains(t)) continue;
            if (t == to) {
                return false;
            }
            for (Node u : this.graph.getAdjacentNodes(t)) {
                Edge edge = this.graph.getEdge(t, u);
                Node c = Fges.traverseSemiDirected(t, edge);
                if (c == null || V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
            }
        }
        return true;
    }

    private Set<Node> revertToCPDAG() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge(this.getKnowledge());
        rules.setMeekPreventCycles(true);
        rules.setVerbose(this.meekVerbose);
        return rules.orientImplied(this.graph);
    }

    private void buildIndexing(List<Node> nodes) {
        this.hashIndices = new ConcurrentHashMap<Node, Integer>();
        int i = -1;
        for (Node n : nodes) {
            this.hashIndices.put(n, ++i);
        }
    }

    private double scoreDag(Graph dag, boolean recordScores) {
        if (this.score instanceof GraphScore) {
            return 0.0;
        }
        dag = GraphUtils.replaceNodes(dag, this.getVariables());
        double _score = 0.0;
        for (Node node : this.getVariables()) {
            List<Node> x = dag.getParents(node);
            int[] parentIndices = new int[x.size()];
            int count = 0;
            for (Node parent : x) {
                parentIndices[count++] = (Integer)this.hashIndices.get(parent);
            }
            double nodeScore = this.score.localScore((int)((Integer)this.hashIndices.get(node)), parentIndices);
            if (recordScores) {
                node.addAttribute("Score", nodeScore);
            }
            _score += nodeScore;
        }
        if (recordScores) {
            this.graph.addAttribute("Score", _score);
        }
        return _score;
    }

    private double scoreGraphChange(Node x, Node y, Set<Node> parents, Map<Node, Integer> hashIndices) {
        int xIndex = hashIndices.get(x);
        int yIndex = hashIndices.get(y);
        if (x == y) {
            throw new IllegalArgumentException();
        }
        if (parents.contains(y)) {
            throw new IllegalArgumentException();
        }
        int[] parentIndices = new int[parents.size()];
        int count = 0;
        for (Node parent : parents) {
            parentIndices[count++] = hashIndices.get(parent);
        }
        return this.score.localScoreDiff(xIndex, yIndex, parentIndices);
    }

    private List<Node> getVariables() {
        return this.variables;
    }

    public void setParallelized(boolean parallelized) {
        this.parallelized = parallelized;
    }

    public void setInitialGraph(Graph initialGraph) {
        this.initialGraph = initialGraph;
    }

    private static enum Mode {
        allowUnfaithfulness,
        heuristicSpeedup,
        coverNoncolliders;

    }

    class NodeTaskEmptyGraph
    implements Callable<Boolean> {
        private final int from;
        private final int to;
        private final List<Node> nodes;
        private final Set<Node> emptySet;

        NodeTaskEmptyGraph(int from, int to, List<Node> nodes, Set<Node> emptySet) {
            this.from = from;
            this.to = to;
            this.nodes = nodes;
            this.emptySet = emptySet;
        }

        @Override
        public Boolean call() {
            for (int i = this.from; i < this.to && !Thread.interrupted(); ++i) {
                if ((i + 1) % 1000 == 0) {
                    int[] nArray = Fges.this.count;
                    nArray[0] = nArray[0] + 1000;
                    Fges.this.out.println("Initializing effect edges: " + Fges.this.count[0]);
                }
                Node y = this.nodes.get(i);
                for (int j = i + 1; j < this.nodes.size() && !Thread.currentThread().isInterrupted(); ++j) {
                    Node x = this.nodes.get(j);
                    if (Fges.this.existsKnowledge() && (Fges.this.getKnowledge().isForbidden(x.getName(), y.getName()) && Fges.this.getKnowledge().isForbidden(y.getName(), x.getName()) || Fges.this.invalidSetByKnowledge(y, this.emptySet)) || Fges.this.boundGraph != null && !Fges.this.boundGraph.isAdjacentTo(x, y)) continue;
                    int child = (Integer)Fges.this.hashIndices.get(y);
                    int parent = (Integer)Fges.this.hashIndices.get(x);
                    double bump = Fges.this.score.localScoreDiff(parent, child);
                    if (Fges.this.symmetricFirstStep) {
                        double bump2 = Fges.this.score.localScoreDiff(child, parent);
                        bump = FastMath.max(bump, bump2);
                    }
                    if (Fges.this.boundGraph != null && !Fges.this.boundGraph.isAdjacentTo(x, y) || !(bump > 0.0)) continue;
                    Fges.this.effectEdgesGraph.addEdge(Edges.undirectedEdge(x, y));
                    Fges.this.addArrowForward(x, y, this.emptySet, this.emptySet, this.emptySet, this.emptySet, bump);
                    Fges.this.addArrowForward(y, x, this.emptySet, this.emptySet, this.emptySet, this.emptySet, bump);
                }
            }
            return true;
        }
    }

    private static class Arrow
    implements Comparable<Arrow> {
        private final double bump;
        private final Node a;
        private final Node b;
        private final Set<Node> hOrT;
        private final Set<Node> naYX;
        private final Set<Node> parents;
        private final int index;
        private Set<Node> TNeighbors;

        Arrow(double bump, Node a, Node b, Set<Node> hOrT, Set<Node> capTorH, Set<Node> naYX, Set<Node> parents, int index) {
            this.bump = bump;
            this.a = a;
            this.b = b;
            this.setTNeighbors(capTorH);
            this.hOrT = hOrT;
            this.naYX = naYX;
            this.index = index;
            this.parents = parents;
        }

        public double getBump() {
            return this.bump;
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        Set<Node> getHOrT() {
            return this.hOrT;
        }

        Set<Node> getNaYX() {
            return this.naYX;
        }

        @Override
        public int compareTo(@NotNull Arrow arrow) {
            int compare = Double.compare(arrow.getBump(), this.getBump());
            if (compare == 0) {
                return Integer.compare(this.getIndex(), arrow.getIndex());
            }
            return compare;
        }

        public String toString() {
            return "Arrow<" + this.a + "->" + this.b + " bump = " + this.bump + " t/h = " + this.hOrT + " TNeighbors = " + this.getTNeighbors() + " parents = " + this.parents + " naYX = " + this.naYX + ">";
        }

        public int getIndex() {
            return this.index;
        }

        public Set<Node> getTNeighbors() {
            return this.TNeighbors;
        }

        public void setTNeighbors(Set<Node> TNeighbors) {
            this.TNeighbors = TNeighbors;
        }

        public Set<Node> getParents() {
            return this.parents;
        }
    }

    private static class ArrowConfig {
        private Set<Node> T;
        private Set<Node> nayx;
        private Set<Node> parents;

        public ArrowConfig(Set<Node> T, Set<Node> nayx, Set<Node> parents) {
            this.setT(T);
            this.setNayx(nayx);
            this.setParents(parents);
        }

        public void setT(Set<Node> t) {
            this.T = t;
        }

        public void setNayx(Set<Node> nayx) {
            this.nayx = nayx;
        }

        public void setParents(Set<Node> parents) {
            this.parents = parents;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrowConfig that = (ArrowConfig)o;
            return this.T.equals(that.T) && this.nayx.equals(that.nayx) && this.parents.equals(that.parents);
        }

        public int hashCode() {
            return Objects.hash(this.T, this.nayx, this.parents);
        }
    }

    private static class EvalPair {
        Set<Node> T;
        double bump;

        private EvalPair() {
        }
    }
}

