/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.search.utils.SepsetsGreedy;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.List;

public final class GFci
implements IGraphSearch {
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private final Score score;
    private Knowledge knowledge = new Knowledge();
    private boolean completeRuleSetUsed = true;
    private int maxPathLength = -1;
    private int maxDegree = -1;
    private boolean verbose;
    private PrintStream out = System.out;
    private boolean faithfulnessAssumed = true;
    private boolean doDiscriminatingPathRule = true;
    private boolean possibleMsepSearchDone = true;
    private int depth = -1;

    public GFci(IndependenceTest test, Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.score = score;
        this.independenceTest = test;
    }

    @Override
    public Graph search() {
        this.independenceTest.setVerbose(this.verbose);
        List<Node> nodes = this.getIndependenceTest().getVariables();
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        Fges fges = new Fges(this.score);
        fges.setKnowledge(this.getKnowledge());
        fges.setVerbose(this.verbose);
        fges.setFaithfulnessAssumed(this.faithfulnessAssumed);
        fges.setMaxDegree(this.maxDegree);
        fges.setOut(this.out);
        Graph graph = fges.search();
        Knowledge knowledge2 = new Knowledge(this.knowledge);
        EdgeListGraph referenceDag = new EdgeListGraph(graph);
        SepsetsGreedy sepsets = new SepsetsGreedy(graph, this.independenceTest, null, this.depth, this.knowledge);
        GraphUtils.gfciExtraEdgeRemovalStep(graph, referenceDag, nodes, sepsets);
        GraphUtils.gfciR0(graph, referenceDag, sepsets, this.knowledge);
        FciOrient fciOrient = new FciOrient(sepsets);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setVerbose(this.verbose);
        fciOrient.setKnowledge(knowledge2);
        fciOrient.doFinalOrientation(graph);
        return graph;
    }

    public void setMaxDegree(int maxDegree) {
        if (maxDegree < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + maxDegree);
        }
        this.maxDegree = maxDegree;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setFaithfulnessAssumed(boolean faithfulnessAssumed) {
        this.faithfulnessAssumed = faithfulnessAssumed;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    public void setPossibleMsepSearchDone(boolean possibleMsepSearchDone) {
        this.possibleMsepSearchDone = possibleMsepSearchDone;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

