/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.score.GraphScore;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.TeyssierScorer;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Grasp {
    private final List<Node> variables;
    private Score score;
    private IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private TeyssierScorer scorer;
    private long start;
    private boolean useScore = true;
    private boolean useRaskuttiUhler;
    private boolean ordered = false;
    private boolean verbose;
    private int uncoveredDepth = 1;
    private int nonSingularDepth = 1;
    private boolean useDataOrder = true;
    private int depth = 3;
    private int numStarts = 1;
    private boolean allowInternalRandomness = false;

    public Grasp(@NotNull Score score) {
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
        this.useScore = true;
    }

    public Grasp(@NotNull IndependenceTest test) {
        this.test = test;
        this.variables = new ArrayList<Node>(test.getVariables());
        this.useScore = false;
    }

    public Grasp(@NotNull IndependenceTest test, Score score) {
        this.test = test;
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
    }

    public List<Node> bestOrder(@NotNull List<Node> order) {
        long start = MillisecondTimes.timeMillis();
        order = new ArrayList<Node>(order);
        this.scorer = new TeyssierScorer(this.test, this.score);
        this.scorer.setUseRaskuttiUhler(this.useRaskuttiUhler);
        this.scorer.setKnowledge(this.knowledge);
        if (this.useRaskuttiUhler) {
            this.scorer.setUseScore(false);
            this.scorer.setUseRaskuttiUhler(true);
        } else {
            this.scorer.setUseScore(this.useScore && !(this.score instanceof GraphScore));
        }
        this.scorer.clearBookmarks();
        List<Node> bestPerm = null;
        double best = Double.NEGATIVE_INFINITY;
        this.scorer.score(order);
        for (int r = 0; r < this.numStarts && !Thread.interrupted(); ++r) {
            if (r == 0 && !this.useDataOrder || r > 0) {
                RandomUtil.shuffle(order);
            }
            this.start = MillisecondTimes.timeMillis();
            this.makeValidKnowledgeOrder(order);
            this.scorer.score(order);
            List<Node> perm = this.grasp(this.scorer);
            this.scorer.score(perm);
            if (!(this.scorer.score() > best)) continue;
            best = this.scorer.score();
            bestPerm = perm;
        }
        this.scorer.score(bestPerm);
        long stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage("Final order = " + this.scorer.getPi());
            TetradLogger.getInstance().forceLogMessage("Elapsed time = " + (double)(stop - start) / 1000.0 + " s");
        }
        return bestPerm;
    }

    public int getNumEdges() {
        return this.scorer.getNumEdges();
    }

    @NotNull
    public Graph getGraph(boolean cpDag) {
        if (this.scorer == null) {
            throw new IllegalArgumentException("Please run algorithm first.");
        }
        Graph graph = this.scorer.getGraph(cpDag);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        graph.addAttribute("score ", nf.format(this.scorer.score()));
        return graph;
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (this.test != null) {
            this.test.setVerbose(verbose);
        }
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth should be >= -1.");
        }
        this.depth = depth;
    }

    public void setUncoveredDepth(int uncoveredDepth) {
        if (uncoveredDepth < -1) {
            throw new IllegalArgumentException("Uncovered depth should be >= -1.");
        }
        this.uncoveredDepth = uncoveredDepth;
    }

    public void setNonSingularDepth(int nonSingularDepth) {
        if (nonSingularDepth < -1) {
            throw new IllegalArgumentException("Non-singular depth should be >= -1.");
        }
        this.nonSingularDepth = nonSingularDepth;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setUseRaskuttiUhler(boolean useRaskuttiUhler) {
        this.useRaskuttiUhler = useRaskuttiUhler;
        if (this.useRaskuttiUhler) {
            this.useScore = false;
        }
    }

    public void setAllowInternalRandomness(boolean allowInternalRandomness) {
        this.allowInternalRandomness = allowInternalRandomness;
    }

    private boolean violatesKnowledge(List<Node> order) {
        if (this.knowledge.isEmpty()) {
            return false;
        }
        for (int i = 0; i < order.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!this.knowledge.isRequired(order.get(i).getName(), order.get(j).getName())) continue;
                return true;
            }
        }
        return false;
    }

    private List<Node> grasp(@NotNull TeyssierScorer scorer) {
        scorer.clearBookmarks();
        ArrayList<int[]> depths = new ArrayList<int[]>();
        if (this.ordered && this.uncoveredDepth != 0 && this.nonSingularDepth != 0) {
            depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, 0, 0});
        }
        if (this.ordered && this.nonSingularDepth != 0) {
            depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, this.uncoveredDepth < 0 ? Integer.MAX_VALUE : this.uncoveredDepth, 0});
        }
        depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, this.uncoveredDepth < 0 ? Integer.MAX_VALUE : this.uncoveredDepth, this.nonSingularDepth < 0 ? Integer.MAX_VALUE : this.nonSingularDepth});
        double sNew = scorer.score();
        for (int[] depth : depths) {
            double sOld;
            do {
                sOld = sNew;
                this.graspDfs(scorer, sOld, depth, 1, new HashSet<Set<Node>>(), new HashSet<Set<Set<Node>>>());
            } while ((sNew = scorer.score()) > sOld);
        }
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage("# Edges = " + scorer.getNumEdges() + " Score = " + scorer.score() + " (GRaSP) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
        }
        return scorer.getPi();
    }

    private void makeValidKnowledgeOrder(List<Node> order) {
        int i;
        if (this.knowledge.isEmpty()) {
            return;
        }
        int index = 0;
        HashSet<String> tier = new HashSet<String>(this.knowledge.getVariablesNotInTiers());
        for (i = 0; i < order.size(); ++i) {
            if (!tier.contains(order.get(i).getName())) continue;
            Node x = order.remove(i);
            order.add(index++, x);
        }
        for (i = 0; i < this.knowledge.getNumTiers(); ++i) {
            tier = new HashSet<String>(this.knowledge.getTier(i));
            for (int j = 0; j < order.size(); ++j) {
                if (!tier.contains(order.get(j).getName())) continue;
                Node x = order.remove(j);
                order.add(index++, x);
            }
        }
        if (this.knowledge.isEmpty()) {
            return;
        }
        block3: for (i = 1; i < order.size(); ++i) {
            String a = order.get(i).getName();
            for (int j = 0; j < i; ++j) {
                String b = order.get(j).getName();
                if (!this.knowledge.isRequired(a, b)) continue;
                Node x = order.remove(i);
                order.add(j, x);
                continue block3;
            }
        }
    }

    private void graspDfs(@NotNull TeyssierScorer scorer, double sOld, int[] depth, int currentDepth, Set<Set<Node>> tucks, Set<Set<Set<Node>>> dfsHistory) {
        List<Node> vars = scorer.getPi();
        if (this.allowInternalRandomness) {
            Collections.shuffle(vars);
        }
        for (Node y : vars) {
            Set<Node> ancestors = scorer.getAncestors(y);
            ArrayList<Node> parents = new ArrayList<Node>(scorer.getParents(y));
            if (this.allowInternalRandomness) {
                Collections.shuffle(parents);
            }
            for (Node x : parents) {
                boolean covered = scorer.coveredEdge(x, y);
                boolean singular = true;
                HashSet<Node> tuck = new HashSet<Node>();
                tuck.add(x);
                tuck.add(y);
                if (covered && tucks.contains(tuck) || currentDepth > depth[1] && !covered) continue;
                int[] idcs = new int[]{scorer.index(x), scorer.index(y)};
                int i = idcs[0];
                scorer.bookmark(currentDepth);
                boolean first = true;
                ArrayList<Node> Z = new ArrayList<Node>(scorer.getOrderShallow().subList(i + 1, idcs[1]));
                Iterator zItr = Z.iterator();
                do {
                    if (first) {
                        scorer.moveTo(y, i);
                        first = false;
                        continue;
                    }
                    Node z = (Node)zItr.next();
                    if (!ancestors.contains(z)) continue;
                    if (scorer.getParents(z).contains(x)) {
                        singular = false;
                    }
                    scorer.moveTo(z, i++);
                } while (zItr.hasNext());
                if (currentDepth > depth[2] && !singular) {
                    scorer.goToBookmark(currentDepth);
                    continue;
                }
                if (this.violatesKnowledge(scorer.getPi())) {
                    scorer.goToBookmark(currentDepth);
                    continue;
                }
                double sNew = scorer.score();
                if (sNew > sOld) {
                    if (this.verbose) {
                        System.out.printf("Edges: %d \t|\t Score Improvement: %f \t|\t Tucks Performed: %s %s \n", scorer.getNumEdges(), sNew - sOld, tucks, tuck);
                    }
                    return;
                }
                if (sNew == sOld && currentDepth < depth[0]) {
                    tucks.add(tuck);
                    if (currentDepth > depth[1]) {
                        if (!dfsHistory.contains(tucks)) {
                            dfsHistory.add(new HashSet<Set<Node>>(tucks));
                            this.graspDfs(scorer, sOld, depth, currentDepth + 1, tucks, dfsHistory);
                        }
                    } else {
                        this.graspDfs(scorer, sOld, depth, currentDepth + 1, tucks, dfsHistory);
                    }
                    tucks.remove(tuck);
                }
                if (scorer.score() > sOld) {
                    return;
                }
                scorer.goToBookmark(currentDepth);
            }
        }
    }
}

