/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Grasp;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.search.utils.SepsetsGreedy;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.List;

public final class GraspFci
implements IGraphSearch {
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private final Score score;
    private Knowledge knowledge = new Knowledge();
    private boolean completeRuleSetUsed = true;
    private int maxPathLength = -1;
    private boolean verbose;
    private int numStarts = 1;
    private int depth = -1;
    private boolean useRaskuttiUhler = false;
    private boolean useDataOrder = true;
    private boolean useScore = true;
    private boolean doDiscriminatingPathRule = true;
    private boolean ordered = false;
    private int uncoveredDepth = 1;
    private int nonSingularDepth = 1;

    public GraspFci(IndependenceTest test, Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.score = score;
        this.independenceTest = test;
    }

    @Override
    public Graph search() {
        List<Node> nodes = this.independenceTest.getVariables();
        if (nodes == null) {
            throw new NullPointerException("Nodes from test were null.");
        }
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.independenceTest + ".");
        Grasp alg = new Grasp(this.independenceTest, this.score);
        alg.setOrdered(this.ordered);
        alg.setUseScore(this.useScore);
        alg.setUseRaskuttiUhler(this.useRaskuttiUhler);
        alg.setUseDataOrder(this.useDataOrder);
        int graspDepth = 3;
        alg.setDepth(graspDepth);
        alg.setUncoveredDepth(this.uncoveredDepth);
        alg.setNonSingularDepth(this.nonSingularDepth);
        alg.setNumStarts(this.numStarts);
        alg.setVerbose(this.verbose);
        List<Node> variables = this.score.getVariables();
        assert (variables != null);
        alg.bestOrder(variables);
        Graph graph = alg.getGraph(true);
        EdgeListGraph referenceDag = new EdgeListGraph(graph);
        SepsetsGreedy sepsets = new SepsetsGreedy(graph, this.independenceTest, null, this.depth, this.knowledge);
        GraphUtils.gfciExtraEdgeRemovalStep(graph, referenceDag, nodes, sepsets);
        GraphUtils.gfciR0(graph, referenceDag, sepsets, this.knowledge);
        FciOrient fciOrient = new FciOrient(sepsets);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setVerbose(this.verbose);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.doFinalOrientation(graph);
        GraphUtils.replaceNodes(graph, this.independenceTest.getVariables());
        return graph;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setUseRaskuttiUhler(boolean useRaskuttiUhler) {
        this.useRaskuttiUhler = useRaskuttiUhler;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    public void setSingularDepth(int uncoveredDepth) {
        if (uncoveredDepth < -1) {
            throw new IllegalArgumentException("Uncovered depth should be >= -1.");
        }
        this.uncoveredDepth = uncoveredDepth;
    }

    public void setNonSingularDepth(int nonSingularDepth) {
        if (nonSingularDepth < -1) {
            throw new IllegalArgumentException("Non-singular depth should be >= -1.");
        }
        this.nonSingularDepth = nonSingularDepth;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }
}

