/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IMbSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GrowShrink
implements IMbSearch {
    private final IndependenceTest independenceTest;
    private final List<Node> variables;

    public GrowShrink(IndependenceTest test) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.independenceTest = test;
        this.variables = test.getVariables();
    }

    @Override
    public Set<Node> findMb(Node target) {
        HashSet<Node> blanket = new HashSet<Node>();
        boolean changed = true;
        while (changed) {
            changed = false;
            LinkedList<Node> remaining = new LinkedList<Node>(this.variables);
            remaining.removeAll(blanket);
            remaining.remove(target);
            for (Node node : remaining) {
                if (this.independenceTest.checkIndependence(node, target, blanket).isIndependent()) continue;
                blanket.add(node);
                changed = true;
            }
        }
        changed = true;
        while (changed) {
            changed = false;
            for (Node node : new LinkedList<Node>(blanket)) {
                blanket.remove(node);
                if (this.independenceTest.checkIndependence(node, target, blanket).isIndependent()) {
                    changed = true;
                    continue;
                }
                blanket.add(node);
            }
        }
        return blanket;
    }

    @Override
    public String getAlgorithmName() {
        return "Grow Shrink";
    }

    @Override
    public int getNumIndependenceTests() {
        throw new UnsupportedOperationException("Independence tests are not counted in the algorithm.");
    }
}

