/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.search.IcaLingD;
import edu.cmu.tetrad.search.utils.PermutationMatrixPair;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.commons.math3.util.FastMath;

public class IcaLingam {
    private double bThreshold = 0.1;
    private boolean acyclicityGuaranteed = true;

    public Matrix fit(DataSet D) {
        Matrix W = IcaLingD.estimateW(D, 5000, 1.0E-6, 1.2);
        return this.fitW(W);
    }

    public Matrix fitW(Matrix W) {
        PermutationMatrixPair bestPair = IcaLingD.hungarianDiagonal(W);
        Matrix scaledBHat = IcaLingD.getScaledBHat(bestPair, FastMath.abs(this.bThreshold));
        if (this.acyclicityGuaranteed) {
            class Record {
                double coef;
                int i;
                int j;

                Record() {
                }
            }
            LinkedList<Record> coefs = new LinkedList<Record>();
            for (int i = 0; i < scaledBHat.getNumRows(); ++i) {
                for (int j = 0; j < scaledBHat.getNumColumns(); ++j) {
                    if (i == j || scaledBHat.get(i, j) == 0.0) continue;
                    Record record = new Record();
                    record.coef = scaledBHat.get(i, j);
                    record.i = i;
                    record.j = j;
                    coefs.add(record);
                }
            }
            coefs.sort(Comparator.comparingDouble(o -> FastMath.abs(o.coef)));
            Record coef = (Record)coefs.getFirst();
            while (!coefs.isEmpty()) {
                if (IcaLingD.isAcyclic(scaledBHat)) {
                    TetradLogger.getInstance().forceLogMessage("Effective threshold = " + coef.coef);
                    return scaledBHat;
                }
                coef = (Record)coefs.removeFirst();
                scaledBHat.set(coef.i, coef.j, 0.0);
            }
            TetradLogger.getInstance().forceLogMessage("Effective threshold = " + FastMath.abs(coef.coef));
        } else {
            TetradLogger.getInstance().forceLogMessage("Threshold = " + FastMath.abs(this.bThreshold));
        }
        return scaledBHat;
    }

    public void setBThreshold(double bThreshold) {
        if (bThreshold < 0.0) {
            throw new IllegalArgumentException("Expecting a non-negative number: " + bThreshold);
        }
        this.bThreshold = bThreshold;
    }

    public void setAcyclicityGuaranteed(boolean acyclicityGuaranteed) {
        this.acyclicityGuaranteed = acyclicityGuaranteed;
    }
}

