/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.ResolveSepsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.help.UnsupportedOperationException;
import org.jetbrains.annotations.NotNull;

public class IndTestIod
implements IndependenceTest {
    private final List<Node> nodeList;
    private final List<IndependenceTest> tests;
    private boolean verbose;

    public IndTestIod(List<IndependenceTest> tests) {
        for (IndependenceTest test : tests) {
            if (test == null) {
                throw new NullPointerException("Test is null");
            }
            if (!(test instanceof IndTestIod)) continue;
            throw new IllegalArgumentException("Cannot have IndTestIod as a test");
        }
        this.tests = tests;
        for (IndependenceTest test : tests) {
            if (!(test instanceof IndTestIod)) continue;
            throw new IllegalArgumentException("Cannot have IndTestIod as a test");
        }
        HashSet<String> nameSet = new HashSet<String>();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (IndependenceTest test : tests) {
            List<Node> vars = test.getVariables();
            for (Node v : vars) {
                if (nameSet.contains(v.getName())) continue;
                nodeList.add(v);
                nameSet.add(v.getName());
            }
        }
        Collections.sort(nodeList);
        this.nodeList = nodeList;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> z) {
        ArrayList<IndependenceTest> tests = new ArrayList<IndependenceTest>();
        for (IndependenceTest test : this.tests) {
            if (!this.containsAll(x, y, z, test)) continue;
            tests.add(test);
        }
        boolean independent = ResolveSepsets.isIndependentPooled(ResolveSepsets.Method.fisher, tests, x, y, z);
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, Double.NaN, Double.NaN);
    }

    @Override
    public List<Node> getVariables() {
        return new ArrayList<Node>(this.nodeList);
    }

    public boolean determines(List<Node> z, Node x) {
        return z.contains(x);
    }

    @Override
    public double getAlpha() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAlpha(double alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getVariable(String name) {
        for (Node variable : this.nodeList) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        throw new IllegalArgumentException("Variable not found: " + name);
    }

    public Node getVariable(Node node) {
        return this.getVariable(node.getName());
    }

    public Node getNode(Node variable) {
        for (Node node : this.nodeList) {
            if (!node.getName().equals(variable.getName())) continue;
            return node;
        }
        throw new IllegalArgumentException("Variable not found: " + variable);
    }

    @Override
    public String toString() {
        return "IOD independence test (pooled over datasets)";
    }

    @Override
    public DataSet getData() {
        throw new UnsupportedOperationException("No single dataset; this test pools over multiple datasets.");
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        for (IndependenceTest test : this.tests) {
            test.setVerbose(verbose);
        }
        this.verbose = verbose;
    }

    private boolean containsAll(@NotNull Node x, Node y, Set<Node> z, @NotNull IndependenceTest test) {
        if (test.getVariable(x.getName()) == null) {
            return false;
        }
        if (test.getVariable(y.getName()) == null) {
            return false;
        }
        for (Node _z : z) {
            if (test.getVariable(_z.getName()) != null) continue;
            return false;
        }
        return true;
    }
}

