/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.test.IndependenceResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public interface IndependenceTest {
    public IndependenceResult checkIndependence(Node var1, Node var2, Set<Node> var3);

    public List<Node> getVariables();

    public DataModel getData();

    public boolean isVerbose();

    public void setVerbose(boolean var1);

    public String toString();

    default public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException("Independence subset feature is not implemented.");
    }

    default public IndependenceResult checkIndependence(Node x, Node y, Node ... z) {
        Set<Node> zList = GraphUtils.asSet(z);
        return this.checkIndependence(x, y, zList);
    }

    default public int getSampleSize() {
        DataModel data = this.getData();
        if (data instanceof CovarianceMatrix) {
            return ((CovarianceMatrix)data).getSampleSize();
        }
        if (data instanceof DataSet) {
            return ((DataSet)data).getNumRows();
        }
        throw new UnsupportedOperationException("Expecting a dataset or a covariance matrix.");
    }

    default public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    default public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    default public boolean determines(Set<Node> z, Node y) {
        throw new UnsupportedOperationException("Determines method is not implemented.");
    }

    default public double getAlpha() {
        throw new UnsupportedOperationException("The getAlpha() method is not implemented for this test.");
    }

    default public void setAlpha(double alpha) {
        throw new UnsupportedOperationException("The setAlpha() method is not implemented for this test.");
    }

    default public ICovarianceMatrix getCov() {
        throw new UnsupportedOperationException("The getCov() method is not implemented for this test.");
    }

    default public List<DataSet> getDataSets() {
        throw new UnsupportedOperationException("The getDataSets() method is not implemented for this test.");
    }
}

