/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.AndersonDarlingTest;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.Regression;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.search.FastIca;
import edu.cmu.tetrad.search.utils.TsUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.commons.math3.util.FastMath;

public class Lofs {
    private final Graph cpdag;
    private final double SQRT = FastMath.sqrt(Math.PI * 2);
    Matrix _data;
    private List<DataSet> dataSets;
    private List<Matrix> matrices;
    private double alpha = 1.1;
    private List<Regression> regressions;
    private List<Node> variables;
    private boolean orientStrongerDirection;
    private boolean r2Orient2Cycles = true;
    private Score score = Score.andersonDarling;
    private double epsilon = 1.0;
    private Knowledge knowledge = new Knowledge();
    private Rule rule = Rule.R1;
    private double selfLoopStrength;
    private double[] col;

    public Lofs(Graph graph, List<DataSet> dataSets) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("graph must be specified.");
        }
        if (dataSets == null) {
            throw new IllegalArgumentException("Data set must be specified.");
        }
        this.cpdag = graph;
        this.variables = dataSets.get(0).getVariables();
        ArrayList<DataSet> dataSets2 = new ArrayList<DataSet>();
        for (DataSet set : dataSets) {
            BoxDataSet dataSet = new BoxDataSet(new DoubleDataBox(set.getDoubleData().toArray()), this.variables);
            dataSets2.add(dataSet);
        }
        this.dataSets = dataSets2;
    }

    public Graph orient() {
        Graph skeleton = GraphUtils.undirectedGraph(this.getCpdag());
        Graph graph = new EdgeListGraph(skeleton.getNodes());
        List<Node> nodes = skeleton.getNodes();
        if (this.rule == Rule.R1TimeLag) {
            this.ruleR1TimeLag(skeleton, graph);
        } else if (this.rule == Rule.R1) {
            this.ruleR1(skeleton, graph, nodes);
        } else if (this.rule == Rule.R2) {
            graph = GraphUtils.undirectedGraph(skeleton);
            this.ruleR2(graph, graph);
        } else if (this.rule == Rule.R3) {
            graph = GraphUtils.undirectedGraph(skeleton);
            this.ruleR3(graph);
        } else {
            if (this.rule == Rule.EB) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.entropyBased(graph);
            }
            if (this.rule == Rule.Tanh) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.tanhGraph(graph);
            }
            if (this.rule == Rule.Skew) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.skewGraph(graph, false);
            }
            if (this.rule == Rule.SkewE) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.skewGraph(graph, true);
            }
            if (this.rule == Rule.RSkew) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.robustSkewGraph(graph, false);
            }
            if (this.rule == Rule.RSkewE) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.robustSkewGraph(graph, true);
            }
            if (this.rule == Rule.IGCI) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.igci(graph);
            }
            if (this.rule == Rule.RC) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.resolveEdgeConditional(graph);
            }
            if (this.rule == Rule.Patel) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.patelTauOrientation(graph, Double.NaN);
            }
            if (this.rule == Rule.Patel25) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.patelTauOrientation(graph, 0.25);
            }
            if (this.rule == Rule.Patel50) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.patelTauOrientation(graph, 0.5);
            }
            if (this.rule == Rule.Patel75) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.patelTauOrientation(graph, 0.75);
            }
            if (this.rule == Rule.Patel90) {
                graph = GraphUtils.undirectedGraph(skeleton);
                return this.patelTauOrientation(graph, 0.9);
            }
            if (this.rule == Rule.FastICA) {
                FastIca fastIca = new FastIca(this.dataSets.get(0).getDoubleData(), this.dataSets.get(0).getNumColumns());
                FastIca.IcaResult result = fastIca.findComponents();
                System.out.println(result.getW());
                return new EdgeListGraph();
            }
        }
        return graph;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setScore(Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.score = score;
    }

    public void setSelfLoopStrength(double selfLoopStrength) {
        this.selfLoopStrength = selfLoopStrength;
    }

    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha is in range [0, 1]");
        }
        this.alpha = alpha;
    }

    public void setOrientStrongerDirection(boolean orientStrongerDirection) {
        this.orientStrongerDirection = orientStrongerDirection;
    }

    public void setR2Orient2Cycles(boolean r2Orient2Cycles) {
        this.r2Orient2Cycles = r2Orient2Cycles;
    }

    private List<Regression> getRegressions() {
        if (this.regressions == null) {
            ArrayList<Regression> regressions = new ArrayList<Regression>();
            this.variables = this.dataSets.get(0).getVariables();
            for (DataSet dataSet : this.dataSets) {
                regressions.add(new RegressionDataset(dataSet));
            }
            this.regressions = regressions;
        }
        return this.regressions;
    }

    private void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
        this.matrices = new ArrayList<Matrix>();
        for (DataSet dataSet : dataSets) {
            this.matrices.add(dataSet.getDoubleData());
        }
    }

    private void ruleR1TimeLag(Graph skeleton, Graph graph) {
        Node node1;
        ArrayList<DataSet> timeSeriesDataSets = new ArrayList<DataSet>();
        Knowledge knowledge = null;
        List<Node> dataNodes = null;
        for (DataSet dataSet : this.dataSets) {
            if (dataSet == null) {
                throw new IllegalArgumentException("Dataset is not supplied.");
            }
            DataSet lags = TsUtils.createLagData(dataSet, 1);
            if (dataSet.getName() != null) {
                lags.setName(dataSet.getName());
            }
            timeSeriesDataSets.add(lags);
            if (knowledge == null) {
                knowledge = lags.getKnowledge();
            }
            if (dataNodes != null) continue;
            dataNodes = lags.getVariables();
        }
        EdgeListGraph laggedSkeleton = new EdgeListGraph(dataNodes);
        for (Edge edge : skeleton.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            String node12 = edge.getNode1().getName();
            String node2 = edge.getNode2().getName();
            Node node10 = laggedSkeleton.getNode(node12 + ":0");
            Node node20 = laggedSkeleton.getNode(node2 + ":0");
            laggedSkeleton.addUndirectedEdge(node10, node20);
            Node node11 = laggedSkeleton.getNode(node12 + ":1");
            Node node21 = laggedSkeleton.getNode(node2 + ":1");
            laggedSkeleton.addUndirectedEdge(node11, node21);
        }
        for (Node node : skeleton.getNodes()) {
            if (Thread.currentThread().isInterrupted()) break;
            String _node = node.getName();
            Node node0 = laggedSkeleton.getNode(_node + ":0");
            node1 = laggedSkeleton.getNode(_node + ":1");
            laggedSkeleton.addUndirectedEdge(node0, node1);
        }
        Lofs lofs = new Lofs(laggedSkeleton, timeSeriesDataSets);
        lofs.setKnowledge(knowledge);
        lofs.setRule(Rule.R1);
        Graph _graph = lofs.orient();
        graph.removeEdges(new ArrayList<Edge>(graph.getEdges()));
        for (Edge edge : _graph.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            Endpoint end1 = edge.getEndpoint1();
            Endpoint end2 = edge.getEndpoint2();
            String index1 = node1.getName().split(":")[1];
            String index2 = node2.getName().split(":")[1];
            if ("1".equals(index1) || "1".equals(index2)) continue;
            String name1 = node1.getName().split(":")[0];
            String name2 = node2.getName().split(":")[0];
            Node _node1 = graph.getNode(name1);
            Node _node2 = graph.getNode(name2);
            Edge _edge = new Edge(_node1, _node2, end1, end2);
            graph.addEdge(_edge);
        }
    }

    private void ruleR1(Graph skeleton, Graph graph, List<Node> nodes) {
        List<DataSet> centeredData = DataTransforms.center(this.dataSets);
        this.setDataSets(centeredData);
        block0: for (Node node : nodes) {
            double score;
            int[] choice;
            if (Thread.currentThread().isInterrupted()) break;
            TreeMap<Double, String> scoreReports = new TreeMap<Double, String>();
            ArrayList<Node> adj = new ArrayList<Node>();
            for (Node _node : skeleton.getAdjacentNodes(node)) {
                if (this.knowledge.isForbidden(_node.getName(), node.getName())) continue;
                adj.add(_node);
            }
            SublistGenerator gen = new SublistGenerator(adj.size(), adj.size());
            double maxScore = Double.NEGATIVE_INFINITY;
            List<Node> parents = null;
            while ((choice = gen.next()) != null && !Thread.currentThread().isInterrupted()) {
                List<Node> _parents = GraphUtils.asList(choice, adj);
                score = this.score(node, _parents);
                scoreReports.put(-score, _parents.toString());
                if (!(score > maxScore)) continue;
                maxScore = score;
                parents = _parents;
            }
            Iterator<Object> iterator = scoreReports.keySet().iterator();
            while (iterator.hasNext()) {
                score = (Double)iterator.next();
                TetradLogger.getInstance().log("score", "For " + node + " parents = " + (String)scoreReports.get(score) + " score = " + -score);
            }
            TetradLogger.getInstance().log("score", "");
            if (parents == null) continue;
            for (Node _node : adj) {
                Edge parentEdge;
                if (Thread.currentThread().isInterrupted()) continue block0;
                if (!parents.contains(_node) || graph.containsEdge(parentEdge = Edges.directedEdge(_node, node))) continue;
                graph.addEdge(parentEdge);
            }
        }
        for (Edge edge : skeleton.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            if (graph.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
            graph.addUndirectedEdge(edge.getNode1(), edge.getNode2());
        }
    }

    private void ruleR2(Graph skeleton, Graph graph) {
        List<DataSet> standardized = DataTransforms.standardizeData(this.dataSets);
        this.setDataSets(standardized);
        Set<Edge> edgeList1 = skeleton.getEdges();
        for (Edge adj : edgeList1) {
            if (Thread.currentThread().isInterrupted()) break;
            Node x = adj.getNode1();
            Node y = adj.getNode2();
            if (!this.r2Orient2Cycles && this.isTwoCycle(graph, x, y) || !this.isTwoCycle(graph, x, y) && !this.isUndirected(graph, x, y)) continue;
            this.resolveOneEdgeMax2(graph, x, y, !this.orientStrongerDirection);
        }
    }

    private void resolveOneEdgeMax2(Graph graph, Node x, Node y, boolean strong) {
        int[] choicex;
        TetradLogger.getInstance().log("info", "\nEDGE " + x + " --- " + y);
        TreeMap<Double, String> scoreReports = new TreeMap<Double, String>();
        ArrayList<Node> neighborsx = new ArrayList<Node>();
        for (Node _node : graph.getAdjacentNodes(x)) {
            if (Thread.currentThread().isInterrupted()) break;
            if (this.knowledge.isForbidden(_node.getName(), x.getName())) continue;
            neighborsx.add(_node);
        }
        double max = Double.NEGATIVE_INFINITY;
        boolean left = false;
        boolean right = false;
        SublistGenerator genx = new SublistGenerator(neighborsx.size(), neighborsx.size());
        while ((choicex = genx.next()) != null && !Thread.currentThread().isInterrupted()) {
            int[] choicey;
            double p2;
            List<Node> condxMinus = GraphUtils.asList(choicex, neighborsx);
            if (condxMinus.contains(y)) continue;
            ArrayList<Node> condxPlus = new ArrayList<Node>(condxMinus);
            condxPlus.add(y);
            double xPlus = this.score(x, condxPlus);
            double xMinus = this.score(x, condxMinus);
            double p = this.pValue(x, condxPlus);
            if (p > this.alpha || (p2 = this.pValue(x, condxMinus)) > this.alpha) continue;
            ArrayList<Node> neighborsy = new ArrayList<Node>();
            for (Node _node : graph.getAdjacentNodes(y)) {
                if (Thread.currentThread().isInterrupted()) break;
                if (this.knowledge.isForbidden(_node.getName(), y.getName())) continue;
                neighborsy.add(_node);
            }
            SublistGenerator geny = new SublistGenerator(neighborsy.size(), neighborsy.size());
            while ((choicey = geny.next()) != null && !Thread.currentThread().isInterrupted()) {
                String s;
                double score;
                List<Node> condyMinus = GraphUtils.asList(choicey, neighborsy);
                if (condyMinus.contains(x)) continue;
                ArrayList<Node> condyPlus = new ArrayList<Node>(condyMinus);
                condyPlus.add(x);
                double yPlus = this.score(y, condyPlus);
                double yMinus = this.score(y, condyMinus);
                boolean forbiddenLeft = this.knowledge.isForbidden(y.getName(), x.getName());
                boolean forbiddenRight = this.knowledge.isForbidden(x.getName(), y.getName());
                double delta = 0.0;
                if (strong) {
                    if (yPlus <= xPlus + 0.0 && xMinus <= yMinus + 0.0) {
                        score = this.combinedScore(xPlus, yMinus);
                        if (yPlus <= yMinus + 0.0 && xMinus <= xPlus + 0.0 || forbiddenRight) {
                            s = "\nStrong " + y + "->" + x + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                            scoreReports.put(-score, s);
                            if (!(score > max)) continue;
                            max = score;
                            left = true;
                            right = false;
                            continue;
                        }
                        s = "\nNo directed edge " + x + "--" + y + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                        scoreReports.put(-score, s);
                        continue;
                    }
                    if (xPlus <= yPlus + 0.0 && yMinus <= xMinus + 0.0 || forbiddenLeft) {
                        score = this.combinedScore(yPlus, xMinus);
                        if (yMinus <= yPlus + 0.0 && xPlus <= xMinus + 0.0) {
                            s = "\nStrong " + x + "->" + y + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                            scoreReports.put(-score, s);
                            if (!(score > max)) continue;
                            max = score;
                            left = false;
                            right = true;
                            continue;
                        }
                        s = "\nNo directed edge " + x + "--" + y + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                        scoreReports.put(-score, s);
                        continue;
                    }
                    if (yPlus <= xPlus + 0.0 && yMinus <= xMinus + 0.0) {
                        score = this.combinedScore(yPlus, xMinus);
                        s = "\nNo directed edge " + x + "--" + y + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                        scoreReports.put(-score, s);
                        continue;
                    }
                    if (!(xPlus <= yPlus + 0.0) || !(xMinus <= yMinus + 0.0)) continue;
                    score = this.combinedScore(yPlus, xMinus);
                    s = "\nNo directed edge " + x + "--" + y + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                    scoreReports.put(-score, s);
                    continue;
                }
                if (yPlus <= xPlus + 0.0 && xMinus <= yMinus + 0.0 || forbiddenRight) {
                    score = this.combinedScore(xPlus, yMinus);
                    s = "\nWeak " + y + "->" + x + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                    scoreReports.put(-score, s);
                    if (!(score > max)) continue;
                    max = score;
                    left = true;
                    right = false;
                    continue;
                }
                if (xPlus <= yPlus + 0.0 && yMinus <= xMinus + 0.0 || forbiddenLeft) {
                    score = this.combinedScore(yPlus, xMinus);
                    s = "\nWeak " + x + "->" + y + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                    scoreReports.put(-score, s);
                    if (!(score > max)) continue;
                    max = score;
                    left = false;
                    right = true;
                    continue;
                }
                if (yPlus <= xPlus + 0.0 && yMinus <= xMinus + 0.0) {
                    score = this.combinedScore(yPlus, xMinus);
                    s = "\nNo directed edge " + x + "--" + y + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                    scoreReports.put(-score, s);
                    continue;
                }
                if (!(xPlus <= yPlus + 0.0) || !(xMinus <= yMinus + 0.0)) continue;
                score = this.combinedScore(yPlus, xMinus);
                s = "\nNo directed edge " + x + "--" + y + " " + score + "\n   Parents(" + x + ") = " + condxMinus + "\n   Parents(" + y + ") = " + condyMinus;
                scoreReports.put(-score, s);
            }
        }
        Iterator iterator = scoreReports.keySet().iterator();
        while (iterator.hasNext()) {
            double score = (Double)iterator.next();
            TetradLogger.getInstance().log("info", (String)scoreReports.get(score));
        }
        graph.removeEdges(x, y);
        if (left) {
            graph.addDirectedEdge(y, x);
        }
        if (right) {
            graph.addDirectedEdge(x, y);
        }
        if (!graph.isAdjacentTo(x, y)) {
            graph.addUndirectedEdge(x, y);
        }
    }

    private void ruleR3(Graph graph) {
        List<DataSet> standardized = DataTransforms.standardizeData(this.dataSets);
        this.setDataSets(standardized);
        Set<Edge> edgeList1 = graph.getEdges();
        for (Edge adj : edgeList1) {
            if (Thread.currentThread().isInterrupted()) break;
            Node x = adj.getNode1();
            Node y = adj.getNode2();
            this.resolveOneEdgeMaxR3(graph, x, y);
        }
    }

    private void resolveOneEdgeMaxR3(Graph graph, Node x, Node y) {
        String xname = x.getName();
        String yname = y.getName();
        if (this.knowledge.isForbidden(yname, xname) || this.knowledge.isRequired(xname, yname)) {
            graph.removeEdge(x, y);
            graph.addDirectedEdge(x, y);
            return;
        }
        if (this.knowledge.isForbidden(xname, yname) || this.knowledge.isRequired(yname, xname)) {
            graph.removeEdge(y, x);
            graph.addDirectedEdge(y, x);
            return;
        }
        List<Node> condxMinus = Collections.emptyList();
        List<Node> condxPlus = Collections.singletonList(y);
        List<Node> condyMinus = Collections.emptyList();
        List<Node> condyPlus = Collections.singletonList(x);
        double xPlus = this.score(x, condxPlus);
        double xMinus = this.score(x, condxMinus);
        double yPlus = this.score(y, condyPlus);
        double yMinus = this.score(y, condyMinus);
        double deltaX = xPlus - xMinus;
        double deltaY = yPlus - yMinus;
        graph.removeEdges(x, y);
        if (deltaY > deltaX) {
            graph.addDirectedEdge(x, y);
        } else {
            graph.addDirectedEdge(y, x);
        }
    }

    public double scoreRow(int rowIndex, Matrix data, List<List<Integer>> rows, List<List<Double>> parameters) {
        if (this.col == null) {
            this.col = new double[data.getNumRows()];
        }
        List<Integer> cols = rows.get(rowIndex);
        for (int i = 0; i < data.getNumRows() && !Thread.currentThread().isInterrupted(); ++i) {
            double d = 0.0;
            for (int j = 0; j < cols.size() && !Thread.currentThread().isInterrupted(); ++j) {
                int _j = cols.get(j);
                double coef = parameters.get(rowIndex).get(j);
                double value = data.get(i, _j);
                d += coef * value;
            }
            this.col[i] = d += (1.0 - this.selfLoopStrength) * data.get(i, rowIndex);
        }
        return this.score(this.col);
    }

    private Graph entropyBased(Graph graph) {
        DataSet dataSet = DataTransforms.concatenate(this.dataSets);
        dataSet = DataTransforms.standardizeData(dataSet);
        EdgeListGraph _graph = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            Node _x = dataSet.getVariable(x.getName());
            Node _y = dataSet.getVariable(y.getName());
            List<double[]> ret = this.extractData(dataSet, _x, _y);
            double[] xData = ret.get(0);
            double[] yData = ret.get(1);
            double[] d = new double[xData.length];
            double[] e = new double[xData.length];
            double cov = StatUtils.covariance(xData, yData);
            for (int i = 0; i < xData.length; ++i) {
                d[i] = yData[i] - cov * xData[i];
                e[i] = xData[i] - cov * yData[i];
            }
            double R = -StatUtils.maxEntApprox(xData) - StatUtils.maxEntApprox(d) + StatUtils.maxEntApprox(yData) + StatUtils.maxEntApprox(e);
            if (R > 0.0) {
                _graph.addDirectedEdge(x, y);
                continue;
            }
            _graph.addDirectedEdge(y, x);
        }
        return _graph;
    }

    private Graph tanhGraph(Graph graph) {
        DataSet dataSet = DataTransforms.concatenate(this.dataSets);
        graph = GraphUtils.replaceNodes(graph, dataSet.getVariables());
        dataSet = DataTransforms.standardizeData(dataSet);
        double[][] data = dataSet.getDoubleData().transpose().toArray();
        EdgeListGraph _graph = new EdgeListGraph(graph.getNodes());
        List<Node> nodes = dataSet.getVariables();
        HashMap<Node, Integer> nodesHash = new HashMap<Node, Integer>();
        for (int i = 0; i < nodes.size() && !Thread.currentThread().isInterrupted(); ++i) {
            nodesHash.put(nodes.get(i), i);
        }
        for (Edge edge : graph.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            double sumX = 0.0;
            int countX = 0;
            double[] xData = data[(Integer)nodesHash.get(edge.getNode1())];
            double[] yData = data[(Integer)nodesHash.get(edge.getNode2())];
            for (int i = 0; i < xData.length && !Thread.currentThread().isInterrupted(); ++i) {
                double x0 = xData[i];
                double y0 = yData[i];
                double termX = x0 * FastMath.tanh(y0) - FastMath.tanh(x0) * y0;
                sumX += termX;
                ++countX;
            }
            double R = sumX / (double)countX;
            double rhoX = this.regressionCoef(xData, yData);
            if ((R *= rhoX) > 0.0) {
                _graph.addDirectedEdge(x, y);
                continue;
            }
            _graph.addDirectedEdge(y, x);
        }
        return _graph;
    }

    private Graph skewGraph(Graph graph, boolean empirical) {
        DataSet dataSet = DataTransforms.concatenate(this.dataSets);
        graph = GraphUtils.replaceNodes(graph, dataSet.getVariables());
        dataSet = DataTransforms.standardizeData(dataSet);
        double[][] data = dataSet.getDoubleData().transpose().toArray();
        EdgeListGraph _graph = new EdgeListGraph(graph.getNodes());
        List<Node> nodes = dataSet.getVariables();
        HashMap<Node, Integer> nodesHash = new HashMap<Node, Integer>();
        for (int i = 0; i < nodes.size(); ++i) {
            nodesHash.put(nodes.get(i), i);
        }
        for (Edge edge : graph.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            double sumX = 0.0;
            int countX = 0;
            int _i = (Integer)nodesHash.get(edge.getNode1());
            int _j = (Integer)nodesHash.get(edge.getNode2());
            double[] xData = data[_i];
            double[] yData = data[_j];
            if (empirical) {
                xData = this.correctSkewnesses(xData);
                yData = this.correctSkewnesses(yData);
            }
            for (int i = 0; i < xData.length && !Thread.currentThread().isInterrupted(); ++i) {
                double x0 = xData[i];
                double y0 = yData[i];
                double termX = x0 * x0 * y0 - x0 * y0 * y0;
                sumX += termX;
                ++countX;
            }
            double R = sumX / (double)countX;
            double rhoX = this.regressionCoef(xData, yData);
            if ((R *= rhoX) > 0.0) {
                _graph.addDirectedEdge(x, y);
                continue;
            }
            _graph.addDirectedEdge(y, x);
        }
        return _graph;
    }

    private Graph robustSkewGraph(Graph graph, boolean empirical) {
        ArrayList<DataSet> _dataSets = new ArrayList<DataSet>(this.dataSets);
        DataSet dataSet = DataTransforms.concatenate(_dataSets);
        graph = GraphUtils.replaceNodes(graph, dataSet.getVariables());
        dataSet = DataTransforms.standardizeData(dataSet);
        double[][] data = dataSet.getDoubleData().transpose().toArray();
        List<Node> nodes = dataSet.getVariables();
        HashMap<Node, Integer> nodesHash = new HashMap<Node, Integer>();
        for (int i = 0; i < nodes.size(); ++i) {
            nodesHash.put(nodes.get(i), i);
        }
        for (Edge edge : graph.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            double[] xData = data[(Integer)nodesHash.get(edge.getNode1())];
            double[] yData = data[(Integer)nodesHash.get(edge.getNode2())];
            if (empirical) {
                xData = this.correctSkewnesses(xData);
                yData = this.correctSkewnesses(yData);
            }
            double[] xx = new double[xData.length];
            double[] yy = new double[yData.length];
            for (int i = 0; i < xData.length && !Thread.currentThread().isInterrupted(); ++i) {
                double xi = xData[i];
                double yi = yData[i];
                double s1 = this.g(xi) * yi;
                double s2 = xi * this.g(yi);
                xx[i] = s1;
                yy[i] = s2;
            }
            double mxx = StatUtils.mean(xx);
            double myy = StatUtils.mean(yy);
            graph.removeEdge(edge);
            if (mxx > myy) {
                graph.addDirectedEdge(x, y);
                continue;
            }
            if (myy > mxx) {
                graph.addDirectedEdge(y, x);
                continue;
            }
            graph.addUndirectedEdge(x, y);
        }
        return graph;
    }

    private double g(double x) {
        return FastMath.log(FastMath.cosh(FastMath.max(x, 0.0)));
    }

    private Graph patelTauOrientation(Graph graph, double cutoff) {
        List<DataSet> centered = DataTransforms.center(this.dataSets);
        DataSet concat = DataTransforms.concatenate(centered);
        DataSet dataSet = DataTransforms.standardizeData(concat);
        EdgeListGraph _graph = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            double[] yData;
            Node _y;
            if (Thread.currentThread().isInterrupted()) break;
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            Node _x = dataSet.getVariable(x.getName());
            List<double[]> ret = this.prepareData(dataSet, _x, _y = dataSet.getVariable(y.getName()));
            double[] xData = ret.get(0);
            double R = this.patelTau(xData, yData = ret.get(1), cutoff);
            if (R > 0.0) {
                _graph.addDirectedEdge(x, y);
                continue;
            }
            _graph.addDirectedEdge(y, x);
        }
        System.out.println(_graph);
        return _graph;
    }

    private double patelTau(double[] d1in, double[] d2in, double cutoff) {
        double theta3;
        int i;
        int i2;
        double grotMIN = this.percentile(d1in, 10.0);
        double grotMAX = this.percentile(d1in, 90.0);
        double XT = 0.25;
        double[] d1b = new double[d1in.length];
        for (i2 = 0; i2 < d1b.length; ++i2) {
            double y3;
            double y1 = (d1in[i2] - grotMIN) / (grotMAX - grotMIN);
            double y2 = FastMath.min(y1, 1.0);
            d1b[i2] = y3 = FastMath.max(y2, 0.0);
        }
        if (!Double.isNaN(cutoff)) {
            for (i2 = 0; i2 < d1b.length; ++i2) {
                d1b[i2] = d1b[i2] > cutoff ? 1.0 : 0.0;
            }
        }
        grotMIN = this.percentile(d2in, 10.0);
        grotMAX = this.percentile(d2in, 90.0);
        double[] d2b = new double[d2in.length];
        for (i = 0; i < d2b.length; ++i) {
            double y3;
            double y1 = (d2in[i] - grotMIN) / (grotMAX - grotMIN);
            double y2 = FastMath.min(y1, 1.0);
            d2b[i] = y3 = FastMath.max(y2, 0.0);
        }
        if (!Double.isNaN(cutoff)) {
            for (i = 0; i < d2b.length; ++i) {
                d2b[i] = d2b[i] > cutoff ? 1.0 : 0.0;
            }
        }
        double theta1 = this.dotProduct(d1b, d2b) / 0.25;
        double theta2 = this.dotProduct(d1b, this.minus(d2b)) / 0.25;
        double tau_12 = theta2 > (theta3 = this.dotProduct(d2b, this.minus(d1b)) / 0.25) ? 1.0 - (theta1 + theta3) / (theta1 + theta2) : (theta1 + theta2) / (theta1 + theta3) - 1.0;
        return -tau_12;
    }

    private double dotProduct(double[] x, double[] y) {
        double p = 0.0;
        for (int i = 0; i < x.length; ++i) {
            p += x[i] * y[i];
        }
        return p;
    }

    private double[] minus(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = 1.0 - x[i];
        }
        return y;
    }

    private double percentile(double[] x, double percent) {
        double[] _x = Arrays.copyOf(x, x.length);
        Arrays.sort(_x);
        return _x[(int)((double)x.length * (percent / 100.0))];
    }

    private List<double[]> extractData(DataSet data, Node _x, Node _y) {
        int i;
        int xIndex = data.getColumn(_x);
        int yIndex = data.getColumn(_y);
        double[][] _data = data.getDoubleData().transpose().toArray();
        double[] xData = _data[xIndex];
        double[] yData = _data[yIndex];
        ArrayList<Double> xValues = new ArrayList<Double>();
        ArrayList<Double> yValues = new ArrayList<Double>();
        for (i = 0; i < data.getNumRows(); ++i) {
            if (Double.isNaN(xData[i]) || Double.isNaN(yData[i])) continue;
            xValues.add(xData[i]);
            yValues.add(yData[i]);
        }
        xData = new double[xValues.size()];
        yData = new double[yValues.size()];
        for (i = 0; i < xValues.size(); ++i) {
            xData[i] = (Double)xValues.get(i);
            yData[i] = (Double)yValues.get(i);
        }
        ArrayList<double[]> ret = new ArrayList<double[]>();
        ret.add(xData);
        ret.add(yData);
        return ret;
    }

    private double[] correctSkewnesses(double[] data) {
        double skewness = StatUtils.skewness(data);
        double[] data2 = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            data2[i] = data[i] * FastMath.signum(skewness);
        }
        return data2;
    }

    private List<double[]> prepareData(DataSet concatData, Node _x, Node _y) {
        int i;
        int xIndex = concatData.getColumn(_x);
        int yIndex = concatData.getColumn(_y);
        double[] xData = concatData.getDoubleData().getColumn(xIndex).toArray();
        double[] yData = concatData.getDoubleData().getColumn(yIndex).toArray();
        ArrayList<Double> xValues = new ArrayList<Double>();
        ArrayList<Double> yValues = new ArrayList<Double>();
        for (i = 0; i < concatData.getNumRows(); ++i) {
            if (Double.isNaN(xData[i]) || Double.isNaN(yData[i])) continue;
            xValues.add(xData[i]);
            yValues.add(yData[i]);
        }
        xData = new double[xValues.size()];
        yData = new double[yValues.size()];
        for (i = 0; i < xValues.size(); ++i) {
            xData[i] = (Double)xValues.get(i);
            yData[i] = (Double)yValues.get(i);
        }
        ArrayList<double[]> ret = new ArrayList<double[]>();
        ret.add(xData);
        ret.add(yData);
        return ret;
    }

    private double regressionCoef(double[] xValues, double[] yValues) {
        RegressionResult result;
        ArrayList<Node> v = new ArrayList<Node>();
        v.add(new GraphNode("x"));
        v.add(new GraphNode("y"));
        Matrix bothData = new Matrix(xValues.length, 2);
        for (int i = 0; i < xValues.length; ++i) {
            bothData.set(i, 0, xValues[i]);
            bothData.set(i, 1, yValues[i]);
        }
        RegressionDataset regression2 = new RegressionDataset(bothData, v);
        try {
            result = regression2.regress((Node)v.get(0), (Node)v.get(1));
        }
        catch (Exception e) {
            return Double.NaN;
        }
        return result.getCoef()[1];
    }

    private boolean isTwoCycle(Graph graph, Node x, Node y) {
        List<Edge> edges = graph.getEdges(x, y);
        return edges.size() == 2;
    }

    private boolean isUndirected(Graph graph, Node x, Node y) {
        List<Edge> edges = graph.getEdges(x, y);
        if (edges.size() == 1) {
            Edge edge = graph.getEdge(x, y);
            return Edges.isUndirectedEdge(edge);
        }
        return false;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public double getPValue(double fisherZ) {
        return 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, FastMath.abs(fisherZ)));
    }

    private Graph igci(Graph graph) {
        if (this.dataSets.size() > 1) {
            throw new IllegalArgumentException("Expecting exactly one data set for IGCI.");
        }
        DataSet dataSet = this.dataSets.get(0);
        Matrix matrix = dataSet.getDoubleData();
        EdgeListGraph _graph = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            Node _x = dataSet.getVariable(x.getName());
            Node _y = dataSet.getVariable(y.getName());
            int xIndex = dataSet.getVariables().indexOf(_x);
            int yIndex = dataSet.getVariables().indexOf(_y);
            double[] xCol = matrix.getColumn(xIndex).toArray();
            double[] yCol = matrix.getColumn(yIndex).toArray();
            double f = this.igci(xCol, yCol);
            graph.removeEdges(x, y);
            if (f < -this.epsilon) {
                _graph.addDirectedEdge(x, y);
                continue;
            }
            if (f > this.epsilon) {
                _graph.addDirectedEdge(y, x);
                continue;
            }
            if (this.resolveOneEdgeMaxR3(xCol, yCol) < 0.0) {
                _graph.addDirectedEdge(x, y);
                continue;
            }
            _graph.addDirectedEdge(y, x);
        }
        return _graph;
    }

    private double igci(double[] x, double[] y) {
        int m = x.length;
        if (m != y.length) {
            throw new IllegalArgumentException("Vectors must be the same length.");
        }
        double meanx = StatUtils.mean(x);
        double stdx = StatUtils.sd(x);
        double meany = StatUtils.mean(y);
        double stdy = StatUtils.sd(y);
        for (int i = 0; i < x.length; ++i) {
            x[i] = (x[i] - meanx) / stdx;
            y[i] = (y[i] - meany) / stdy;
        }
        double[] x1 = Arrays.copyOf(x, x.length);
        Arrays.sort(x1);
        x1 = this.removeNaN(x1);
        double[] y1 = Arrays.copyOf(y, y.length);
        Arrays.sort(y1);
        y1 = this.removeNaN(y1);
        int n1 = x1.length;
        double hx = 0.0;
        for (int i = 0; i < n1 - 1; ++i) {
            double delta = x1[i + 1] - x1[i];
            if (delta == 0.0) continue;
            hx += FastMath.log(FastMath.abs(delta));
        }
        hx = hx / (double)(n1 - 1) + this.psi(n1) - this.psi(1.0);
        int n2 = y1.length;
        double hy = 0.0;
        for (int i = 0; i < n2 - 1; ++i) {
            double delta = y1[i + 1] - y1[i];
            if (delta == 0.0) continue;
            if (Double.isNaN(delta)) {
                throw new IllegalArgumentException();
            }
            hy += FastMath.log(FastMath.abs(delta));
        }
        hy = hy / (double)(n2 - 1) + this.psi(n2) - this.psi(1.0);
        double f = hy - hx;
        return f;
    }

    private double[] removeNaN(double[] data) {
        ArrayList<Double> _leaveOutMissing = new ArrayList<Double>();
        for (double datum : data) {
            if (Double.isNaN(datum)) continue;
            _leaveOutMissing.add(datum);
        }
        double[] _data = new double[_leaveOutMissing.size()];
        for (int i = 0; i < _leaveOutMissing.size(); ++i) {
            _data[i] = (Double)_leaveOutMissing.get(i);
        }
        return _data;
    }

    double psi(double x) {
        double result = 0.0;
        assert (x > 0.0);
        while (x < 7.0) {
            result -= 1.0 / x;
            x += 1.0;
        }
        double xx = 1.0 / (x -= 0.5);
        double xx2 = xx * xx;
        double xx4 = xx2 * xx2;
        return result += FastMath.log(x) + 0.041666666666666664 * xx2 - 0.007291666666666667 * xx4 + 0.0038442460317460315 * xx4 * xx2 - 0.004134114583333333 * xx4 * xx4;
    }

    private double combinedScore(double score1, double score2) {
        return score1 + score2;
    }

    private double score(Node y, List<Node> parents) {
        if (this.score == Score.andersonDarling) {
            return this.andersonDarlingPASquare(y, parents);
        }
        if (this.score == Score.kurtosis) {
            return FastMath.abs(StatUtils.kurtosis(this.residuals(y, parents, true)));
        }
        if (this.score == Score.entropy) {
            return this.entropy(y, parents);
        }
        if (this.score == Score.skew) {
            return FastMath.abs(StatUtils.skewness(this.residuals(y, parents, true)));
        }
        if (this.score == Score.fifthMoment) {
            return FastMath.abs(StatUtils.standardizedFifthMoment(this.residuals(y, parents, true)));
        }
        if (this.score == Score.absoluteValue) {
            return this.meanAbsolute(y, parents);
        }
        if (this.score == Score.exp) {
            return this.expScoreUnstandardized(y, parents);
        }
        if (this.score == Score.other) {
            double[] _f = this.residuals(y, parents, true);
            return this.score(_f);
        }
        if (this.score == Score.logcosh) {
            return this.logCoshScore(y, parents);
        }
        throw new IllegalStateException();
    }

    private double score(double[] col) {
        if (this.score == Score.andersonDarling) {
            return new AndersonDarlingTest(col).getASquaredStar();
        }
        if (this.score == Score.entropy) {
            return StatUtils.maxEntApprox(col);
        }
        if (this.score == Score.kurtosis) {
            col = DataTransforms.standardizeData(col);
            return -FastMath.abs(StatUtils.kurtosis(col));
        }
        if (this.score == Score.skew) {
            return FastMath.abs(StatUtils.skewness(col));
        }
        if (this.score == Score.fifthMoment) {
            return FastMath.abs(StatUtils.standardizedFifthMoment(col));
        }
        if (this.score == Score.absoluteValue) {
            return StatUtils.meanAbsolute(col);
        }
        if (this.score == Score.exp) {
            return this.expScoreUnstandardized(col);
        }
        if (this.score == Score.other) {
            return FastMath.abs(StatUtils.kurtosis(col));
        }
        if (this.score == Score.logcosh) {
            return StatUtils.logCoshScore(col);
        }
        throw new IllegalStateException("Unrecognized score: " + (Object)((Object)this.score));
    }

    private double meanAbsolute(Node node, List<Node> parents) {
        double[] _f = this.residuals(node, parents, false);
        return StatUtils.meanAbsolute(_f);
    }

    private double expScoreUnstandardized(Node node, List<Node> parents) {
        double[] _f = this.residuals(node, parents, false);
        return this.expScoreUnstandardized(_f);
    }

    private double expScoreUnstandardized(double[] _f) {
        double sum = 0.0;
        for (double v : _f) {
            sum += FastMath.exp(v);
        }
        double expected = sum / (double)_f.length;
        return -FastMath.abs(FastMath.log(expected));
    }

    private double logCoshScore(Node node, List<Node> parents) {
        double[] _f = this.residuals(node, parents, true);
        return StatUtils.logCoshScore(_f);
    }

    private double[] residuals(Node node, List<Node> parents, boolean standardize) {
        ArrayList<Double> _residuals = new ArrayList<Double>();
        Node target = this.getVariable(this.variables, node.getName());
        ArrayList<Node> regressors = new ArrayList<Node>();
        for (Node _regressor : parents) {
            Node variable = this.getVariable(this.variables, _regressor.getName());
            regressors.add(variable);
        }
        block1: for (int m = 0; m < this.dataSets.size() && !Thread.currentThread().isInterrupted(); ++m) {
            DataSet dataSet = this.dataSets.get(m);
            int targetCol = dataSet.getColumn(target);
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                if (Double.isNaN(dataSet.getDouble(i, targetCol))) continue block1;
            }
            for (Node regressor : regressors) {
                if (Thread.currentThread().isInterrupted()) break;
                int regressorCol = dataSet.getColumn(regressor);
                for (int i = 0; i < dataSet.getNumRows(); ++i) {
                    if (Double.isNaN(dataSet.getDouble(i, regressorCol))) continue block1;
                }
            }
            RegressionResult result = this.getRegressions().get(m).regress(target, regressors);
            double[] residualsSingleDataset = result.getResiduals().toArray();
            if (result.getCoef().length > 0) {
                double intercept = result.getCoef()[0];
                for (int i2 = 0; i2 < residualsSingleDataset.length; ++i2) {
                    residualsSingleDataset[i2] = residualsSingleDataset[i2] + intercept;
                }
            }
            for (double _x : residualsSingleDataset) {
                if (Double.isNaN(_x)) continue;
                _residuals.add(_x);
            }
        }
        double[] _f = new double[_residuals.size()];
        for (int k = 0; k < _residuals.size(); ++k) {
            _f[k] = (Double)_residuals.get(k);
        }
        if (standardize) {
            _f = DataTransforms.standardizeData(_f);
        }
        return _f;
    }

    private double andersonDarlingPASquare(Node node, List<Node> parents) {
        double[] _f = this.residuals(node, parents, true);
        return new AndersonDarlingTest(_f).getASquared();
    }

    private double entropy(Node node, List<Node> parents) {
        double[] _f = this.residuals(node, parents, true);
        return StatUtils.maxEntApprox(_f);
    }

    private double pValue(Node node, List<Node> parents) {
        ArrayList<Double> _residuals = new ArrayList<Double>();
        Node target = this.getVariable(this.variables, node.getName());
        ArrayList<Node> regressors = new ArrayList<Node>();
        for (Node _regressor : parents) {
            Node variable = this.getVariable(this.variables, _regressor.getName());
            regressors.add(variable);
        }
        block1: for (int m = 0; m < this.dataSets.size() && !Thread.currentThread().isInterrupted(); ++m) {
            DataSet dataSet = this.dataSets.get(m);
            int targetCol = dataSet.getColumn(target);
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                if (Double.isNaN(dataSet.getDouble(i, targetCol))) continue block1;
            }
            for (Node regressor : regressors) {
                if (Thread.currentThread().isInterrupted()) break;
                int regressorCol = dataSet.getColumn(regressor);
                for (int i = 0; i < dataSet.getNumRows(); ++i) {
                    if (Double.isNaN(dataSet.getDouble(i, regressorCol))) continue block1;
                }
            }
            RegressionResult result = this.getRegressions().get(m).regress(target, regressors);
            Vector residualsSingleDataset = result.getResiduals();
            for (int h = 0; h < residualsSingleDataset.size(); ++h) {
                if (Double.isNaN(residualsSingleDataset.get(h))) continue block1;
            }
            Vector _residualsSingleDataset = new Vector(residualsSingleDataset.toArray());
            for (int k = 0; k < _residualsSingleDataset.size(); ++k) {
                _residuals.add(_residualsSingleDataset.get(k));
            }
        }
        double[] _f = new double[_residuals.size()];
        for (int k = 0; k < _residuals.size(); ++k) {
            _f[k] = (Double)_residuals.get(k);
        }
        double p = new AndersonDarlingTest(_f).getP();
        if (p > 1.0 || Double.isNaN(p)) {
            p = 1.0;
        }
        return p;
    }

    private Graph getCpdag() {
        return this.cpdag;
    }

    private Node getVariable(List<Node> variables, String name) {
        for (Node node : variables) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    private Graph resolveEdgeConditional(Graph graph) {
        this.setDataSets(this.dataSets);
        Set<Edge> edgeList1 = graph.getEdges();
        for (Edge adj : edgeList1) {
            Node x = adj.getNode1();
            Node y = adj.getNode2();
            this.resolveEdgeConditional(graph, x, y);
        }
        return graph;
    }

    private void resolveEdgeConditional(Graph graph, Node x, Node y) {
        if (this._data == null) {
            this._data = DataTransforms.centerData(this.matrices.get(0));
        }
        int xIndex = this.dataSets.get(0).getColumn(this.dataSets.get(0).getVariable(x.getName()));
        int yIndex = this.dataSets.get(0).getColumn(this.dataSets.get(0).getVariable(y.getName()));
        double[] xCol = this._data.getColumn(xIndex).toArray();
        double[] yCol = this._data.getColumn(yIndex).toArray();
        int N = xCol.length;
        double[][] yCols = new double[1][N];
        yCols[0] = yCol;
        double[][] xCols = new double[1][N];
        xCols[0] = xCol;
        double[][] empty = new double[0][N];
        double[] resX = this.conditionalResiduals(xCol, empty);
        double[] resY = this.conditionalResiduals(yCol, empty);
        double[] resXY = this.conditionalResiduals(xCol, yCols);
        double[] resYX = this.conditionalResiduals(yCol, xCols);
        double ngX = new AndersonDarlingTest(xCol).getASquared();
        double ngY = new AndersonDarlingTest(yCol).getASquared();
        graph.removeEdges(x, y);
        double sdX = StatUtils.sd(resX);
        double sdXY = StatUtils.sd(resXY);
        double sdY = StatUtils.sd(resY);
        double sdYX = StatUtils.sd(resYX);
        double abs1 = FastMath.abs(sdX - sdXY);
        double abs2 = FastMath.abs(sdY - sdYX);
        if (FastMath.abs(abs1 - abs2) < this.epsilon) {
            System.out.println("Orienting by non-Gaussianity " + FastMath.abs(abs1 - abs2) + " epsilon = " + this.epsilon);
            System.out.println(x + "===" + y);
            double v = this.resolveOneEdgeMaxR3b(xCol, yCol);
            if (v < 0.0) {
                graph.addDirectedEdge(x, y);
            } else if (v > 0.0) {
                graph.addDirectedEdge(y, x);
            } else {
                graph.addUndirectedEdge(x, y);
            }
            return;
        }
        System.out.println("Orienting by variances " + FastMath.abs(abs1 - abs2));
        System.out.println(x + "===" + y);
        if (sdXY + ngY < sdYX + ngX) {
            graph.addDirectedEdge(x, y);
        } else {
            graph.addDirectedEdge(y, x);
        }
    }

    private double[] conditionalResiduals(double[] x, double[][] y) {
        int N = x.length;
        double[] residuals = new double[N];
        double _h = 1.0;
        for (double[] doubles : y) {
            _h *= this.h(doubles);
        }
        _h = y.length == 0 ? 1.0 : FastMath.pow(_h, 1.0 / (double)y.length);
        for (int i = 0; i < N; ++i) {
            double xi = x[i];
            double sum = 0.0;
            double kTot = 0.0;
            for (int j = 0; j < N; ++j) {
                double d = this.distance(y, i, j);
                double k = this.kernel(d / _h) / _h;
                if (k < 1.0E-5) continue;
                double xj = x[j];
                sum += k * xj;
                kTot += k;
            }
            residuals[i] = xi - sum / kTot;
        }
        return residuals;
    }

    private double h(double[] xCol) {
        double[] g = new double[xCol.length];
        double median = StatUtils.median(xCol);
        for (int j = 0; j < xCol.length; ++j) {
            g[j] = FastMath.abs(xCol[j] - median);
        }
        return StatUtils.median(g) / 0.6745 * FastMath.pow(1.3333333333333333 / (double)xCol.length, 0.2);
    }

    public double kernel(double z) {
        return this.kernel1(z);
    }

    public double kernel1(double z) {
        return FastMath.exp(-(z * z) / 2.0) / this.SQRT;
    }

    public double kernel2(double z) {
        if (FastMath.abs(z) > 1.0) {
            return 0.0;
        }
        return 0.5;
    }

    public double kernel3(double z) {
        if (FastMath.abs(z) > 1.0) {
            return 0.0;
        }
        return 1.0 - FastMath.abs(z);
    }

    public double kernel4(double z) {
        if (FastMath.abs(z) > 1.0) {
            return 0.0;
        }
        return 0.75 * (1.0 - z * z);
    }

    public double kernel5(double z) {
        if (FastMath.abs(z) > 1.0) {
            return 0.0;
        }
        return 0.9375 * FastMath.pow(1.0 - z * z, 2.0);
    }

    public double kernel6(double z) {
        if (FastMath.abs(z) > 1.0) {
            return 0.0;
        }
        return 1.09375 * FastMath.pow(1.0 - z * z, 3.0);
    }

    public double kernel7(double z) {
        if (FastMath.abs(z) > 1.0) {
            return 0.0;
        }
        return 0.8641975308641975 * FastMath.pow(1.0 - z * z * z, 3.0);
    }

    public double kernel8(double z) {
        if (FastMath.abs(z) > 1.0) {
            return 0.0;
        }
        return 0.7853981633974483 * FastMath.cos(1.5707963267948966 * z);
    }

    private double distance(double[][] yCols, int i, int j) {
        double sum = 0.0;
        for (double[] yCol : yCols) {
            double d = yCol[i] - yCol[j];
            sum += d * d;
        }
        return FastMath.sqrt(sum);
    }

    private double resolveOneEdgeMaxR3(double[] x, double[] y) {
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        double[][] _x = new double[][]{x};
        double[][] _y = new double[][]{y};
        regression.newSampleData(x, MatrixUtils.transpose(_y));
        double[] rXY = regression.estimateResiduals();
        regression.newSampleData(y, MatrixUtils.transpose(_x));
        double[] rYX = regression.estimateResiduals();
        double xPlus = new AndersonDarlingTest(rXY).getASquared();
        double xMinus = new AndersonDarlingTest(x).getASquared();
        double yPlus = new AndersonDarlingTest(rYX).getASquared();
        double yMinus = new AndersonDarlingTest(y).getASquared();
        double deltaX = xPlus - xMinus;
        double deltaY = yPlus - yMinus;
        return deltaX - deltaY;
    }

    private double resolveOneEdgeMaxR3b(double[] x, double[] y) {
        int N = x.length;
        double[][] yCols = new double[1][N];
        yCols[0] = y;
        double[][] xCols = new double[1][N];
        xCols[0] = x;
        double[][] empty = new double[0][N];
        double[] rX = this.conditionalResiduals(x, empty);
        double[] rY = this.conditionalResiduals(y, empty);
        double[] rXY = this.conditionalResiduals(x, yCols);
        double[] rYX = this.conditionalResiduals(y, xCols);
        double xPlus = new AndersonDarlingTest(rXY).getASquared();
        double xMinus = new AndersonDarlingTest(rX).getASquared();
        double yPlus = new AndersonDarlingTest(rYX).getASquared();
        double yMinus = new AndersonDarlingTest(rY).getASquared();
        double deltaX = xPlus - xMinus;
        double deltaY = yPlus - yMinus;
        return deltaX - deltaY;
    }

    public static enum Score {
        andersonDarling,
        skew,
        kurtosis,
        fifthMoment,
        absoluteValue,
        exp,
        expUnstandardized,
        expUnstandardizedInverted,
        other,
        logcosh,
        entropy;

    }

    public static enum Rule {
        IGCI,
        R1TimeLag,
        R1,
        R2,
        R3,
        Tanh,
        EB,
        Skew,
        SkewE,
        RSkew,
        RSkewE,
        Patel,
        Patel25,
        Patel50,
        Patel75,
        Patel90,
        FastICA,
        RC;

    }
}

