/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.utils.PcCommon;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Pc
implements IGraphSearch {
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Knowledge knowledge = new Knowledge();
    private SepsetMap sepsets;
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private int numIndependenceTests;
    private boolean verbose = false;
    private PcCommon.ConflictRule conflictRule = PcCommon.ConflictRule.PRIORITIZE_EXISTING;
    private boolean stable = true;
    private boolean meekPreventCycles = true;
    private boolean useMaxPHeuristic = false;
    private PcCommon.PcHeuristicType pcHeuristicType = PcCommon.PcHeuristicType.NONE;

    public Pc(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException("Independence test is null.");
        }
        this.independenceTest = independenceTest;
    }

    @Override
    public Graph search() {
        return this.search(new HashSet<Node>(this.independenceTest.getVariables()));
    }

    public Graph search(Set<Node> nodes) {
        nodes = new HashSet<Node>(nodes);
        Fas fas = new Fas(this.getIndependenceTest());
        fas.setVerbose(this.verbose);
        return this.search(fas, nodes);
    }

    public Graph search(IFas fas, Set<Node> nodes) {
        this.logger.forceLogMessage("Starting PC algorithm");
        this.logger.forceLogMessage("Independence test = " + this.getIndependenceTest() + ".");
        long startTime = MillisecondTimes.timeMillis();
        if (this.getIndependenceTest() == null) {
            throw new NullPointerException("Null independence test.");
        }
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!new HashSet<Node>(allNodes).containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        PcCommon search = new PcCommon(this.independenceTest);
        search.setDepth(this.depth);
        search.setMeekPreventCycles(this.meekPreventCycles);
        search.setPcHeuristicType(this.pcHeuristicType);
        search.setKnowledge(this.knowledge);
        if (this.stable) {
            search.setFasType(PcCommon.FasType.STABLE);
        } else {
            search.setFasType(PcCommon.FasType.REGULAR);
        }
        if (this.useMaxPHeuristic) {
            search.setColliderDiscovery(PcCommon.ColliderDiscovery.MAX_P);
        } else {
            search.setColliderDiscovery(PcCommon.ColliderDiscovery.FAS_SEPSETS);
        }
        search.setConflictRule(this.conflictRule);
        search.setPcHeuristicType(this.pcHeuristicType);
        search.setVerbose(this.verbose);
        this.graph = search.search();
        this.sepsets = fas.getSepsets();
        this.numIndependenceTests = fas.getNumIndependenceTests();
        this.elapsedTime = MillisecondTimes.timeMillis() - startTime;
        this.logger.forceLogMessage("Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.forceLogMessage("Finishing PC Algorithm.");
        this.logger.flush();
        return this.graph;
    }

    public void setMeekPreventCycles(boolean meekPreventCycles) {
        this.meekPreventCycles = meekPreventCycles;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Knowledge is null.");
        }
        this.knowledge = knowledge;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth > 1000) {
            throw new IllegalArgumentException("Depth must be <= 1000.");
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Set<Edge> getAdjacencies() {
        return new HashSet<Edge>(this.graph.getEdges());
    }

    public Set<Edge> getNonadjacencies() {
        Graph complete = GraphUtils.completeGraph(this.graph);
        Set<Edge> nonAdjacencies = complete.getEdges();
        Graph undirected = GraphUtils.undirectedGraph(this.graph);
        nonAdjacencies.removeAll(undirected.getEdges());
        return new HashSet<Edge>(nonAdjacencies);
    }

    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    public void setConflictRule(PcCommon.ConflictRule conflictRule) {
        this.conflictRule = conflictRule;
    }

    public void setUseMaxPHeuristic(boolean useMaxPHeuristic) {
        this.useMaxPHeuristic = useMaxPHeuristic;
    }

    public void setPcHeuristicType(PcCommon.PcHeuristicType pcHeuristicType) {
        this.pcHeuristicType = pcHeuristicType;
    }
}

