/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SuborderSearch;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.GrowShrinkTree;
import edu.cmu.tetrad.search.utils.MeekRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermutationSearch {
    private final SuborderSearch suborderSearch;
    private final List<Node> variables;
    private final List<Node> order;
    private final Map<Node, GrowShrinkTree> gsts;
    private Knowledge knowledge = new Knowledge();

    public PermutationSearch(SuborderSearch suborderSearch) {
        this.suborderSearch = suborderSearch;
        this.variables = suborderSearch.getVariables();
        this.order = new ArrayList<Node>();
        this.gsts = new HashMap<Node, GrowShrinkTree>();
        Score score = suborderSearch.getScore();
        HashMap<Node, Integer> index = new HashMap<Node, Integer>();
        int i = 0;
        for (Node node : this.variables) {
            index.put(node, i++);
            this.gsts.put(node, new GrowShrinkTree(score, index, node));
            this.order.add(node);
        }
    }

    public static Graph getGraph(List<Node> nodes, Map<Node, Set<Node>> parents, boolean cpDag) {
        return PermutationSearch.getGraph(nodes, parents, null, cpDag);
    }

    public static Graph getGraph(List<Node> nodes, Map<Node, Set<Node>> parents, Knowledge knowledge, boolean cpDag) {
        EdgeListGraph graph = new EdgeListGraph(nodes);
        for (Node a : nodes) {
            for (Node b : parents.get(a)) {
                graph.addDirectedEdge(b, a);
            }
        }
        if (cpDag) {
            MeekRules rules = new MeekRules();
            if (knowledge != null) {
                rules.setKnowledge(knowledge);
            }
            rules.orientImplied(graph);
        }
        return graph;
    }

    public Graph search() {
        if (!this.knowledge.isEmpty() && this.knowledge.getVariablesNotInTiers().isEmpty()) {
            ArrayList<Node> order = new ArrayList<Node>(this.order);
            this.order.clear();
            int start = 0;
            for (int i = 0; i < this.knowledge.getNumTiers(); ++i) {
                List<Node> suborder;
                ArrayList<Node> prefix = new ArrayList<Node>(this.order);
                List<String> tier = this.knowledge.getTier(i);
                for (Node node : order) {
                    String name = node.getName();
                    if (!tier.contains(name)) continue;
                    this.order.add(node);
                    if (!this.knowledge.isTierForbiddenWithin(i)) continue;
                    suborder = this.order.subList(start++, this.order.size());
                    this.suborderSearch.searchSuborder(prefix, suborder, this.gsts);
                }
                if (this.knowledge.isTierForbiddenWithin(i)) continue;
                suborder = this.order.subList(start, this.order.size());
                this.suborderSearch.searchSuborder(prefix, suborder, this.gsts);
                start = this.order.size();
            }
        } else {
            List<Node> prefix = Collections.emptyList();
            this.suborderSearch.searchSuborder(prefix, this.order, this.gsts);
        }
        return PermutationSearch.getGraph(this.variables, this.suborderSearch.getParents(), this.knowledge, true);
    }

    public List<Node> getOrder() {
        return this.order;
    }

    public void setOrder(List<Node> order) {
        assert (new HashSet<Node>(order).containsAll(this.variables));
        this.order.clear();
        this.order.addAll(order);
    }

    public GrowShrinkTree getGST(Node node) {
        return this.gsts.get(node);
    }

    public List<Node> getVariables() {
        return new ArrayList<Node>(this.variables);
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
        this.suborderSearch.setKnowledge(knowledge);
        for (Node node : this.variables) {
            ArrayList<Node> required = new ArrayList<Node>();
            ArrayList<Node> forbidden = new ArrayList<Node>();
            for (Node parent : this.variables) {
                if (knowledge.isRequired(parent.getName(), node.getName())) {
                    required.add(parent);
                }
                if (!knowledge.isForbidden(parent.getName(), node.getName())) continue;
                forbidden.add(parent);
            }
            if (required.isEmpty() && forbidden.isEmpty()) continue;
            this.gsts.get(node).setKnowledge(required, forbidden);
        }
    }
}

