/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.search.utils.SepsetsSet;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class Rfci
implements IGraphSearch {
    private final List<Node> variables = new ArrayList<Node>();
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Graph graph;
    private SepsetMap sepsets;
    private Knowledge knowledge = new Knowledge();
    private int maxPathLength = -1;
    private int depth = -1;
    private long elapsedTime;
    private boolean verbose;

    public Rfci(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
    }

    public Rfci(IndependenceTest independenceTest, List<Node> searchVars) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        ArrayList<Node> remVars = new ArrayList<Node>();
        for (Node node1 : this.variables) {
            boolean search = false;
            for (Node node2 : searchVars) {
                if (!node1.getName().equals(node2.getName())) continue;
                search = true;
            }
            if (search) continue;
            remVars.add(node1);
        }
        this.variables.removeAll(remVars);
    }

    @Override
    public Graph search() {
        return this.search(this.getIndependenceTest().getVariables());
    }

    public Graph search(List<Node> nodes) {
        nodes = new ArrayList<Node>(nodes);
        return this.search(new Fas(this.getIndependenceTest()), nodes);
    }

    public Graph search(IFas fas, List<Node> nodes) {
        long beginTime = MillisecondTimes.timeMillis();
        this.independenceTest.setVerbose(this.verbose);
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.setMaxPathLength(this.maxPathLength);
        this.graph = new EdgeListGraph(nodes);
        long start1 = MillisecondTimes.timeMillis();
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.depth);
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        this.graph.reorientAllWith(Endpoint.CIRCLE);
        this.sepsets = fas.getSepsets();
        long stop1 = MillisecondTimes.timeMillis();
        long start2 = MillisecondTimes.timeMillis();
        FciOrient orient = new FciOrient(new SepsetsSet(this.sepsets, this.independenceTest));
        orient.setCompleteRuleSetUsed(true);
        orient.fciOrientbk(this.getKnowledge(), this.graph, this.variables);
        this.ruleR0_RFCI(this.getRTuples());
        orient.doFinalOrientation(this.graph);
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - beginTime;
        this.logger.log("graph", "Returning graph: " + this.graph);
        long stop2 = MillisecondTimes.timeMillis();
        this.logger.log("info", "Elapsed time adjacency search = " + (stop1 - start1) / 1000L + "s");
        this.logger.log("info", "Elapsed time orientation search = " + (stop2 - start2) / 1000L + "s");
        return this.graph;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public int getMaxPathLength() {
        return this.maxPathLength == Integer.MAX_VALUE ? -1 : this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength == -1 ? Integer.MAX_VALUE : maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    private Set<Node> getSepset(Node i, Node k) {
        return this.sepsets.get(i, k);
    }

    private void ruleR0_RFCI(List<Node[]> rTuples) {
        ArrayList<Node[]> lTuples = new ArrayList<Node[]>();
        List<Node> nodes = this.graph.getNodes();
        while (!rTuples.isEmpty()) {
            Node[] curTuple;
            Node[] thisTuple = rTuples.remove(0);
            Node i = thisTuple[0];
            Node j = thisTuple[1];
            Node k = thisTuple[2];
            Set<Node> nodes1 = this.getSepset(i, k);
            if (nodes1 == null) continue;
            HashSet<Node> sepSet = new HashSet<Node>(nodes1);
            sepSet.remove(j);
            boolean independent1 = false;
            if (this.knowledge.noEdgeRequired(i.getName(), j.getName())) {
                try {
                    independent1 = this.independenceTest.checkIndependence(i, j, sepSet).isIndependent();
                }
                catch (Exception e) {
                    independent1 = true;
                }
            }
            boolean independent2 = false;
            if (this.knowledge.noEdgeRequired(j.getName(), k.getName())) {
                try {
                    independent2 = this.independenceTest.checkIndependence(j, k, sepSet).isIndependent();
                }
                catch (Exception e) {
                    independent2 = true;
                }
            }
            if (!independent1 && !independent2) {
                lTuples.add(thisTuple);
                continue;
            }
            if (independent1) {
                this.setMinSepSet(sepSet, i, j);
                this.graph.removeEdge(i, j);
            }
            if (independent2) {
                this.setMinSepSet(sepSet, j, k);
                this.graph.removeEdge(j, k);
            }
            for (Node thisNode : nodes) {
                Node[] newTuple;
                List<Node> adjacentNodes = this.graph.getAdjacentNodes(thisNode);
                if (independent1 && adjacentNodes.contains(i) && adjacentNodes.contains(j)) {
                    newTuple = new Node[]{i, thisNode, j};
                    rTuples.add(newTuple);
                }
                if (!independent2 || !adjacentNodes.contains(j) || !adjacentNodes.contains(k)) continue;
                newTuple = new Node[]{j, thisNode, k};
                rTuples.add(newTuple);
            }
            Iterator<Object> iter = rTuples.iterator();
            while (iter.hasNext()) {
                curTuple = iter.next();
                if ((!independent1 || curTuple[1] != i || curTuple[0] != j && curTuple[2] != j) && (!independent2 || curTuple[1] != k || curTuple[0] != j && curTuple[2] != j) && (!independent1 || curTuple[1] != j || curTuple[0] != i && curTuple[2] != i) && (!independent2 || curTuple[1] != j || curTuple[0] != k && curTuple[2] != k)) continue;
                iter.remove();
            }
            iter = lTuples.iterator();
            while (iter.hasNext()) {
                curTuple = (Node[])iter.next();
                if ((!independent1 || curTuple[1] != i || curTuple[0] != j && curTuple[2] != j) && (!independent2 || curTuple[1] != k || curTuple[0] != j && curTuple[2] != j) && (!independent1 || curTuple[1] != j || curTuple[0] != i && curTuple[2] != i) && (!independent2 || curTuple[1] != j || curTuple[0] != k && curTuple[2] != k)) continue;
                iter.remove();
            }
        }
        for (Node[] thisTuple : lTuples) {
            Node i = thisTuple[0];
            Node j = thisTuple[1];
            Node k = thisTuple[2];
            Set<Node> sepset = this.getSepset(i, k);
            if (sepset == null || sepset.contains(j) || !this.graph.isAdjacentTo(i, j) || !this.graph.isAdjacentTo(j, k) || !FciOrient.isArrowheadAllowed(i, j, this.graph, this.knowledge) || !FciOrient.isArrowheadAllowed(k, j, this.graph, this.knowledge)) continue;
            this.graph.setEndpoint(i, j, Endpoint.ARROW);
            this.graph.setEndpoint(k, j, Endpoint.ARROW);
        }
    }

    private List<Node[]> getRTuples() {
        ArrayList<Node[]> rTuples = new ArrayList<Node[]>();
        List<Node> nodes = this.graph.getNodes();
        for (Node j : nodes) {
            int[] combination;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(this.graph.getAdjacentNodes(j));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node k;
                Node i = (Node)adjacentNodes.get(combination[0]);
                if (this.graph.isAdjacentTo(i, k = (Node)adjacentNodes.get(combination[1]))) continue;
                Node[] newTuple = new Node[]{i, j, k};
                rTuples.add(newTuple);
            }
        }
        return rTuples;
    }

    private void setMinSepSet(Set<Node> _sepSet, Node x, Node y) {
        boolean independent;
        Set<Node> empty = Collections.emptySet();
        ArrayList<Node> sepSet = new ArrayList<Node>(_sepSet);
        Collections.sort(sepSet);
        try {
            independent = this.independenceTest.checkIndependence(x, y, empty).isIndependent();
        }
        catch (Exception e) {
            independent = false;
        }
        if (independent) {
            this.getSepsets().set(x, y, empty);
            return;
        }
        int sepSetSize = sepSet.size();
        for (int i = 1; i <= sepSetSize; ++i) {
            int[] combination;
            ChoiceGenerator cg = new ChoiceGenerator(sepSetSize, i);
            while ((combination = cg.next()) != null) {
                Set<Node> condSet = GraphUtils.asSet(combination, sepSet);
                independent = this.independenceTest.checkIndependence(x, y, condSet).isIndependent();
                if (!independent) continue;
                this.getSepsets().set(x, y, condSet);
                return;
            }
        }
    }
}

