/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SuborderSearch;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.GrowShrinkTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sp
implements SuborderSearch {
    private final Score score;
    private final List<Node> variables;
    private final Map<Node, Set<Node>> parents;
    private Map<Node, GrowShrinkTree> gsts;
    private Knowledge knowledge = new Knowledge();

    public Sp(Score score) {
        this.score = score;
        this.variables = score.getVariables();
        this.parents = new HashMap<Node, Set<Node>>();
        for (Node node : this.variables) {
            this.parents.put(node, new HashSet());
        }
    }

    @Override
    public void searchSuborder(List<Node> prefix, List<Node> suborder, Map<Node, GrowShrinkTree> gsts) {
        this.gsts = gsts;
        this.makeValidKnowledgeOrder(suborder);
        ArrayList<Node> bestSuborder = new ArrayList<Node>(suborder);
        double bestScore = this.update(prefix, suborder);
        HashMap<Node, Set<Node>> required = new HashMap<Node, Set<Node>>();
        for (Node y : suborder) {
            for (Node z : suborder) {
                if (!this.knowledge.isRequired(y.getName(), z.getName())) continue;
                if (!required.containsKey(y)) {
                    required.put(y, new HashSet());
                }
                ((Set)required.get(y)).add(z);
            }
        }
        SwapIterator itr = new SwapIterator(suborder.size());
        while (itr.hasNext()) {
            int[] swap = itr.next();
            Node x = suborder.get(swap[0]);
            suborder.set(swap[0], suborder.get(swap[1]));
            suborder.set(swap[1], x);
            double s = this.update(prefix, suborder);
            if (!(s > bestScore) || this.violatesKnowledge(suborder, required)) continue;
            bestSuborder = new ArrayList<Node>(suborder);
            bestScore = s;
        }
        for (int i = 0; i < suborder.size(); ++i) {
            suborder.set(i, (Node)bestSuborder.get(i));
        }
        this.update(prefix, suborder);
    }

    private void makeValidKnowledgeOrder(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            order.sort((a, b) -> {
                if (a.getName().equals(b.getName())) {
                    return 0;
                }
                if (this.knowledge.isRequired(a.getName(), b.getName())) {
                    return -1;
                }
                if (this.knowledge.isRequired(b.getName(), a.getName())) {
                    return 1;
                }
                return 0;
            });
        }
    }

    private boolean violatesKnowledge(List<Node> suborder, Map<Node, Set<Node>> required) {
        for (int i = 0; i < suborder.size(); ++i) {
            Node y = suborder.get(i);
            if (!required.containsKey(y)) continue;
            for (Node z : required.get(y)) {
                if (!suborder.subList(0, i).contains(z)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    private double update(List<Node> prefix, List<Node> suborder) {
        double score = 0.0;
        HashSet<Node> all = new HashSet<Node>(suborder);
        all.addAll(prefix);
        HashSet<Node> Z = new HashSet<Node>(prefix);
        for (Node x : suborder) {
            Set<Node> parents = this.parents.get(x);
            parents.clear();
            score += this.gsts.get(x).trace(Z, all, parents);
            Z.add(x);
        }
        return score;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Map<Node, Set<Node>> getParents() {
        return this.parents;
    }

    @Override
    public Score getScore() {
        return this.score;
    }

    static class SwapIterator
    implements Iterator<int[]> {
        private final int n;
        private final int[] perm;
        private final int[] dirs;
        private int[] next;

        public SwapIterator(int size) {
            this.n = size;
            if (this.n <= 0) {
                this.perm = null;
                this.dirs = null;
            } else {
                this.perm = new int[this.n];
                this.dirs = new int[this.n];
                for (int i = 0; i < this.n; ++i) {
                    this.perm[i] = i;
                    this.dirs[i] = -1;
                }
                this.dirs[0] = 0;
            }
        }

        private static void swap(int i, int j, int[] arr) {
            int x = arr[i];
            arr[i] = arr[j];
            arr[j] = x;
        }

        @Override
        public int[] next() {
            int[] next = this.makeNext();
            this.next = null;
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.makeNext() != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int[] makeNext() {
            if (this.next != null) {
                return this.next;
            }
            if (this.dirs == null || this.perm == null) {
                return null;
            }
            int i = -1;
            int x = -1;
            for (int j = 0; j < this.n; ++j) {
                if (this.dirs[j] == 0 || this.perm[j] <= x) continue;
                x = this.perm[j];
                i = j;
            }
            if (i == -1) {
                return null;
            }
            int k = i + this.dirs[i];
            this.next = new int[]{i, k};
            SwapIterator.swap(i, k, this.dirs);
            SwapIterator.swap(i, k, this.perm);
            if (k == 0 || k == this.n - 1 || this.perm[k + this.dirs[k]] > x) {
                this.dirs[k] = 0;
            }
            for (int j = 0; j < this.n; ++j) {
                if (this.perm[j] <= x) continue;
                this.dirs[j] = j < k ? 1 : -1;
            }
            return this.next;
        }
    }
}

