/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.PermutationSearch;
import edu.cmu.tetrad.search.Sp;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.SepsetProducer;
import edu.cmu.tetrad.search.utils.SepsetsGreedy;
import edu.cmu.tetrad.search.work_in_progress.MagSemBicScore;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class SpFci
implements IGraphSearch {
    private final TetradLogger logger = TetradLogger.getInstance();
    private final Score score;
    int sampleSize;
    private Graph graph;
    private Knowledge knowledge = new Knowledge();
    private final IndependenceTest independenceTest;
    private boolean completeRuleSetUsed = true;
    private int maxPathLength = -1;
    private int maxDegree = -1;
    private boolean verbose;
    private int depth = -1;
    private boolean doDiscriminatingPathRule = true;

    public SpFci(IndependenceTest test, Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.sampleSize = score.getSampleSize();
        this.score = score;
        this.independenceTest = test;
    }

    @Override
    public Graph search() {
        List<Node> nodes = this.getIndependenceTest().getVariables();
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.graph = new EdgeListGraph(nodes);
        Sp subAlg = new Sp(this.score);
        PermutationSearch alg = new PermutationSearch(subAlg);
        alg.setKnowledge(this.knowledge);
        this.graph = alg.search();
        if (this.score instanceof MagSemBicScore) {
            ((MagSemBicScore)this.score).setMag(this.graph);
        }
        Knowledge knowledge2 = new Knowledge(this.knowledge);
        GraphUtils.addForbiddenReverseEdgesForDirectedEdges(GraphTransforms.cpdagForDag(this.graph), knowledge2);
        EdgeListGraph referenceDag = new EdgeListGraph(this.graph);
        SepsetsGreedy sepsets = new SepsetsGreedy(this.graph, this.independenceTest, null, this.depth, this.knowledge);
        GraphUtils.gfciExtraEdgeRemovalStep(this.graph, referenceDag, nodes, sepsets);
        this.modifiedR0(referenceDag, sepsets);
        FciOrient fciOrient = new FciOrient(sepsets);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setVerbose(this.verbose);
        fciOrient.setKnowledge(knowledge2);
        fciOrient.doFinalOrientation(this.graph);
        GraphUtils.replaceNodes(this.graph, this.independenceTest.getVariables());
        return this.graph;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public void setMaxDegree(int maxDegree) {
        if (maxDegree < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + maxDegree);
        }
        this.maxDegree = maxDegree;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public void setOut(PrintStream out) {
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    private void modifiedR0(Graph fgesGraph, SepsetProducer sepsets) {
        this.graph = new EdgeListGraph(this.graph);
        this.graph.reorientAllWith(Endpoint.CIRCLE);
        this.fciOrientbk(this.knowledge, this.graph, this.graph.getNodes());
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(this.graph.getAdjacentNodes(b));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Set<Node> sepset;
                Node c;
                Node a = (Node)adjacentNodes.get(combination[0]);
                if (fgesGraph.isDefCollider(a, b, c = (Node)adjacentNodes.get(combination[1]))) {
                    this.graph.setEndpoint(a, b, Endpoint.ARROW);
                    this.graph.setEndpoint(c, b, Endpoint.ARROW);
                    continue;
                }
                if (!fgesGraph.isAdjacentTo(a, c) || this.graph.isAdjacentTo(a, c) || (sepset = sepsets.getSepset(a, c)) == null || sepset.contains(b)) continue;
                this.graph.setEndpoint(a, b, Endpoint.ARROW);
                this.graph.setEndpoint(c, b, Endpoint.ARROW);
            }
        }
    }

    private void fciOrientbk(Knowledge knowledge, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = knowledge.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), variables);
            to = GraphSearchUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", LogUtilsSearch.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = knowledge.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), variables);
            to = GraphSearchUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", LogUtilsSearch.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        this.logger.log("info", "Finishing BK Orientation.");
    }
}

