/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math3.util.FastMath;

public class SvarFas
implements IFas {
    private final Graph graph;
    private final IndependenceTest test;
    private final TetradLogger logger = TetradLogger.getInstance();
    private final NumberFormat nf = new DecimalFormat("0.00E0");
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private int numIndependenceTests;
    private SepsetMap sepset = new SepsetMap();
    private Graph externalGraph;
    private boolean verbose;
    private PrintStream out = System.out;

    public SvarFas(IndependenceTest test) {
        this.graph = new EdgeListGraph(test.getVariables());
        this.test = test;
    }

    @Override
    public Graph search() {
        boolean more;
        this.logger.log("info", "Starting Fast Adjacency Search.");
        this.graph.removeEdges(this.graph.getEdges());
        this.sepset = new SepsetMap();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        HashMap<Node, Set<Node>> adjacencies = new HashMap<Node, Set<Node>>();
        List<Node> nodes = this.graph.getNodes();
        for (Node node : nodes) {
            adjacencies.put(node, new TreeSet());
        }
        for (int d = 0; d <= _depth && (more = d == 0 ? this.searchAtDepth0(nodes, this.test, adjacencies) : this.searchAtDepth(nodes, this.test, adjacencies, d)); ++d) {
        }
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                if (!((Set)adjacencies.get(x)).contains(y)) continue;
                this.graph.addUndirectedEdge(x, y);
            }
        }
        this.logger.log("info", "Finishing Fast Adjacency Search.");
        return this.graph;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    @Override
    public SepsetMap getSepsets() {
        return this.sepset;
    }

    public void setExternalGraph(Graph externalGraph) {
        this.externalGraph = externalGraph;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public long getElapsedTime() {
        throw new UnsupportedOperationException("This method is not used.");
    }

    @Override
    public List<Node> getNodes() {
        return this.test.getVariables();
    }

    @Override
    public List<Triple> getAmbiguousTriples(Node node) {
        throw new UnsupportedOperationException("This method is not used.");
    }

    @Override
    public void setOut(PrintStream out) {
        this.out = out;
    }

    private boolean searchAtDepth0(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies) {
        Set<Node> empty = Collections.emptySet();
        ArrayList<Node> simListX = new ArrayList<Node>();
        ArrayList<Node> simListY = new ArrayList<Node>();
        for (int i = 0; i < nodes.size(); ++i) {
            if (this.verbose && (i + 1) % 100 == 0) {
                this.out.println("Node # " + (i + 1));
            }
            Node x = nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node y1;
                Node x1;
                Iterator<Node> ity;
                Iterator<Node> itx;
                List<Node> y1List;
                List<Node> x1List;
                List<List<Node>> simList;
                IndependenceResult result;
                Node y2;
                Node x2;
                Node y = nodes.get(j);
                String xName = x.getName();
                String yName = y.getName();
                boolean skippair = false;
                Iterator itx1 = simListX.iterator();
                Iterator ity1 = simListY.iterator();
                while (itx1.hasNext() && ity1.hasNext()) {
                    Node x12 = (Node)itx1.next();
                    Node y12 = (Node)ity1.next();
                    String simX = x12.getName();
                    String simY = y12.getName();
                    if ((!Objects.equals(xName, simX) || !Objects.equals(yName, simY)) && (!Objects.equals(xName, simY) || !Objects.equals(yName, simX))) continue;
                    skippair = true;
                    System.out.println("Skipping pair x,y = " + xName + ", " + yName);
                    break;
                }
                if (skippair || this.externalGraph != null && !this.externalGraph.isAdjacentTo(x2 = this.externalGraph.getNode(x.getName()), y2 = this.externalGraph.getNode(y.getName()))) continue;
                try {
                    ++this.numIndependenceTests;
                    result = test.checkIndependence(x, y, empty);
                    System.out.println("############# independence given empty set: x,y " + x + ", " + y + " independence = " + result.isIndependent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = new IndependenceResult(new IndependenceFact(x, y, empty), false, Double.NaN, Double.NaN);
                }
                boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                if (result.isIndependent() && noEdgeRequired) {
                    this.getSepsets().set(x, y, empty);
                    System.out.println("$$$$$$$$$$$ look for similar pairs x,y = " + x + ", " + y);
                    simList = this.returnSimilarPairs(test, x, y);
                    if (simList.isEmpty()) continue;
                    x1List = simList.get(0);
                    y1List = simList.get(1);
                    simListX.addAll(x1List);
                    simListY.addAll(y1List);
                    itx = x1List.iterator();
                    ity = y1List.iterator();
                    while (itx.hasNext() && ity.hasNext()) {
                        x1 = itx.next();
                        y1 = ity.next();
                        System.out.println("$$$$$$$$$$$ found similar pair x,y = " + x1 + ", " + y1);
                        this.getSepsets().set(x1, y1, empty);
                    }
                    TetradLogger.getInstance().log("independencies", LogUtilsSearch.independenceFact(x, y, empty) + " score = " + this.nf.format(result.getScore()));
                    if (!this.verbose) continue;
                    this.out.println(LogUtilsSearch.independenceFact(x, y, empty) + " score = " + this.nf.format(result.getScore()));
                    continue;
                }
                if (this.forbiddenEdge(x, y)) continue;
                System.out.println("adding edge between x = " + x + " and y = " + y);
                adjacencies.get(x).add(y);
                adjacencies.get(y).add(x);
                simList = this.returnSimilarPairs(test, x, y);
                if (simList.isEmpty()) continue;
                x1List = simList.get(0);
                y1List = simList.get(1);
                simListX.addAll(x1List);
                simListY.addAll(y1List);
                itx = x1List.iterator();
                ity = y1List.iterator();
                while (itx.hasNext() && ity.hasNext()) {
                    x1 = itx.next();
                    y1 = ity.next();
                    System.out.println("$$$$$$$$$$$ similar pair x,y = " + x1 + ", " + y1);
                    System.out.println("adding edge between x = " + x1 + " and y = " + y1);
                    adjacencies.get(x1).add(y1);
                    adjacencies.get(y1).add(x1);
                }
                if (!this.verbose) continue;
                TetradLogger.getInstance().log("dependencies", LogUtilsSearch.independenceFact(x, y, empty) + " score = " + this.nf.format(result.getScore()));
            }
        }
        return this.freeDegree(nodes, adjacencies) > 0;
    }

    private int freeDegree(List<Node> nodes, Map<Node, Set<Node>> adjacencies) {
        int max = 0;
        for (Node x : nodes) {
            Set<Node> opposites = adjacencies.get(x);
            for (Node y : opposites) {
                HashSet<Node> adjx = new HashSet<Node>(opposites);
                adjx.remove(y);
                if (adjx.size() <= max) continue;
                max = adjx.size();
            }
        }
        return max;
    }

    private boolean forbiddenEdge(Node x, Node y) {
        String name2;
        String name1 = x.getName();
        if (this.knowledge.isForbidden(name1, name2 = y.getName()) && this.knowledge.isForbidden(name2, name1)) {
            this.logger.log("edgeRemoved", "Removed " + Edges.undirectedEdge(x, y) + " because it was forbidden by background knowledge.");
            return true;
        }
        return false;
    }

    private boolean searchAtDepth(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies, int depth) {
        int count = 0;
        for (Node x : nodes) {
            if (this.verbose && ++count % 100 == 0) {
                this.out.println("count " + count + " of " + nodes.size());
            }
            ArrayList adjx = new ArrayList(adjacencies.get(x));
            block3: for (Node y : adjx) {
                int[] choice;
                ArrayList<Node> _adjx = new ArrayList<Node>((Collection)adjacencies.get(x));
                _adjx.remove(y);
                List<Node> ppx = this.possibleParents(x, _adjx, this.knowledge);
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                while ((choice = cg.next()) != null) {
                    boolean independent;
                    Set<Node> condSet = GraphUtils.asSet(choice, ppx);
                    try {
                        ++this.numIndependenceTests;
                        independent = test.checkIndependence(x, y, condSet).isIndependent();
                    }
                    catch (Exception e) {
                        independent = false;
                    }
                    boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                    if (!independent || !noEdgeRequired) continue;
                    adjacencies.get(x).remove(y);
                    adjacencies.get(y).remove(x);
                    this.getSepsets().set(x, y, condSet);
                    this.removeSimilarPairs(adjacencies, test, x, y, condSet);
                    continue block3;
                }
            }
        }
        return this.freeDegree(nodes, adjacencies) > depth;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }

    private void removeSimilarPairs(Map<Node, Set<Node>> adjacencies, IndependenceTest test, Node x, Node y, Set<Node> condSet) {
        int i;
        System.out.println("Entering removeSimilarPairs method...");
        System.out.println("original independence: " + x + " and " + y + " conditional on " + condSet);
        if (x.getName().equals("time") || y.getName().equals("time")) {
            System.out.println("Not removing similar pairs b/c variable pair includes time.");
            return;
        }
        for (Node tempNode : condSet) {
            if (!tempNode.getName().equals("time")) continue;
            System.out.println("Not removing similar pairs b/c conditioning set includes time.");
            return;
        }
        int ntiers = this.knowledge.getNumTiers();
        int indx_tier = this.knowledge.isInWhichTier(x);
        int indy_tier = this.knowledge.isInWhichTier(y);
        int tier_diff = FastMath.max(indx_tier, indy_tier) - FastMath.min(indx_tier, indy_tier);
        int indx_comp = -1;
        int indy_comp = -1;
        List<String> tier_x = this.knowledge.getTier(indx_tier);
        List<String> tier_y = this.knowledge.getTier(indy_tier);
        for (i = 0; i < tier_x.size(); ++i) {
            if (!this.getNameNoLag(x.getName()).equals(this.getNameNoLag(tier_x.get(i)))) continue;
            indx_comp = i;
            break;
        }
        for (i = 0; i < tier_y.size(); ++i) {
            if (!this.getNameNoLag(y.getName()).equals(this.getNameNoLag(tier_y.get(i)))) continue;
            indy_comp = i;
            break;
        }
        if (indx_comp == -1) {
            System.out.println("WARNING: indx_comp = -1!!!! ");
        }
        if (indy_comp == -1) {
            System.out.println("WARNING: indy_comp = -1!!!! ");
        }
        for (i = 0; i < ntiers - tier_diff; ++i) {
            String tempNode1;
            List<String> new_tier;
            int condAB_tier;
            int cond_diff;
            int j;
            int ind_temp;
            List<String> temptier;
            int ind_temptier;
            HashSet<Node> condSetAB;
            Node y1;
            Node x1;
            String B;
            String A;
            List<String> tmp_tier2;
            List<String> tmp_tier1;
            if (this.knowledge.getTier(i).size() == 1) continue;
            if (indx_tier >= indy_tier) {
                tmp_tier1 = this.knowledge.getTier(i + tier_diff);
                tmp_tier2 = this.knowledge.getTier(i);
                A = tmp_tier1.get(indx_comp);
                if (A.equals(B = tmp_tier2.get(indy_comp)) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp))) continue;
                x1 = test.getVariable(A);
                y1 = test.getVariable(B);
                adjacencies.get(x1).remove(y1);
                adjacencies.get(y1).remove(x1);
                System.out.println("removed edge between " + x1 + " and " + y1 + " because of structure knowledge");
                condSetAB = new HashSet<Node>();
                for (Node tempNode : condSet) {
                    ind_temptier = this.knowledge.isInWhichTier(tempNode);
                    temptier = this.knowledge.getTier(ind_temptier);
                    ind_temp = -1;
                    for (j = 0; j < temptier.size(); ++j) {
                        if (!this.getNameNoLag(tempNode.getName()).equals(this.getNameNoLag(temptier.get(j)))) continue;
                        ind_temp = j;
                        break;
                    }
                    cond_diff = indx_tier - ind_temptier;
                    condAB_tier = this.knowledge.isInWhichTier(x1) - cond_diff;
                    if (condAB_tier < 0 || condAB_tier > ntiers - 1 || this.knowledge.getTier(condAB_tier).size() == 1) {
                        System.out.println("Warning: For nodes " + x1 + "," + y1 + " the conditioning variable is outside of window, so not added to SepSet");
                        continue;
                    }
                    new_tier = this.knowledge.getTier(condAB_tier);
                    tempNode1 = new_tier.get(ind_temp);
                    System.out.println("adding variable " + tempNode1 + " to SepSet");
                    condSetAB.add(test.getVariable(tempNode1));
                }
                System.out.println("done");
                this.getSepsets().set(x1, y1, condSetAB);
                continue;
            }
            tmp_tier1 = this.knowledge.getTier(i);
            tmp_tier2 = this.knowledge.getTier(i + tier_diff);
            A = tmp_tier1.get(indx_comp);
            if (A.equals(B = tmp_tier2.get(indy_comp)) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp))) continue;
            x1 = test.getVariable(A);
            y1 = test.getVariable(B);
            adjacencies.get(x1).remove(y1);
            adjacencies.get(y1).remove(x1);
            System.out.println("removed edge between " + x1 + " and " + y1 + " because of structure knowledge");
            condSetAB = new HashSet();
            for (Node tempNode : condSet) {
                ind_temptier = this.knowledge.isInWhichTier(tempNode);
                temptier = this.knowledge.getTier(ind_temptier);
                ind_temp = -1;
                for (j = 0; j < temptier.size(); ++j) {
                    if (!this.getNameNoLag(tempNode.getName()).equals(this.getNameNoLag(temptier.get(j)))) continue;
                    ind_temp = j;
                    break;
                }
                cond_diff = indx_tier - ind_temptier;
                condAB_tier = this.knowledge.isInWhichTier(x1) - cond_diff;
                if (condAB_tier < 0 || condAB_tier > ntiers - 1 || this.knowledge.getTier(condAB_tier).size() == 1) {
                    System.out.println("Warning: For nodes " + x1 + "," + y1 + " the conditioning variable is outside of window, so not added to SepSet");
                    continue;
                }
                new_tier = this.knowledge.getTier(condAB_tier);
                tempNode1 = new_tier.get(ind_temp);
                System.out.println("adding variable " + tempNode1 + " to SepSet");
                condSetAB.add(test.getVariable(tempNode1));
            }
            System.out.println("done");
            this.getSepsets().set(x1, y1, condSetAB);
        }
    }

    private List<List<Node>> returnSimilarPairs(IndependenceTest test, Node x, Node y) {
        int i;
        System.out.println("$$$$$ Entering returnSimilarPairs method with x,y = " + x + ", " + y);
        if (x.getName().equals("time") || y.getName().equals("time")) {
            return new ArrayList<List<Node>>();
        }
        int ntiers = this.knowledge.getNumTiers();
        int indx_tier = this.knowledge.isInWhichTier(x);
        int indy_tier = this.knowledge.isInWhichTier(y);
        int tier_diff = FastMath.max(indx_tier, indy_tier) - FastMath.min(indx_tier, indy_tier);
        int indx_comp = -1;
        int indy_comp = -1;
        List<String> tier_x = this.knowledge.getTier(indx_tier);
        List<String> tier_y = this.knowledge.getTier(indy_tier);
        for (i = 0; i < tier_x.size(); ++i) {
            if (!this.getNameNoLag(x.getName()).equals(this.getNameNoLag(tier_x.get(i)))) continue;
            indx_comp = i;
            break;
        }
        for (i = 0; i < tier_y.size(); ++i) {
            if (!this.getNameNoLag(y.getName()).equals(this.getNameNoLag(tier_y.get(i)))) continue;
            indy_comp = i;
            break;
        }
        System.out.println("original independence: " + x + " and " + y);
        if (indx_comp == -1) {
            System.out.println("WARNING: indx_comp = -1!!!! ");
        }
        if (indy_comp == -1) {
            System.out.println("WARNING: indy_comp = -1!!!! ");
        }
        ArrayList<Node> simListX = new ArrayList<Node>();
        ArrayList<Node> simListY = new ArrayList<Node>();
        for (i = 0; i < ntiers - tier_diff; ++i) {
            List<String> tmp_tier2;
            List<String> tmp_tier1;
            if (this.knowledge.getTier(i).size() == 1) continue;
            if (indx_tier >= indy_tier) {
                tmp_tier1 = this.knowledge.getTier(i + tier_diff);
                tmp_tier2 = this.knowledge.getTier(i);
            } else {
                tmp_tier1 = this.knowledge.getTier(i);
                tmp_tier2 = this.knowledge.getTier(i + tier_diff);
            }
            String A = tmp_tier1.get(indx_comp);
            String B = tmp_tier2.get(indy_comp);
            if (A.equals(B) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp))) continue;
            Node x1 = test.getVariable(A);
            Node y1 = test.getVariable(B);
            System.out.println("Adding pair to simList = " + x1 + " and " + y1);
            simListX.add(x1);
            simListY.add(y1);
        }
        ArrayList<List<Node>> pairList = new ArrayList<List<Node>>();
        pairList.add(simListX);
        pairList.add(simListY);
        return pairList;
    }

    private String getNameNoLag(Object obj) {
        String tempS = obj.toString();
        if (tempS.indexOf(58) == -1) {
            return tempS;
        }
        return tempS.substring(0, tempS.indexOf(58));
    }
}

