/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.score;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.score.SemBicScore;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.linear.BlockRealMatrix;

public class DegenerateGaussianScore
implements Score {
    private final List<Node> variables;
    private final Map<Integer, List<Integer>> embedding;
    private final SemBicScore bic;

    public DegenerateGaussianScore(DataSet dataSet, boolean precomputeCovariances) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.variables = dataSet.getVariables();
        int n = dataSet.getNumRows();
        this.embedding = new HashMap<Integer, List<Integer>>();
        ArrayList<Node> A = new ArrayList<Node>();
        ArrayList<double[]> B = new ArrayList<double[]>();
        int index = 0;
        int i = 0;
        for (int i_ = 0; i_ < this.variables.size(); ++i_) {
            Node v = this.variables.get(i_);
            if (v instanceof DiscreteVariable) {
                HashMap keys = new HashMap();
                HashMap keysReverse = new HashMap();
                for (int j = 0; j < n; ++j) {
                    ArrayList<Integer> key = new ArrayList<Integer>();
                    key.add(dataSet.getInt(j, i_));
                    if (!keys.containsKey(key)) {
                        keys.put(key, i);
                        keysReverse.put(i, key);
                        ContinuousVariable v_ = new ContinuousVariable("V__" + ++index);
                        A.add(v_);
                        B.add(new double[n]);
                        ++i;
                    }
                    ((double[])B.get((int)((Integer)keys.get(key)).intValue()))[j] = 1.0;
                }
                keys.remove(keysReverse.get(--i));
                A.remove(i);
                B.remove(i);
                this.embedding.put(i_, new ArrayList(keys.values()));
                continue;
            }
            A.add(v);
            double[] b = new double[n];
            for (int j = 0; j < n; ++j) {
                b[j] = dataSet.getDouble(j, i_);
            }
            B.add(b);
            ArrayList<Integer> index2 = new ArrayList<Integer>();
            index2.add(i);
            this.embedding.put(i_, index2);
            ++i;
        }
        double[][] B_ = new double[n][B.size()];
        for (int j = 0; j < B.size(); ++j) {
            for (int k = 0; k < n; ++k) {
                B_[k][j] = ((double[])B.get(j))[k];
            }
        }
        BlockRealMatrix D = new BlockRealMatrix(B_);
        this.bic = new SemBicScore(new BoxDataSet(new DoubleDataBox(D.getData()), A), precomputeCovariances);
        this.bic.setStructurePrior(0.0);
    }

    @Override
    public double localScore(int i, int ... parents) {
        double score = 0.0;
        ArrayList A = new ArrayList(this.embedding.get(i));
        ArrayList B = new ArrayList();
        for (int i_ : parents) {
            B.addAll(this.embedding.get(i_));
        }
        int[] parents_ = new int[B.size()];
        for (int i_ = 0; i_ < B.size(); ++i_) {
            parents_[i_] = (Integer)B.get(i_);
        }
        for (Integer i_ : A) {
            score += this.bic.localScore((int)i_, parents_);
        }
        return score;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return this.bic.isEffectEdge(bump);
    }

    @Override
    public int getSampleSize() {
        return this.bic.getSampleSize();
    }

    @Override
    public int getMaxDegree() {
        return this.bic.getMaxDegree();
    }

    @Override
    public String toString() {
        DecimalFormat nf = new DecimalFormat("0.00");
        return "Degenerate Gaussian Score Penalty " + nf.format(this.bic.getPenaltyDiscount());
    }

    public double getPenaltyDiscount() {
        return this.bic.getPenaltyDiscount();
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.bic.setPenaltyDiscount(penaltyDiscount);
    }
}

