/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.score;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.score.SemBicScore;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.Matrix;
import java.util.List;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public class EbicScore
implements Score {
    private final List<Node> variables;
    private final int sampleSize;
    private ICovarianceMatrix covariances;
    private double N;
    private Matrix data;
    private boolean calculateRowSubsets;
    private double gamma = 1.0;

    public EbicScore(ICovarianceMatrix covariances) {
        if (covariances == null) {
            throw new NullPointerException();
        }
        this.setCovariances(covariances);
        this.variables = covariances.getVariables();
        this.sampleSize = covariances.getSampleSize();
    }

    public EbicScore(DataSet dataSet, boolean precomputeCovariances) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.variables = dataSet.getVariables();
        this.sampleSize = dataSet.getNumRows();
        DataSet _dataSet = DataTransforms.center(dataSet);
        this.data = _dataSet.getDoubleData();
        if (!dataSet.existsMissingValue()) {
            this.setCovariances(SimpleDataLoader.getCovarianceMatrix(dataSet, precomputeCovariances));
            this.calculateRowSubsets = false;
        } else {
            this.calculateRowSubsets = true;
        }
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public double localScore(int i, int ... parents) throws RuntimeException {
        double varRy;
        int pi = parents.length;
        try {
            varRy = SemBicScore.getVarRy(i, parents, this.data, this.covariances, this.calculateRowSubsets);
        }
        catch (SingularMatrixException e) {
            throw new RuntimeException("Singularity encountered when scoring " + LogUtilsSearch.getScoreFact(i, parents, this.variables));
        }
        double gamma = this.gamma;
        double score = -(this.N * FastMath.log(varRy) + ((double)pi * FastMath.log(this.N) + (double)(2 * pi) * gamma * ChoiceGenerator.logCombinations(this.variables.size() - 1, pi)));
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.sampleSize));
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        int i = this.variables.indexOf(y);
        int[] k = this.indices(z);
        double v = this.localScore(i, k);
        return Double.isNaN(v);
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    private void setCovariances(ICovarianceMatrix covariances) {
        this.covariances = covariances;
        this.N = covariances.getSampleSize();
    }

    private int[] indices(List<Node> __adj) {
        int[] indices = new int[__adj.size()];
        for (int t = 0; t < __adj.size(); ++t) {
            indices[t] = this.variables.indexOf(__adj.get(t));
        }
        return indices;
    }
}

