/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.score;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.score.Score;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.help.UnsupportedOperationException;

public class GraphScore
implements Score {
    private final List<Node> variables;
    private Graph dag;
    private IndependenceFacts facts;
    private boolean verbose = false;
    private Node n = null;
    private List<Node> prefix = null;

    public GraphScore(Graph dag) {
        this.dag = dag;
        this.variables = new ArrayList<Node>(dag.getNodes());
        this.variables.removeIf(node -> node.getNodeType() == NodeType.LATENT);
    }

    public GraphScore(IndependenceFacts facts) {
        this.facts = facts;
        this.variables = new ArrayList<Node>(facts.getVariables());
        this.variables.removeIf(node -> node.getNodeType() == NodeType.LATENT);
    }

    @Override
    public double localScore(int y, int[] z) {
        return this.getPearlParentsTest().size();
    }

    private Set<Node> getPearlParentsTest() {
        HashSet<Node> mb = new HashSet<Node>();
        for (Node z0 : this.prefix) {
            HashSet<Node> cond = new HashSet<Node>(this.prefix);
            cond.remove(z0);
            if (!this.dag.paths().isMConnectedTo(this.n, z0, cond)) continue;
            mb.add(z0);
        }
        return mb;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.locallyConsistentScoringCriterion(x, y, z);
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScoreDiff(x, y, new int[0]);
    }

    @Override
    public double localScore(int i, int parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double localScore(int i) {
        throw new UnsupportedOperationException("The 'local score' method is not supported here.");
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    public DataSet getDataSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getMaxDegree() {
        return 1000;
    }

    public DataModel getData() {
        throw new UnsupportedOperationException("This score does not use data.");
    }

    @Override
    public int getSampleSize() {
        throw new UnsupportedOperationException("This score does not use data, so no sample size is available.");
    }

    public Graph getDag() {
        return new EdgeListGraph(this.dag);
    }

    private double locallyConsistentScoringCriterion(int x, int y, int[] z) {
        boolean dSeparatedFrom;
        Node _y = this.variables.get(y);
        Node _x = this.variables.get(x);
        Set<Node> _z = this.getVariableSet(z);
        if (this.dag != null) {
            dSeparatedFrom = this.dag.paths().isMSeparatedFrom(_x, _y, _z);
        } else if (this.facts != null) {
            dSeparatedFrom = this.facts.isIndependent(_x, _y, _z);
        } else {
            throw new IllegalStateException("Expecting either a graph or a IndependenceFacts object.");
        }
        return dSeparatedFrom ? -1.0 : 1.0;
    }

    private boolean isMSeparatedFrom(Node x, Node y, Set<Node> z) {
        if (this.dag != null) {
            return this.dag.paths().isMSeparatedFrom(x, y, z);
        }
        if (this.facts != null) {
            return this.facts.isIndependent(x, y, z);
        }
        throw new IllegalArgumentException("Expecting either a DAG or an IndependenceFacts object.");
    }

    private boolean isMConnectedTo(Node x, Node y, Set<Node> z) {
        return !this.isMSeparatedFrom(x, y, z);
    }

    private List<Node> getVariableList(int[] indices) {
        ArrayList<Node> variables = new ArrayList<Node>();
        for (int i : indices) {
            variables.add(this.variables.get(i));
        }
        return variables;
    }

    private Set<Node> getVariableSet(int[] indices) {
        HashSet<Node> variables = new HashSet<Node>();
        for (int i : indices) {
            variables.add(this.variables.get(i));
        }
        return variables;
    }
}

