/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.score;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.Score;
import java.util.List;

public class ImagesScore
implements Score {
    private final List<Score> scores;
    private final List<Node> variables;

    public ImagesScore(List<Score> scores) {
        if (scores == null) {
            throw new NullPointerException();
        }
        this.scores = scores;
        this.variables = scores.get(0).getVariables();
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        double sum = 0.0;
        int count = 0;
        for (Score score : this.scores) {
            double _score = score.localScoreDiff(x, y, z);
            if (!Double.isNaN(_score)) continue;
            sum += _score;
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double localScore(int i, int[] parents) {
        double sum = 0.0;
        int count = 0;
        for (Score score : this.scores) {
            double _score = score.localScore(i, parents);
            if (Double.isNaN(_score)) continue;
            sum += _score;
            ++count;
        }
        double score = sum / (double)count;
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    public double localScore(int i, int[] parents, int index) {
        return this.localScoreOneDataSet(i, parents, index);
    }

    @Override
    public double localScore(int i, int parent) {
        double sum = 0.0;
        int count = 0;
        for (Score score : this.scores) {
            double _score = score.localScore(i, parent);
            if (Double.isNaN(_score)) continue;
            sum += _score;
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double localScore(int i) {
        double sum = 0.0;
        int count = 0;
        for (Score score : this.scores) {
            double _score = score.localScore(i);
            if (Double.isNaN(_score)) continue;
            sum += _score;
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return this.scores.get(0).isEffectEdge(bump);
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getSampleSize() {
        return this.scores.get(0).getSampleSize();
    }

    @Override
    public int getMaxDegree() {
        return this.scores.get(0).getMaxDegree();
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return this.scores.get(0).determines(z, y);
    }

    private double localScoreOneDataSet(int i, int[] parents, int index) {
        return this.scores.get(index).localScore(i, parents);
    }
}

