/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.score;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.test.IndependenceResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class IndTestScore
implements Score {
    private final IndependenceTest test;
    private final List<Node> variables = new ArrayList<Node>();
    private boolean verbose;

    public IndTestScore(IndependenceTest test) {
        for (Node node : test.getVariables()) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            this.variables.add(node);
        }
        this.test = test;
    }

    @Override
    public double localScore(int i, int[] parents) {
        throw new UnsupportedOperationException();
    }

    private List<Node> getVariableList(int[] indices) {
        ArrayList<Node> variables = new ArrayList<Node>();
        for (int i : indices) {
            variables.add(this.variables.get(i));
        }
        return variables;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        IndependenceResult result = this.test.checkIndependence(this.variables.get(x), this.variables.get(y), new HashSet<Node>(this.getVariableList(z)));
        return result.getScore();
    }

    @Override
    public double localScore(int i, int parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double localScore(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return true;
    }

    public DataSet getDataSet() {
        throw new UnsupportedOperationException();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public int getMaxDegree() {
        return 1000;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }
}

