/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.score;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.MvpLikelihood;
import edu.cmu.tetrad.search.score.Score;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class MvpScore
implements Score {
    private final DataSet dataSet;
    private final List<Node> variables;
    private final MvpLikelihood likelihood;
    private final double logn;

    public MvpScore(DataSet dataSet, double structurePrior, int fDegree, boolean discretize) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.variables = dataSet.getVariables();
        this.likelihood = new MvpLikelihood(dataSet, structurePrior, fDegree, discretize);
        this.logn = FastMath.log(dataSet.getNumRows());
    }

    @Override
    public double localScore(int i, int ... parents) {
        double score;
        double lik = this.likelihood.getLik(i, parents);
        double dof = this.likelihood.getDoF(i, parents);
        double sp = this.likelihood.getStructurePrior(parents.length);
        if (sp > 0.0) {
            sp = -2.0 * dof * sp;
        }
        if (Double.isNaN(score = 2.0 * lik - dof * this.logn + sp) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public int getSampleSize() {
        return this.dataSet.getNumRows();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.dataSet.getNumRows()));
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }
}

