/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.score;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.score.SemBicScore;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.Matrix;
import java.util.List;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class PoissonPriorScore
implements Score {
    private final List<Node> variables;
    private final int sampleSize;
    private DataSet dataSet;
    private ICovarianceMatrix covariances;
    private boolean verbose;
    private double N;
    private Matrix data;
    private boolean calculateRowSubsets;
    private double lambda = 3.0;

    public PoissonPriorScore(ICovarianceMatrix covariances) {
        if (covariances == null) {
            throw new NullPointerException();
        }
        this.setCovariances(covariances);
        this.variables = covariances.getVariables();
        this.sampleSize = covariances.getSampleSize();
    }

    public PoissonPriorScore(DataSet dataSet, boolean precomputeCovariances) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.variables = dataSet.getVariables();
        this.sampleSize = dataSet.getNumRows();
        DataSet _dataSet = DataTransforms.center(dataSet);
        this.data = _dataSet.getDoubleData();
        if (!dataSet.existsMissingValue()) {
            this.setCovariances(SimpleDataLoader.getCovarianceMatrix(dataSet, precomputeCovariances));
            this.calculateRowSubsets = false;
        } else {
            this.calculateRowSubsets = true;
        }
    }

    private static double getP(int pn, int m0, double lambda) {
        return 2.0 - FastMath.pow(1.0 + FastMath.exp(-(lambda - 1.0) / 2.0) * FastMath.sqrt(lambda), (double)pn - (double)m0);
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public double localScore(int i, int ... parents) throws RuntimeException {
        double varRy;
        int pi = parents.length + 1;
        int k = parents.length;
        try {
            varRy = SemBicScore.getVarRy(i, parents, this.data, this.covariances, this.calculateRowSubsets);
        }
        catch (SingularMatrixException e) {
            throw new RuntimeException("Singularity encountered when scoring " + LogUtilsSearch.getScoreFact(i, parents, this.variables));
        }
        double r = (double)k * FastMath.log(this.lambda);
        double score = -0.5 * this.N * FastMath.log(varRy) - 0.5 * (double)k * FastMath.log(this.N) + r - Gamma.logGamma((double)k + 1.0);
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    public ICovarianceMatrix getCovariances() {
        return this.covariances;
    }

    private void setCovariances(ICovarianceMatrix covariances) {
        CorrelationMatrix correlations = new CorrelationMatrix(covariances);
        this.covariances = covariances;
        boolean exists = false;
        double correlationThreshold = 1.0;
        for (int i = 0; i < correlations.getSize(); ++i) {
            for (int j = 0; j < correlations.getSize(); ++j) {
                double r;
                if (i == j || !(FastMath.abs(r = correlations.getValue(i, j)) > correlationThreshold)) continue;
                System.out.println("Absolute correlation too high: " + r);
                exists = true;
            }
        }
        if (exists) {
            throw new IllegalArgumentException("Some correlations are too high (> " + correlationThreshold + ") in absolute value.");
        }
        this.N = covariances.getSampleSize();
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.sampleSize));
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        int i = this.variables.indexOf(y);
        int[] k = this.indices(z);
        double v = this.localScore(i, k);
        return Double.isNaN(v);
    }

    public DataModel getData() {
        return this.dataSet;
    }

    public void setLambda(double lambda) {
        if (lambda < 1.0) {
            throw new IllegalArgumentException("Poisso lambda can't be < 1: " + lambda);
        }
        this.lambda = lambda;
    }

    private int[] indices(List<Node> __adj) {
        int[] indices = new int[__adj.size()];
        for (int t = 0; t < __adj.size(); ++t) {
            indices[t] = this.variables.indexOf(__adj.get(t));
        }
        return indices;
    }
}

