/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.score;

import edu.cmu.tetrad.graph.Node;
import java.util.List;

public interface Score {
    public double localScore(int var1, int ... var2);

    public List<Node> getVariables();

    public int getSampleSize();

    public String toString();

    default public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    default public int[] append(int[] parents, int extra) {
        int[] all = new int[parents.length + 1];
        System.arraycopy(parents, 0, all, 0, parents.length);
        all[parents.length] = extra;
        return all;
    }

    default public double localScoreDiff(int x, int y) {
        return this.localScore(y, x) - this.localScore(y);
    }

    default public double localScore(int node, int parent) {
        return this.localScore(node, new int[]{parent});
    }

    default public double localScore(int node) {
        return this.localScore(node, new int[0]);
    }

    default public Node getVariable(String targetName) {
        for (Node node : this.getVariables()) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    default public boolean isEffectEdge(double bump) {
        return false;
    }

    default public int getMaxDegree() {
        return 1000;
    }

    default public boolean determines(List<Node> z, Node y) {
        throw new UnsupportedOperationException("Method determines() is not implemented for this score.");
    }
}

