/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.CellTable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.util.CombinationIterator;
import java.util.Arrays;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.util.FastMath;

public class ChiSquareTest {
    private final DataSet dataSet;
    private final int[] dims;
    private final CellTable cellTable;
    private double alpha;

    public ChiSquareTest(DataSet dataSet, double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance level must be in [0, 1]: " + alpha);
        }
        this.dims = new int[dataSet.getNumColumns()];
        for (int i = 0; i < this.getDims().length; ++i) {
            DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(i);
            this.getDims()[i] = variable.getNumCategories();
        }
        this.dataSet = dataSet;
        this.alpha = alpha;
        this.cellTable = new CellTable(null);
        this.getCellTable().setMissingValue(-99);
    }

    public Result calcChiSquare(int[] testIndices) {
        this.getCellTable().addToTable(this.getDataSet(), testIndices);
        int[] firstVar = new int[]{0};
        int[] secondVar = new int[]{1};
        int[] bothVars = new int[]{0, 1};
        double xSquare = 0.0;
        int df = 0;
        int[] condDims = new int[testIndices.length - 2];
        System.arraycopy(this.selectFromArray(this.getDims(), testIndices), 2, condDims, 0, condDims.length);
        int[] coords = new int[testIndices.length];
        int numRows = this.getCellTable().getNumValues(0);
        int numCols = this.getCellTable().getNumValues(1);
        CombinationIterator combinationIterator = new CombinationIterator(condDims);
        while (combinationIterator.hasNext()) {
            boolean[] attestedRows = new boolean[numRows];
            boolean[] attestedCols = new boolean[numCols];
            Arrays.fill(attestedRows, true);
            Arrays.fill(attestedCols, true);
            int[] combination = combinationIterator.next();
            System.arraycopy(combination, 0, coords, 2, combination.length);
            long total = this.getCellTable().calcMargin(coords, bothVars);
            if (total == 0L) continue;
            double _xSquare = 0.0;
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    coords[0] = i;
                    coords[1] = j;
                    long sumRow = this.getCellTable().calcMargin(coords, firstVar);
                    long sumCol = this.getCellTable().calcMargin(coords, secondVar);
                    long observed = this.getCellTable().getValue(coords);
                    if (sumRow == 0L) {
                        attestedRows[i] = false;
                        continue;
                    }
                    if (sumCol == 0L) {
                        attestedCols[j] = false;
                        continue;
                    }
                    double expected = (double)(sumRow * sumCol) / (double)total;
                    _xSquare += FastMath.pow((double)observed - expected, 2.0) / expected;
                }
            }
            int numAttestedRows = 0;
            int numAttestedCols = 0;
            for (boolean attestedRow : attestedRows) {
                if (!attestedRow) continue;
                ++numAttestedRows;
            }
            for (boolean attestedCol : attestedCols) {
                if (!attestedCol) continue;
                ++numAttestedCols;
            }
            if (numAttestedRows <= 0 || numAttestedCols <= 0) continue;
            df += (numAttestedRows - 1) * (numAttestedCols - 1);
            xSquare += _xSquare;
        }
        if (df == 0) {
            double pValue = 1.0;
            return new Result(xSquare, 1.0, 0, true);
        }
        double pValue = 1.0 - new ChiSquaredDistribution(df).cumulativeProbability(xSquare);
        boolean indep = pValue > this.getAlpha();
        return new Result(xSquare, pValue, df, indep);
    }

    public boolean isDetermined(int[] testIndices, double p) {
        this.getCellTable().addToTable(this.getDataSet(), testIndices);
        int[] firstVar = new int[]{0};
        int[] condDims = new int[testIndices.length - 1];
        System.arraycopy(this.selectFromArray(this.getDims(), testIndices), 1, condDims, 0, condDims.length);
        int[] coords = new int[testIndices.length];
        int numValues = this.getCellTable().getNumValues(0);
        CombinationIterator combinationIterator = new CombinationIterator(condDims);
        while (combinationIterator.hasNext()) {
            int[] combination = combinationIterator.next();
            System.arraycopy(combination, 0, coords, 1, combination.length);
            long total = this.getCellTable().calcMargin(coords, firstVar);
            if (total == 0L) continue;
            boolean dominates = false;
            for (int i = 0; i < numValues; ++i) {
                coords[0] = i;
                long numi = this.getCellTable().getValue(coords);
                if (!((double)numi / (double)total >= p)) continue;
                dominates = true;
            }
            if (dominates) continue;
            return false;
        }
        return true;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance level must be in [0, 1]: " + alpha);
        }
        this.alpha = alpha;
    }

    private int[] selectFromArray(int[] arr, int[] indices) {
        int[] retArr = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            retArr[i] = arr[indices[i]];
        }
        return retArr;
    }

    private DataSet getDataSet() {
        return this.dataSet;
    }

    private int[] getDims() {
        return this.dims;
    }

    private CellTable getCellTable() {
        return this.cellTable;
    }

    public static class Result {
        private final double chiSquare;
        private final double pValue;
        private final int df;
        private final boolean isIndep;

        public Result(double chiSquare, double pValue, int df, boolean isIndep) {
            this.chiSquare = chiSquare;
            this.pValue = pValue;
            this.df = df;
            this.isIndep = isIndep;
        }

        public double getXSquare() {
            return this.chiSquare;
        }

        public double getPValue() {
            return this.pValue;
        }

        public int getDf() {
            return this.df;
        }

        public boolean isIndep() {
            return this.isIndep;
        }
    }
}

