/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.ConditionalCorrelationIndependence;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class IndTestConditionalCorrelation
implements IndependenceTest {
    private static final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private final ConditionalCorrelationIndependence cci;
    private final List<Node> variables;
    private final DataSet dataSet;
    private double alpha;
    private boolean verbose;
    private double score = Double.NaN;

    public IndTestConditionalCorrelation(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        if (!(alpha >= 0.0) || !(alpha <= 1.0)) {
            throw new IllegalArgumentException("Q mut be in [0, 1]");
        }
        List<Node> nodes = dataSet.getVariables();
        this.variables = Collections.unmodifiableList(nodes);
        this.cci = new ConditionalCorrelationIndependence(dataSet);
        this.alpha = alpha;
        this.dataSet = dataSet;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> z) {
        boolean independent;
        double score;
        this.score = score = this.cci.isIndependent(x, y, z);
        double p = this.cci.getPValue(score);
        if (Double.isNaN(p)) {
            throw new RuntimeException("Undefined p-value encountered for test: " + LogUtilsSearch.independenceFact(x, y, z));
        }
        boolean bl = independent = p > this.alpha;
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFactMsg(x, y, z, p));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, p, this.alpha - p);
    }

    public double getPValue() {
        return this.cci.getPValue(this.score);
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
        this.cci.setAlpha(alpha);
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The 'determines' method is not implemented");
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public String toString() {
        return "Conditional Correlation, q = " + nf.format(this.getAlpha());
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNumFunctions(int numFunctions) {
        this.cci.setNumFunctions(numFunctions);
    }

    public double getWidth() {
        return this.cci.getWidth();
    }

    public void setKernelMultiplier(double multiplier) {
        this.cci.setWidth(multiplier);
    }

    public void setKernel(ConditionalCorrelationIndependence.Kernel kernel) {
        this.cci.setKernelMultiplier(kernel);
    }

    public void setBasis(ConditionalCorrelationIndependence.Basis basis) {
        this.cci.setBasis(basis);
    }

    public void setKernelRegressionSampleSize(int size) {
        this.cci.setKernelRegressionSampleSize(size);
    }
}

