/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndTestFisherZ;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public final class IndTestFisherZFisherPValue
implements IndependenceTest {
    private final List<Node> variables;
    private final int sampleSize;
    private final List<DataSet> dataSets;
    private final List<ICovarianceMatrix> ncov;
    private final Map<Node, Integer> variablesMap;
    private double alpha;
    private double pValue = Double.NaN;
    private boolean verbose;

    public IndTestFisherZFisherPValue(List<DataSet> dataSets, double alpha) {
        this.sampleSize = dataSets.get(0).getNumRows();
        this.setAlpha(alpha);
        this.ncov = new ArrayList<ICovarianceMatrix>();
        for (DataSet dataSet : dataSets) {
            this.ncov.add(new CovarianceMatrix(dataSet));
        }
        this.variables = dataSets.get(0).getVariables();
        this.variablesMap = new HashMap<Node, Integer>();
        for (int i = 0; i < this.variables.size(); ++i) {
            this.variablesMap.put(this.variables.get(i), i);
        }
        for (DataSet dataSet : dataSets) {
            new ArrayList<IndTestFisherZ>().add(new IndTestFisherZ(dataSet, alpha));
        }
        this.dataSets = dataSets;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> _z) {
        try {
            boolean independent;
            ArrayList z = new ArrayList();
            Collections.sort(z);
            int[] all = new int[z.size() + 2];
            all[0] = this.variablesMap.get(x);
            all[1] = this.variablesMap.get(y);
            for (int i = 0; i < z.size(); ++i) {
                all[i + 2] = this.variablesMap.get(z.get(i));
            }
            ArrayList<Double> pValues = new ArrayList<Double>();
            for (ICovarianceMatrix iCovarianceMatrix : this.ncov) {
                Matrix _ncov = iCovarianceMatrix.getSelection(all, all);
                Matrix inv = _ncov.inverse();
                double r = -inv.get(0, 1) / FastMath.sqrt(inv.get(0, 0) * inv.get(1, 1));
                double __z = FastMath.sqrt((double)(this.sampleSize - z.size()) - 3.0) * 0.5 * (FastMath.log(1.0 + r) - FastMath.log(1.0 - r));
                double pvalue = 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, FastMath.abs(__z)));
                pValues.add(pvalue);
            }
            Collections.sort(pValues);
            int n = 0;
            double tf = 0.0;
            int numZeros = 0;
            Iterator r = pValues.iterator();
            while (r.hasNext()) {
                double p = (Double)r.next();
                if (p == 0.0) {
                    ++numZeros;
                    continue;
                }
                tf += -2.0 * FastMath.log(p);
                ++n;
            }
            if (numZeros >= pValues.size() / 2) {
                return new IndependenceResult(new IndependenceFact(x, y, _z), false, Double.NaN, Double.NaN);
            }
            if (tf == 0.0) {
                throw new IllegalArgumentException("For the Fisher method, all component p values in the calculation may not be zero, \nsince not all p values can be ignored. Maybe try calculating AR residuals.");
            }
            double p = 1.0 - ProbUtils.chisqCdf(tf, 2 * n);
            if (Double.isNaN(p)) {
                throw new RuntimeException("Undefined p-value encountered for test: " + LogUtilsSearch.independenceFact(x, y, _z));
            }
            this.pValue = p;
            boolean bl = independent = p > this.alpha;
            if (this.verbose && independent) {
                TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFactMsg(x, y, _z, this.pValue));
            }
            return new IndependenceResult(new IndependenceFact(x, y, _z), independent, p, this.getAlpha() - p);
        }
        catch (SingularMatrixException e) {
            throw new RuntimeException("Singularity encountered when testing " + LogUtilsSearch.independenceFact(x, y, _z));
        }
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSet getData() {
        return DataTransforms.concatenate(this.dataSets);
    }

    @Override
    public ICovarianceMatrix getCov() {
        ArrayList<DataSet> _dataSets = new ArrayList<DataSet>();
        for (DataSet d : this.dataSets) {
            _dataSets.add(DataTransforms.standardizeData(d));
        }
        return new CovarianceMatrix(DataTransforms.concatenate(_dataSets));
    }

    @Override
    public String toString() {
        return "Fisher Z, Fisher P Value Percent = " + FastMath.round(50.0);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

