/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.GSquareTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class IndTestGSquare
implements IndependenceTest {
    private static final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private final GSquareTest gSquareTest;
    private final List<Node> variables;
    private final DataSet dataSet;
    private final double alpha;
    private double pValue;
    private double determinationP = 0.99;
    private boolean verbose;

    public IndTestGSquare(DataSet dataSet, double alpha) {
        this.dataSet = dataSet;
        this.alpha = alpha;
        this.variables = new ArrayList<Node>(dataSet.getVariables());
        this.gSquareTest = new GSquareTest(dataSet, alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        int[] indices = new int[vars.size()];
        int j = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!vars.contains(this.variables.get(i))) continue;
            indices[++j] = i;
        }
        DataSet newDataSet = this.dataSet.subsetColumns(indices);
        return new IndTestGSquare(newDataSet, this.alpha);
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> _z) {
        int i;
        if (x == null) {
            throw new NullPointerException();
        }
        if (y == null) {
            throw new NullPointerException();
        }
        if (_z == null) {
            throw new NullPointerException();
        }
        for (Node node : _z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        ArrayList<Node> z = new ArrayList<Node>(_z);
        Collections.sort(z);
        int[] testIndices = new int[2 + z.size()];
        testIndices[0] = this.variables.indexOf(x);
        testIndices[1] = this.variables.indexOf(y);
        for (i = 0; i < z.size(); ++i) {
            testIndices[i + 2] = this.variables.indexOf(z.get(i));
        }
        for (i = 0; i < testIndices.length; ++i) {
            if (testIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Variable " + i + " was not used in the constructor.");
        }
        GSquareTest.Result result = this.gSquareTest.calcGSquare(testIndices);
        this.pValue = result.getPValue();
        if (Double.isNaN(this.pValue)) {
            throw new RuntimeException("Undefined p-value encountered when testing " + LogUtilsSearch.independenceFact(x, y, _z));
        }
        if (this.verbose && result.isIndep()) {
            TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFactMsg(x, y, _z, this.getPValue()));
        }
        return new IndependenceResult(new IndependenceFact(x, y, _z), result.isIndep(), result.getPValue(), this.alpha - result.getPValue());
    }

    @Override
    public double getAlpha() {
        return this.gSquareTest.getAlpha();
    }

    @Override
    public void setAlpha(double alpha) {
        this.gSquareTest.setAlpha(alpha);
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    @Override
    public String toString() {
        return "G Square, alpha = " + nf.format(this.getAlpha());
    }

    @Override
    public boolean determines(Set<Node> _z, Node x) {
        int i;
        if (_z == null) {
            throw new NullPointerException();
        }
        for (Node node : _z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        ArrayList<Node> z = new ArrayList<Node>(_z);
        Collections.sort(z);
        int[] testIndices = new int[1 + z.size()];
        testIndices[0] = this.variables.indexOf(x);
        for (i = 0; i < z.size(); ++i) {
            testIndices[i + 1] = this.variables.indexOf(z.get(i));
        }
        for (i = 0; i < testIndices.length; ++i) {
            if (testIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Variable " + i + "was not used in the constructor.");
        }
        boolean determined = this.gSquareTest.isDetermined(testIndices, this.determinationP);
        if (determined) {
            StringBuilder sb = new StringBuilder();
            sb.append("Determination found: ").append(x).append(" is determined by {");
            for (int i2 = 0; i2 < z.size(); ++i2) {
                sb.append(z.get(i2));
                if (i2 >= z.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            TetradLogger.getInstance().log("independencies", sb.toString());
        }
        return determined;
    }

    public void setDeterminationP(double determinationP) {
        this.determinationP = determinationP;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

