/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class IndTestIndependenceFacts
implements IndependenceTest {
    private final IndependenceFacts facts;
    private boolean verbose;

    public IndTestIndependenceFacts(IndependenceFacts facts) {
        this.facts = facts;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new javax.help.UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> __z) {
        ArrayList<Node> z = new ArrayList<Node>(__z);
        Collections.sort(z);
        Node[] _z = new Node[__z.size()];
        for (int i = 0; i < z.size(); ++i) {
            _z[i] = (Node)z.get(i);
        }
        boolean independent = this.facts.isIndependent(x, y, _z);
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFactMsg(x, y, __z, this.getPValue()));
        }
        return new IndependenceResult(new IndependenceFact(x, y, __z), independent, this.getPValue(), this.getAlpha() - this.getPValue());
    }

    public double getPValue() {
        return Double.NaN;
    }

    @Override
    public List<Node> getVariables() {
        return this.facts.getVariables();
    }

    @Override
    public Node getVariable(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        List<Node> variables = this.facts.getVariables();
        for (Node node : variables) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    public boolean determines(List<Node> z, Node y) {
        throw new javax.help.UnsupportedOperationException("Method not implmeented.");
    }

    @Override
    public double getAlpha() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public void setAlpha(double alpha) {
        throw new javax.help.UnsupportedOperationException();
    }

    @Override
    public DataModel getData() {
        return this.facts;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

