/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.ResolveSepsets;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IndTestMulti
implements IndependenceTest {
    private final List<Node> variables;
    private final List<IndependenceTest> independenceTests;
    private final ResolveSepsets.Method method;
    private boolean verbose;

    public IndTestMulti(List<IndependenceTest> independenceTests, ResolveSepsets.Method method) {
        HashSet<String> nodeNames = new HashSet<String>();
        for (IndependenceTest independenceTest : independenceTests) {
            nodeNames.addAll(independenceTest.getVariableNames());
        }
        if (independenceTests.iterator().next().getVariables().size() != nodeNames.size()) {
            throw new IllegalArgumentException("Data sets must have same variables.");
        }
        this.variables = independenceTests.iterator().next().getVariables();
        this.independenceTests = independenceTests;
        this.method = method;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> z) {
        boolean independent = ResolveSepsets.isIndependentPooled(this.method, this.independenceTests, x, y, z);
        if (independent) {
            TetradLogger.getInstance().log("independencies", "In aggregate independent: " + LogUtilsSearch.independenceFact(x, y, z));
        } else {
            TetradLogger.getInstance().log("dependencies", "In aggregate dependent: " + LogUtilsSearch.independenceFact(x, y, z));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, Double.NaN, Double.NaN);
    }

    @Override
    public double getAlpha() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAlpha(double alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSet getData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "Pooled Independence Test:  alpha = " + this.independenceTests.iterator().next().getAlpha();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

