/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MsepTest
implements IndependenceTest {
    private Map<Node, Set<Node>> ancestorMap;
    private IndependenceFacts independenceFacts;
    private Graph graph;
    private List<Node> observedVars;
    private List<Node> _observedVars;
    private boolean verbose = false;
    private double pvalue = 0.0;

    public MsepTest(Graph graph) {
        this(graph, false);
    }

    public MsepTest(IndependenceFacts facts, List<Node> variables) {
        this(facts, false);
        facts.setNodes(variables);
    }

    public MsepTest(IndependenceFacts facts) {
        this(facts, false);
    }

    public MsepTest(Graph graph, boolean keepLatents) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
        this.ancestorMap = graph.paths().getAncestorMap();
        this._observedVars = this.calcVars(graph.getNodes(), keepLatents);
        this.observedVars = new ArrayList<Node>(this._observedVars);
    }

    public MsepTest(IndependenceFacts facts, boolean keepLatents) {
        if (facts == null) {
            throw new NullPointerException();
        }
        this.independenceFacts = facts;
        this._observedVars = this.calcVars(facts.getVariables(), keepLatents);
        this.observedVars = new ArrayList<Node>(this._observedVars);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        ArrayList<Node> _vars = new ArrayList<Node>();
        for (Node var : vars) {
            Node _var = this.getVariable(var.getName());
            if (_var == null) {
                throw new IllegalArgumentException("All vars must be original vars");
            }
            _vars.add(_var);
        }
        this._observedVars = _vars;
        this.observedVars = new ArrayList<Node>(this._observedVars);
        return this;
    }

    private List<Node> calcVars(List<Node> nodes, boolean keepLatents) {
        if (keepLatents) {
            return nodes;
        }
        ArrayList<Node> _nodes = new ArrayList<Node>(nodes);
        _nodes.removeIf(node -> node.getNodeType() == NodeType.LATENT);
        return _nodes;
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        if (!this.observedVars.contains(x)) {
            throw new IllegalArgumentException("Not an observed variable: " + x);
        }
        if (!this.observedVars.contains(y)) {
            throw new IllegalArgumentException("Not an observed variable: " + y);
        }
        for (Node _z : z) {
            if (this.observedVars.contains(_z)) continue;
            throw new IllegalArgumentException("Not an observed variable: " + _z);
        }
        boolean mSeparated = this.graph != null ? !this.getGraph().paths().isMConnectedTo(x, y, z, this.ancestorMap) : this.independenceFacts.isIndependent(x, y, z);
        if (this.verbose && mSeparated) {
            TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFactMsg(x, y, z, 1.0));
        }
        double pValue = mSeparated ? 1.0 : 0.0;
        if (Double.isNaN(this.pvalue)) {
            throw new RuntimeException("Undefined p-value encountered when testing " + LogUtilsSearch.independenceFact(x, y, z));
        }
        this.pvalue = pValue;
        return new IndependenceResult(new IndependenceFact(x, y, z), mSeparated, pValue, this.pvalue == 1.0 ? -1.0 : 1.0);
    }

    public boolean isMSeparated(Node x, Node y, Set<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node aZ : z) {
            if (aZ != null) continue;
            throw new NullPointerException();
        }
        return this.getGraph().paths().isMSeparatedFrom(x, y, z);
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this._observedVars);
    }

    public boolean determines(List<Node> z, Node x1) {
        throw new UnsupportedOperationException("The 'determines' method is not implemented");
    }

    @Override
    public double getAlpha() {
        return 0.5;
    }

    @Override
    public void setAlpha(double alpha) {
        throw new UnsupportedOperationException("Method mot implemented.");
    }

    @Override
    public Node getVariable(String name) {
        for (Node variable : this.observedVars) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public String toString() {
        return "M-separation";
    }

    @Override
    public DataSet getData() {
        throw new UnsupportedOperationException("This is a m-separation test, no data available.");
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

