/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.score.SemBicScore;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ScoreIndTest
implements IndependenceTest {
    private final Score score;
    private final List<Node> variables;
    private final DataModel data;
    private double bump = Double.NaN;
    private boolean verbose;

    public ScoreIndTest(Score score) {
        this(score, null);
    }

    public ScoreIndTest(Score score, DataModel data) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.score = score;
        this.variables = score.getVariables();
        this.data = data;
    }

    @Override
    public ScoreIndTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> z) {
        boolean independent;
        ArrayList<Node> z1 = new ArrayList<Node>(z);
        Collections.sort(z1);
        double v = this.score.localScoreDiff(this.variables.indexOf(x), this.variables.indexOf(y), this.varIndices(z1));
        if (Double.isNaN(v)) {
            throw new RuntimeException("Undefined score bump encountered when testing " + LogUtilsSearch.independenceFact(x, y, z));
        }
        this.bump = v;
        int N = this.score.getSampleSize();
        boolean bl = independent = v <= 0.0;
        if (this.verbose && independent) {
            NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
            TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFact(x, y, z) + " score = " + nf.format(this.bump));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, v, v);
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (Node node : this.variables) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public boolean determines(List<Node> z, Node y) {
        return this.score.determines(z, y);
    }

    @Override
    public double getAlpha() {
        return -1.0;
    }

    @Override
    public void setAlpha(double alpha) {
    }

    @Override
    public DataModel getData() {
        return this.data;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return ((SemBicScore)this.score).getCovariances();
    }

    @Override
    public List<DataSet> getDataSets() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public int getSampleSize() {
        return this.score.getSampleSize();
    }

    public Score getWrappedScore() {
        return this.score;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return this.score.toString() + " Interpreted as a Test";
    }

    private int[] varIndices(List<Node> z) {
        int[] indices = new int[z.size()];
        for (int i = 0; i < z.size(); ++i) {
            indices[i] = this.variables.indexOf(z.get(i));
        }
        return indices;
    }
}

