/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;

public class BayesImParser {
    private boolean useDisplayNames;

    public void setUseDisplayNames(boolean useDisplayNames) {
        this.useDisplayNames = useDisplayNames;
    }

    public BayesIm getBayesIm(Element element) {
        if (!"smile".equals(element.getQualifiedName())) {
            throw new IllegalArgumentException("Expecting smile element.");
        }
        Elements elements = element.getChildElements();
        Element element0 = null;
        Element element1 = null;
        for (int i = 0; i < elements.size(); ++i) {
            Element _element = elements.get(i);
            if ("nodes".equals(_element.getQualifiedName())) {
                element0 = _element;
            }
            if (!"extensions".equals(_element.getQualifiedName())) continue;
            element1 = _element.getFirstChildElement("genie");
        }
        Map<String, String> displayNames = this.mapDisplayNames(element1, this.useDisplayNames);
        assert (element0 != null);
        return this.buildIM(element0, displayNames);
    }

    private BayesIm buildIM(Element element0, Map<String, String> displayNames) {
        Element cpt;
        int i;
        Elements elements = element0.getChildElements();
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            if ("cpt".equals(elements.get(i2).getQualifiedName())) continue;
            throw new IllegalArgumentException("Expecting cpt element.");
        }
        Dag dag = new Dag();
        for (i = 0; i < elements.size(); ++i) {
            cpt = elements.get(i);
            String name = cpt.getAttribute(0).getValue();
            if (displayNames == null) {
                dag.addNode(new GraphNode(name));
                continue;
            }
            dag.addNode(new GraphNode(displayNames.get(name)));
        }
        for (i = 0; i < elements.size(); ++i) {
            cpt = elements.get(i);
            Elements cptElements = cpt.getChildElements();
            for (int j = 0; j < cptElements.size(); ++j) {
                String[] parentNames;
                Element cptElement = cptElements.get(j);
                if (!cptElement.getQualifiedName().equals("parents")) continue;
                String list = cptElement.getValue();
                for (String name : parentNames = list.split(" ")) {
                    Node child;
                    Node parent;
                    if (displayNames == null) {
                        parent = dag.getNode(name);
                        child = dag.getNode(cpt.getAttribute(0).getValue());
                    } else {
                        parent = dag.getNode(displayNames.get(name));
                        child = dag.getNode(displayNames.get(cpt.getAttribute(0).getValue()));
                    }
                    dag.addDirectedEdge(parent, child);
                }
            }
            String name = displayNames == null ? cpt.getAttribute(0).getValue() : displayNames.get(cpt.getAttribute(0).getValue());
            dag.addNode(new GraphNode(name));
        }
        BayesPm pm = new BayesPm(dag);
        for (int i3 = 0; i3 < elements.size(); ++i3) {
            Element cpt2 = elements.get(i3);
            String varName = cpt2.getAttribute(0).getValue();
            Node node = displayNames == null ? dag.getNode(varName) : dag.getNode(displayNames.get(varName));
            Elements cptElements = cpt2.getChildElements();
            ArrayList<String> stateNames = new ArrayList<String>();
            for (int j = 0; j < cptElements.size(); ++j) {
                Element cptElement = cptElements.get(j);
                if (!cptElement.getQualifiedName().equals("state")) continue;
                Attribute attribute = cptElement.getAttribute(0);
                String stateName = attribute.getValue();
                stateNames.add(stateName);
            }
            pm.setCategories(node, stateNames);
        }
        MlBayesIm im = new MlBayesIm(pm);
        for (int nodeIndex = 0; nodeIndex < elements.size(); ++nodeIndex) {
            Element cpt3 = elements.get(nodeIndex);
            Elements cptElements = cpt3.getChildElements();
            for (int j = 0; j < cptElements.size(); ++j) {
                Element cptElement = cptElements.get(j);
                if (!cptElement.getQualifiedName().equals("probabilities")) continue;
                String list = cptElement.getValue();
                String[] probsStrings = list.split(" ");
                ArrayList<Double> probs = new ArrayList<Double>();
                for (String probString : probsStrings) {
                    probs.add(Double.parseDouble(probString));
                }
                int count = -1;
                for (int row = 0; row < im.getNumRows(nodeIndex); ++row) {
                    for (int col = 0; col < im.getNumColumns(nodeIndex); ++col) {
                        im.setProbability(nodeIndex, row, col, (Double)probs.get(++count));
                    }
                }
            }
        }
        return im;
    }

    private Map<String, String> mapDisplayNames(Element element1, boolean useDisplayNames) {
        if (useDisplayNames) {
            HashMap<String, String> displayNames = new HashMap<String, String>();
            Elements elements = element1.getChildElements();
            for (int i = 0; i < elements.size(); ++i) {
                Element nodeElement = elements.get(i);
                if (nodeElement.getLocalName().equals("textbox")) continue;
                String varName = nodeElement.getAttribute(0).getValue();
                Elements nodeElements = nodeElement.getChildElements();
                String displayName = null;
                for (int j = 0; j < nodeElements.size(); ++j) {
                    Element e = nodeElements.get(j);
                    if (!e.getQualifiedName().equals("name")) continue;
                    String value = e.getValue();
                    displayName = value = value.replace(" ", "_");
                    break;
                }
                displayNames.put(varName, displayName);
            }
            return displayNames;
        }
        return null;
    }
}

