/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ClusterUtils {
    public static final String LATENT_PREFIX = "_L";

    public static List<int[]> convertListToInt(List<List<Node>> partition, List<Node> nodes) {
        ArrayList<int[]> _partition = new ArrayList<int[]>();
        for (List<Node> cluster : partition) {
            int[] _cluster = new int[cluster.size()];
            for (int j = 0; j < cluster.size(); ++j) {
                for (int k = 0; k < nodes.size(); ++k) {
                    if (!nodes.get(k).getName().equals(cluster.get(j).getName())) continue;
                    _cluster[j] = k;
                }
            }
            _partition.add(_cluster);
        }
        return _partition;
    }

    static List<List<Node>> convertIntToList(List<int[]> partition, List<Node> nodes) {
        ArrayList<List<Node>> _partition = new ArrayList<List<Node>>();
        for (int[] cluster : partition) {
            ArrayList<Node> _cluster = new ArrayList<Node>();
            for (int aCluster : cluster) {
                _cluster.add(nodes.get(aCluster));
            }
            _partition.add(_cluster);
        }
        return _partition;
    }

    public static List<List<Node>> clustersToPartition(Clusters clusters, List<Node> variables) {
        ArrayList<List<Node>> inputPartition = new ArrayList<List<Node>>();
        for (int i = 0; i < clusters.getNumClusters(); ++i) {
            ArrayList<Node> cluster = new ArrayList<Node>();
            for (String nodeName : clusters.getCluster(i)) {
                for (Node variable : variables) {
                    if (!variable.getName().equals(nodeName)) continue;
                    cluster.add(variable);
                }
            }
            inputPartition.add(cluster);
        }
        return inputPartition;
    }

    public static Clusters partitionToClusters(List<List<Node>> partition) {
        Clusters clusters = new Clusters();
        for (int i = 0; i < partition.size(); ++i) {
            List<Node> cluster = partition.get(i);
            for (Node aCluster : cluster) {
                clusters.addToCluster(i, aCluster.getName());
            }
        }
        return clusters;
    }

    public static Graph convertSearchGraph(List<int[]> clusters, String[] varNames) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (clusters == null) {
            nodes.add(new GraphNode("No_model."));
            return new EdgeListGraph(nodes);
        }
        for (int i = 0; i < clusters.size(); ++i) {
            GraphNode latent = new GraphNode(LATENT_PREFIX + (i + 1));
            latent.setNodeType(NodeType.LATENT);
            nodes.add(latent);
        }
        for (int[] indicators : clusters) {
            for (int i : indicators) {
                String indicatorName = varNames[i];
                GraphNode indicator = new GraphNode(indicatorName);
                nodes.add(indicator);
            }
        }
        EdgeListGraph graph = new EdgeListGraph(nodes);
        int acc = clusters.size();
        for (int i = 0; i < clusters.size(); ++i) {
            int j;
            int[] indicators = clusters.get(i);
            for (j = 0; j < indicators.length; ++j) {
                graph.setEndpoint((Node)nodes.get(i), (Node)nodes.get(acc), Endpoint.ARROW);
                graph.setEndpoint((Node)nodes.get(acc), (Node)nodes.get(i), Endpoint.TAIL);
                ++acc;
            }
            for (j = i + 1; j < clusters.size(); ++j) {
                graph.setEndpoint((Node)nodes.get(i), (Node)nodes.get(j), Endpoint.ARROW);
                graph.setEndpoint((Node)nodes.get(j), (Node)nodes.get(i), Endpoint.TAIL);
            }
        }
        return graph;
    }

    public static Clusters mimClusters(Graph mim) {
        ArrayList<Node> latents = new ArrayList<Node>();
        for (Node node : mim.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            latents.add(node);
        }
        Clusters clusters = new Clusters();
        for (int i = 0; i < latents.size(); ++i) {
            Node _latent = (Node)latents.get(i);
            List<Node> adj = mim.getAdjacentNodes(_latent);
            latents.forEach(adj::remove);
            clusters.setClusterName(i, _latent.getName());
            for (Node n : adj) {
                clusters.addToCluster(i, n.getName());
            }
        }
        return clusters;
    }

    public static void logClusters(Set<Set<Integer>> clusters, List<Node> variables) {
        int num = 1;
        StringBuilder buf = new StringBuilder();
        buf.append("\nClusters:\n");
        for (Set<Integer> indices : clusters) {
            buf.append(num++).append(": ");
            ArrayList<Node> _c = new ArrayList<Node>();
            for (int i : indices) {
                _c.add(variables.get(i));
            }
            Collections.sort(_c);
            for (Node n : _c) {
                buf.append(n).append(" ");
            }
            buf.append("\n");
        }
        TetradLogger.getInstance().log("clusters", buf.toString());
    }

    public static List<String> generateLatentNames(int total) {
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < total; ++i) {
            output.add(LATENT_PREFIX + (i + 1));
        }
        return output;
    }
}

