/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.utils.MeekRules;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DagInCpcagIterator {
    private final LinkedList<DecoratedGraph> decoratedGraphs = new LinkedList();
    private final LinkedList<Triple> colliders;
    private final boolean allowNewColliders;
    private Graph storedGraph;
    private boolean returnedOne;

    public DagInCpcagIterator(Graph CPDAG) {
        this(CPDAG, new Knowledge(), false, true);
    }

    public DagInCpcagIterator(Graph CPDAG, Knowledge knowledge) {
        this(CPDAG, knowledge, false, true);
    }

    public DagInCpcagIterator(Graph CPDAG, Knowledge knowledge, boolean allowArbitraryOrientations, boolean allowNewColliders) {
        Knowledge knowledge1 = knowledge == null ? new Knowledge() : knowledge;
        this.allowNewColliders = allowNewColliders;
        assert (knowledge != null);
        if (knowledge.isViolatedBy(CPDAG)) {
            throw new IllegalArgumentException("The CPDAG already violates that knowledge.");
        }
        HashMap<Graph, Set<Edge>> changedEdges = new HashMap<Graph, Set<Edge>>();
        changedEdges.put(CPDAG, new HashSet());
        this.decoratedGraphs.add(new DecoratedGraph(CPDAG, knowledge1, changedEdges, allowArbitraryOrientations));
        this.colliders = GraphUtils.listColliderTriples(CPDAG);
    }

    public Graph next() {
        if (this.storedGraph != null) {
            Graph temp = this.storedGraph;
            this.storedGraph = null;
            return temp;
        }
        if (this.decoratedGraphs.size() == 1 && this.decoratedGraphs.getLast().getEdge() == null && !this.returnedOne) {
            this.returnedOne = true;
            return new EdgeListGraph(this.decoratedGraphs.getLast().getGraph());
        }
        while (true) {
            DecoratedGraph graph;
            if (!this.decoratedGraphs.isEmpty()) {
                graph = this.decoratedGraphs.removeLast();
                if (!graph.isOrientable()) continue;
                this.decoratedGraphs.addLast(graph);
            }
            if (this.decoratedGraphs.isEmpty()) {
                return null;
            }
            while ((graph = this.decoratedGraphs.getLast().orient()) != null) {
                this.decoratedGraphs.addLast(graph);
            }
            if (this.decoratedGraphs.getLast().getEdge() != null || this.allowNewColliders || GraphUtils.listColliderTriples(this.decoratedGraphs.getLast().getGraph()).equals(this.colliders)) break;
        }
        return new EdgeListGraph(this.decoratedGraphs.getLast().getGraph());
    }

    public boolean hasNext() {
        if (this.storedGraph == null) {
            this.storedGraph = this.next();
        }
        return this.storedGraph != null;
    }

    private static class DecoratedGraph {
        private final Graph graph;
        private final Edge edge;
        private final Knowledge knowledge;
        private final boolean allowArbitraryOrientation;
        private boolean triedLeft;
        private boolean triedRight;
        private Map<Graph, Set<Edge>> changedEdges = new HashMap<Graph, Set<Edge>>();

        public DecoratedGraph(Graph graph, Knowledge knowledge, Map<Graph, Set<Edge>> changedEdges, boolean allowArbitraryOrientation) {
            this.graph = graph;
            this.edge = this.findUndirectedEdge(graph);
            this.knowledge = knowledge;
            this.setChangedEdges(new HashMap<Graph, Set<Edge>>(changedEdges));
            this.allowArbitraryOrientation = allowArbitraryOrientation;
        }

        private Edge findUndirectedEdge(Graph graph) {
            for (Edge edge : graph.getEdges()) {
                if (!Edges.isUndirectedEdge(edge) && !Edges.isBidirectedEdge(edge)) continue;
                return edge;
            }
            return null;
        }

        public Graph getGraph() {
            return this.graph;
        }

        public Edge getEdge() {
            return this.edge;
        }

        public String toString() {
            return this.graph.toString();
        }

        public boolean isOrientable() {
            if (this.edge == null) {
                return false;
            }
            Node node1 = this.edge.getNode1();
            Node node2 = this.edge.getNode2();
            return !this.triedLeft && !this.graph.paths().isAncestorOf(node1, node2) && !this.getKnowledge().isForbidden(node2.getName(), node1.getName()) || !this.triedRight && !this.graph.paths().isAncestorOf(node2, node1) && !this.getKnowledge().isForbidden(node1.getName(), node2.getName());
        }

        public DecoratedGraph orient() {
            if (this.edge == null) {
                return null;
            }
            if (!(this.triedLeft || this.graph.paths().isAncestorOf(this.edge.getNode1(), this.edge.getNode2()) || this.getKnowledge().isForbidden(this.edge.getNode2().getName(), this.edge.getNode1().getName()))) {
                HashSet<Edge> edges = new HashSet<Edge>();
                EdgeListGraph graph = new EdgeListGraph(this.graph);
                graph.removeEdges(this.edge.getNode1(), this.edge.getNode2());
                graph.addDirectedEdge(this.edge.getNode2(), this.edge.getNode1());
                graph.getEdge(this.edge.getNode2(), this.edge.getNode1()).setHighlighted(true);
                edges.add(graph.getEdge(this.edge.getNode2(), this.edge.getNode1()));
                edges.addAll(new HashSet(this.getChangedEdges().get(this.graph)));
                MeekRules meek = new MeekRules();
                meek.setKnowledge(this.getKnowledge());
                meek.orientImplied(graph);
                Set<Edge> changedEdges = meek.getChangedEdges().keySet();
                edges.addAll(changedEdges);
                this.getChangedEdges().put(graph, edges);
                for (Edge edge : edges) {
                    edge.setHighlighted(true);
                }
                this.triedLeft = true;
                this.fail(graph, "A");
                return new DecoratedGraph(graph, this.getKnowledge(), this.getChangedEdges(), this.isAllowArbitraryOrientation());
            }
            if (!(this.triedRight || this.graph.paths().isAncestorOf(this.edge.getNode2(), this.edge.getNode1()) || this.getKnowledge().isForbidden(this.edge.getNode1().getName(), this.edge.getNode2().getName()))) {
                HashSet<Edge> edges = new HashSet<Edge>();
                EdgeListGraph graph = new EdgeListGraph(this.graph);
                graph.removeEdges(this.edge.getNode1(), this.edge.getNode2());
                graph.addDirectedEdge(this.edge.getNode1(), this.edge.getNode2());
                graph.getEdge(this.edge.getNode1(), this.edge.getNode2()).setHighlighted(true);
                edges.add(graph.getEdge(this.edge.getNode1(), this.edge.getNode2()));
                edges.addAll(new HashSet(this.getChangedEdges().get(this.graph)));
                MeekRules meek = new MeekRules();
                meek.setKnowledge(this.getKnowledge());
                meek.orientImplied(graph);
                this.getChangedEdges().put(graph, edges);
                for (Edge edge : edges) {
                    edge.setHighlighted(true);
                }
                this.triedRight = true;
                this.fail(graph, "B");
                return new DecoratedGraph(graph, this.getKnowledge(), this.getChangedEdges(), this.isAllowArbitraryOrientation());
            }
            return null;
        }

        private void fail(Graph graph, String label) {
            if (this.knowledge.isViolatedBy(graph)) {
                throw new IllegalArgumentException("Knowledge violated: " + label);
            }
        }

        private Knowledge getKnowledge() {
            return this.knowledge;
        }

        public Map<Graph, Set<Edge>> getChangedEdges() {
            return this.changedEdges;
        }

        public void setChangedEdges(Map<Graph, Set<Edge>> changedEdges) {
            this.changedEdges = changedEdges;
        }

        public boolean isAllowArbitraryOrientation() {
            return this.allowArbitraryOrientation;
        }
    }
}

