/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.utils.SepsetProducer;
import java.util.List;
import java.util.Set;
import javax.help.UnsupportedOperationException;

public class DagSepsets
implements SepsetProducer {
    private final EdgeListGraph dag;

    public DagSepsets(Graph dag) {
        this.dag = new EdgeListGraph(dag);
    }

    @Override
    public Set<Node> getSepset(Node a, Node b) {
        return this.dag.getSepset(a, b);
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        Set<Node> sepset = this.dag.getSepset(i, k);
        return sepset != null && !sepset.contains(j);
    }

    @Override
    public double getScore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIndependent(Node a, Node b, Set<Node> c) {
        return this.dag.paths().isMSeparatedFrom(a, b, c);
    }

    @Override
    public List<Node> getVariables() {
        return this.dag.getNodes();
    }

    @Override
    public void setVerbose(boolean verbose) {
        throw new UnsupportedOperationException("This method is not used for this class.");
    }

    public Graph getDag() {
        return this.dag;
    }
}

