/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.utils.DagSepsets;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;

public final class DagToPag {
    private static final WeakHashMap<Graph, Graph> history = new WeakHashMap();
    private final Graph dag;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Knowledge knowledge = new Knowledge();
    private boolean completeRuleSetUsed = true;
    private boolean verbose;
    private int maxPathLength = -1;
    private boolean doDiscriminatingPathRule = true;

    public DagToPag(Graph dag) {
        this.dag = new EdgeListGraph(dag);
    }

    public static boolean existsInducingPathInto(Node x, Node y, Graph graph) {
        if (x.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        if (y.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        LinkedList<Node> path = new LinkedList<Node>();
        path.add(x);
        for (Node b : graph.getAdjacentNodes(x)) {
            Edge edge = graph.getEdge(x, b);
            if (edge.getProximalEndpoint(x) != Endpoint.ARROW || !graph.paths().existsInducingPathVisit(x, b, x, y, path)) continue;
            return true;
        }
        return false;
    }

    public Graph convert() {
        this.logger.log("info", "Starting DAG to PAG_of_the_true_DAG.");
        if (history.get(this.dag) != null) {
            return history.get(this.dag);
        }
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting adjacency search");
        }
        Graph graph = this.calcAdjacencyGraph();
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting collider orientation");
        }
        this.orientUnshieldedColliders(graph, this.dag);
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting final orientation");
        }
        FciOrient fciOrient = new FciOrient(new DagSepsets(this.dag));
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.setVerbose(false);
        fciOrient.doFinalOrientation(graph);
        if (this.verbose) {
            System.out.println("Finishing final orientation");
        }
        history.put(this.dag, graph);
        return graph;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    private Graph calcAdjacencyGraph() {
        List<Node> allNodes = this.dag.getNodes();
        ArrayList<Node> measured = new ArrayList<Node>(allNodes);
        measured.removeIf(node -> node.getNodeType() == NodeType.LATENT);
        EdgeListGraph graph = new EdgeListGraph(measured);
        for (int i = 0; i < measured.size(); ++i) {
            for (int j = i + 1; j < measured.size(); ++j) {
                boolean exists;
                Node n2;
                Node n1 = (Node)measured.get(i);
                if (graph.isAdjacentTo(n1, n2 = (Node)measured.get(j))) continue;
                List<Node> inducingPath = this.dag.paths().getInducingPath(n1, n2);
                boolean bl = exists = inducingPath != null;
                if (!exists) continue;
                graph.addEdge(Edges.nondirectedEdge(n1, n2));
            }
        }
        return graph;
    }

    private void orientUnshieldedColliders(Graph graph, Graph dag) {
        graph.reorientAllWith(Endpoint.CIRCLE);
        List<Node> allNodes = dag.getNodes();
        ArrayList<Node> measured = new ArrayList<Node>();
        for (Node node : allNodes) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            measured.add(node);
        }
        for (Node b : measured) {
            ArrayList<Node> adjb = new ArrayList<Node>(graph.getAdjacentNodes(b));
            if (adjb.size() < 2) continue;
            for (int i = 0; i < adjb.size(); ++i) {
                for (int j = i + 1; j < adjb.size(); ++j) {
                    boolean found;
                    Node c;
                    Node a = (Node)adjb.get(i);
                    if (graph.isDefCollider(a, b, c = (Node)adjb.get(j)) || graph.isAdjacentTo(a, c) || !(found = this.foundCollider(dag, a, b, c))) continue;
                    if (this.verbose) {
                        System.out.println("Orienting collider " + a + "*->" + b + "<-*" + c);
                    }
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    graph.setEndpoint(c, b, Endpoint.ARROW);
                }
            }
        }
    }

    private boolean foundCollider(Graph dag, Node a, Node b, Node c) {
        boolean ipba = DagToPag.existsInducingPathInto(b, a, dag);
        boolean ipbc = DagToPag.existsInducingPathInto(b, c, dag);
        return ipba && ipbc;
    }
}

